/*
 * Decompiled with CFR 0.152.
 */
package pl.baczkowicz.mqttspy.ui.controllers;

import javafx.fxml.Initializable;
import pl.baczkowicz.mqttspy.connectivity.MqttAsyncConnection;
import pl.baczkowicz.mqttspy.ui.scripts.InteractiveMqttScriptManager;
import pl.baczkowicz.spy.ui.controllers.BasePublicationScriptsController;
import pl.baczkowicz.spy.ui.panes.TitledPaneController;
import pl.baczkowicz.spy.ui.scripts.ScriptTypeEnum;
import pl.baczkowicz.spy.ui.scripts.events.ScriptListChangeEvent;

public class MqttPublicationScriptsController
extends BasePublicationScriptsController
implements Initializable,
TitledPaneController {
    private MqttAsyncConnection connection;

    @Override
    public void init() {
        super.init();
        this.scriptManager = this.connection.getScriptManager();
        this.publicationScriptsDirectory = InteractiveMqttScriptManager.getScriptDirectoryForConnection(this.connection.getProperties().getConfiguredProperties().getPublicationScripts());
        this.refreshList();
        this.scriptTable.setItems(this.scriptManager.getObservableScriptList());
    }

    @Override
    protected void refreshList() {
        this.scriptManager.addScripts(this.publicationScriptsDirectory, this.includeSubdirectories, ScriptTypeEnum.PUBLICATION);
        this.scriptManager.addScripts(this.connection.getProperties().getConfiguredProperties().getBackgroundScript(), ScriptTypeEnum.BACKGROUND);
        ((InteractiveMqttScriptManager)this.scriptManager).addSubscriptionScripts(this.connection.getProperties().getConfiguredProperties().getSubscription());
        this.eventBus.publish(new ScriptListChangeEvent(this.connection));
    }

    public void setConnection(MqttAsyncConnection connection) {
        this.connection = connection;
    }
}

