/*
 * Decompiled with CFR 0.152.
 */
package pl.baczkowicz.mqttspy.ui.controllers;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.ResourceBundle;
import javafx.application.Platform;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonType;
import javafx.scene.control.ComboBox;
import javafx.scene.control.ListCell;
import javafx.scene.control.ListView;
import javafx.scene.control.Tab;
import javafx.scene.control.TabPane;
import javafx.scene.control.TextField;
import javafx.scene.layout.AnchorPane;
import javafx.stage.Stage;
import javafx.util.Callback;
import javafx.util.StringConverter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pl.baczkowicz.mqttspy.common.generated.MessageLog;
import pl.baczkowicz.mqttspy.configuration.ConfigurationUtils;
import pl.baczkowicz.mqttspy.configuration.ConfiguredMqttConnectionDetails;
import pl.baczkowicz.mqttspy.configuration.generated.UserInterfaceMqttConnectionDetails;
import pl.baczkowicz.mqttspy.connectivity.MqttAsyncConnection;
import pl.baczkowicz.mqttspy.ui.MqttConnectionViewManager;
import pl.baczkowicz.mqttspy.ui.controllers.edit.EditConnectionConnectivityController;
import pl.baczkowicz.mqttspy.ui.controllers.edit.EditConnectionLastWillController;
import pl.baczkowicz.mqttspy.ui.controllers.edit.EditConnectionMessageLogController;
import pl.baczkowicz.mqttspy.ui.controllers.edit.EditConnectionOtherController;
import pl.baczkowicz.mqttspy.ui.controllers.edit.EditConnectionPublicationsController;
import pl.baczkowicz.mqttspy.ui.controllers.edit.EditConnectionSecurityController;
import pl.baczkowicz.mqttspy.ui.controllers.edit.EditConnectionSubscriptionsController;
import pl.baczkowicz.mqttspy.ui.utils.ConnectivityUtils;
import pl.baczkowicz.mqttspy.utils.ConnectionUtils;
import pl.baczkowicz.spy.common.generated.ConnectionGroupReference;
import pl.baczkowicz.spy.eventbus.IKBus;
import pl.baczkowicz.spy.exceptions.ConfigurationException;
import pl.baczkowicz.spy.ui.configuration.IConfigurationManager;
import pl.baczkowicz.spy.ui.controllers.EditConnectionsController;
import pl.baczkowicz.spy.ui.events.ConnectionNameChangedEvent;
import pl.baczkowicz.spy.ui.panes.SpyPerspective;
import pl.baczkowicz.spy.ui.utils.DialogFactory;
import pl.baczkowicz.spy.ui.utils.TooltipFactory;

public class EditMqttConnectionController
extends AnchorPane
implements Initializable {
    static final Logger logger = LoggerFactory.getLogger(EditMqttConnectionController.class);
    private SpyPerspective perspective;
    private List<Tab> tabs;
    @FXML
    private TextField connectionNameText;
    @FXML
    private ComboBox<SpyPerspective> perspectiveCombo;
    @FXML
    private Tab publicationsTab;
    @FXML
    private Tab subscriptionsTab;
    @FXML
    private Tab otherTab;
    @FXML
    private Tab logTab;
    @FXML
    private Tab ltwTab;
    @FXML
    private TabPane tabPane;
    @FXML
    private Button connectButton;
    @FXML
    private Button cancelButton;
    @FXML
    private Button saveButton;
    @FXML
    private Button undoButton;
    @FXML
    private EditConnectionConnectivityController editConnectionConnectivityController;
    @FXML
    private EditConnectionLastWillController editConnectionLastWillController;
    @FXML
    private EditConnectionMessageLogController editConnectionMessageLogController;
    @FXML
    private EditConnectionOtherController editConnectionOtherController;
    @FXML
    private EditConnectionPublicationsController editConnectionPublicationsController;
    @FXML
    private EditConnectionSecurityController editConnectionSecurityController;
    @FXML
    private EditConnectionSubscriptionsController editConnectionSubscriptionsController;
    private String lastGeneratedConnectionName = "";
    private ConfiguredMqttConnectionDetails editedConnectionDetails;
    private boolean recordModifications;
    private IConfigurationManager configurationManager;
    private EditConnectionsController editConnectionsController;
    private boolean openNewMode;
    private MqttAsyncConnection existingConnection;
    private int noModificationsLock;
    private MqttConnectionViewManager connectionManager;
    private boolean emptyConnectionList;
    private IKBus eventBus;

    public void initialize(URL location, ResourceBundle resources) {
        this.connectionNameText.textProperty().addListener(new ChangeListener(){

            public void changed(ObservableValue observable, Object oldValue, Object newValue) {
                EditMqttConnectionController.this.onChange();
            }
        });
        this.editConnectionConnectivityController.setParent(this);
        this.editConnectionLastWillController.setParent(this);
        this.editConnectionMessageLogController.setParent(this);
        this.editConnectionOtherController.setParent(this);
        this.editConnectionPublicationsController.setParent(this);
        this.editConnectionSecurityController.setParent(this);
        this.editConnectionSubscriptionsController.setParent(this);
        this.tabs = new ArrayList<Tab>((Collection<Tab>)this.tabPane.getTabs());
    }

    private String getPerspectiveString(SpyPerspective item) {
        if (item.equals((Object)SpyPerspective.BASIC)) {
            return "Basic - the absolute minimum";
        }
        if (item.equals((Object)SpyPerspective.DEFAULT)) {
            return "Default - simpified properties";
        }
        if (item.equals((Object)SpyPerspective.DETAILED)) {
            return "Detailed - all properties";
        }
        if (item.equals((Object)SpyPerspective.SPY)) {
            return "Spy - simplified subscriptions";
        }
        if (item.equals((Object)SpyPerspective.SUPER_SPY)) {
            return "Super Spy - subscriptions only";
        }
        return null;
    }

    public void init() {
        for (SpyPerspective sp : SpyPerspective.values()) {
            this.perspectiveCombo.getItems().add((Object)sp);
        }
        this.perspectiveCombo.getSelectionModel().selectedIndexProperty().addListener((ChangeListener)new ChangeListener<Number>(){

            public void changed(ObservableValue<? extends Number> observable, Number oldValue, Number newValue) {
                EditMqttConnectionController.this.updatePerspective((SpyPerspective)((Object)EditMqttConnectionController.this.perspectiveCombo.getSelectionModel().getSelectedItem()));
            }
        });
        this.perspectiveCombo.setCellFactory((Callback)new Callback<ListView<SpyPerspective>, ListCell<SpyPerspective>>(){

            public ListCell<SpyPerspective> call(ListView<SpyPerspective> l) {
                return new ListCell<SpyPerspective>(){

                    protected void updateItem(SpyPerspective item, boolean empty) {
                        super.updateItem((Object)item, empty);
                        if (item == null || empty) {
                            this.setText(null);
                        } else {
                            this.setText(EditMqttConnectionController.this.getPerspectiveString(item));
                        }
                    }
                };
            }
        });
        this.perspectiveCombo.setConverter((StringConverter)new StringConverter<SpyPerspective>(){

            public String toString(SpyPerspective item) {
                if (item == null) {
                    return null;
                }
                return EditMqttConnectionController.this.getPerspectiveString(item);
            }

            public SpyPerspective fromString(String id) {
                return null;
            }
        });
        this.editConnectionOtherController.setEventBus(this.eventBus);
        this.editConnectionOtherController.setConfigurationManager(this.configurationManager);
        this.editConnectionConnectivityController.init();
        this.editConnectionLastWillController.init();
        this.editConnectionMessageLogController.init();
        this.editConnectionOtherController.init();
        this.editConnectionPublicationsController.init();
        this.editConnectionSecurityController.init();
        this.editConnectionSubscriptionsController.init();
        this.getConnectionName().textProperty().addListener(new ChangeListener(){

            public void changed(ObservableValue observable, Object oldValue, Object newValue) {
                if (EditMqttConnectionController.this.isRecordModifications()) {
                    EditMqttConnectionController.this.eventBus.publish(new ConnectionNameChangedEvent(EditMqttConnectionController.this.getConnectionName().getText()));
                }
            }
        });
    }

    private void updatePerspective(SpyPerspective perspective) {
        this.editConnectionConnectivityController.setPerspective(perspective);
        this.tabPane.getTabs().clear();
        this.tabPane.getTabs().addAll(this.tabs);
        if (perspective.equals((Object)SpyPerspective.BASIC) || perspective.equals((Object)SpyPerspective.SPY) || perspective.equals((Object)SpyPerspective.SUPER_SPY)) {
            this.tabPane.getTabs().remove((Object)this.publicationsTab);
        }
        if (perspective.equals((Object)SpyPerspective.BASIC)) {
            this.tabPane.getTabs().remove((Object)this.subscriptionsTab);
            this.tabPane.getTabs().remove((Object)this.otherTab);
            this.tabPane.getTabs().remove((Object)this.logTab);
            this.tabPane.getTabs().remove((Object)this.ltwTab);
        }
    }

    @FXML
    private void addTimestamp() {
        this.editConnectionConnectivityController.updateClientId(true);
    }

    @FXML
    private void undo() {
        this.editedConnectionDetails.undo();
        this.editConnectionsController.listConnections();
        this.updateButtons();
    }

    @FXML
    private void save() {
        if (this.configurationManager.isConfigurationWritable()) {
            logger.debug("Saving connection " + this.getConnectionName().getText());
            if (this.configurationManager.saveConfiguration()) {
                this.editedConnectionDetails.apply();
                this.editConnectionsController.listConnections();
                this.updateButtons();
                TooltipFactory.createTooltip(this.saveButton, "Changes for connection " + this.editedConnectionDetails.getName() + " have been saved.");
            } else {
                DialogFactory.createErrorDialog("Cannot save the configuration file", "Oops... an error has occurred while trying to save your configuration. Please check the log file for more information. Your changes were not saved.");
            }
        } else {
            DialogFactory.createErrorDialog("Cannot save the configuration file", "Oops... your configuration file isn't right. Please restore default configuration. ");
        }
    }

    @FXML
    private void cancel() {
        Stage stage = (Stage)this.cancelButton.getScene().getWindow();
        stage.close();
    }

    public void openConnection(final ConfiguredMqttConnectionDetails connectionDetails) {
        String validationResult = ConnectivityUtils.validateConnectionDetails(connectionDetails, false);
        if (validationResult != null) {
            DialogFactory.createWarningDialog("Invalid value detected", validationResult);
        } else {
            if (connectionDetails.isModified()) {
                Optional<ButtonType> response = DialogFactory.createQuestionDialog("Unsaved changes detected", "You've got unsaved changes for connection " + connectionDetails.getName() + ". Do you want to save/apply them now?", true);
                if (response.get() == ButtonType.YES) {
                    this.save();
                } else if (response.get() != ButtonType.NO) {
                    return;
                }
            }
            this.checkIfOpened(connectionDetails.getID());
            if (!this.openNewMode) {
                this.connectionManager.disconnectAndCloseTab(this.existingConnection);
            }
            logger.info("Opening connection " + this.getConnectionName().getText());
            Stage stage = (Stage)this.connectButton.getScene().getWindow();
            stage.close();
            Platform.runLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    try {
                        EditMqttConnectionController.this.connectionManager.openConnection(connectionDetails);
                    }
                    catch (ConfigurationException e) {
                        logger.error("Cannot open conection {}", (Object)connectionDetails.getName(), (Object)e);
                    }
                }
            });
        }
    }

    @FXML
    public void readAndOpenConnection() throws ConfigurationException {
        this.readAndDetectChanges();
        this.openConnection(this.editedConnectionDetails);
    }

    public void updateConnectionName() {
        if (this.connectionNameText.getText().isEmpty() || this.lastGeneratedConnectionName.equals(this.connectionNameText.getText())) {
            String newName = ConnectionUtils.composeConnectionName(this.editConnectionConnectivityController.getClientIdText().getText(), this.editConnectionConnectivityController.getBrokerAddressText().getText());
            this.connectionNameText.setText(newName);
            this.lastGeneratedConnectionName = newName;
        }
    }

    public void onChange() {
        if (this.recordModifications && !this.emptyConnectionList && this.readAndDetectChanges()) {
            this.updateButtons();
            this.editConnectionConnectivityController.updateClientId(false);
            this.editConnectionConnectivityController.updateClientIdLength();
            this.updateConnectionName();
            this.editConnectionConnectivityController.updateReconnection();
            this.editConnectionSecurityController.updateUserAuthentication();
            this.editConnectionsController.listConnections();
        }
    }

    private UserInterfaceMqttConnectionDetails readValues() {
        UserInterfaceMqttConnectionDetails connection = new UserInterfaceMqttConnectionDetails();
        connection.setMessageLog(new MessageLog());
        ConfigurationUtils.populateConnectionDefaults(connection);
        connection.setName(this.connectionNameText.getText());
        this.editConnectionConnectivityController.readValues(connection);
        this.editConnectionOtherController.readValues(connection);
        this.editConnectionSecurityController.readValues(connection);
        this.editConnectionMessageLogController.readValues(connection);
        this.editConnectionPublicationsController.readValues(connection);
        this.editConnectionSubscriptionsController.readValues(connection);
        this.editConnectionLastWillController.readValues(connection);
        return connection;
    }

    private boolean readAndDetectChanges() {
        ConfiguredMqttConnectionDetails connection = new ConfiguredMqttConnectionDetails(null, this.readValues());
        ConnectionGroupReference group = this.editedConnectionDetails.getGroup();
        String id = this.editedConnectionDetails.getID();
        connection.setGroup(group);
        connection.setID(id);
        boolean changed = !connection.equals(this.editedConnectionDetails.getSavedValues());
        logger.debug("Values read. Changed = " + changed);
        if (changed) {
            logger.debug("New value = {}", (Object)connection.toString());
            logger.debug("Old value = {}", (Object)this.editedConnectionDetails.getSavedValues().toString());
        }
        this.editedConnectionDetails.setModified(changed);
        this.editedConnectionDetails.setConnectionDetails(connection);
        this.editedConnectionDetails.setGroup(group);
        this.editedConnectionDetails.setID(id);
        return changed;
    }

    public void checkIfOpened(String id) {
        this.openNewMode = true;
        for (MqttAsyncConnection mqttConnection : this.connectionManager.getMqttConnections()) {
            if (!id.equals(mqttConnection.getProperties().getConfiguredProperties().getID()) || !mqttConnection.isOpened()) continue;
            this.openNewMode = false;
            this.existingConnection = mqttConnection;
            this.connectButton.setText("Close and re-open existing connection");
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void editConnection(ConfiguredMqttConnectionDetails connectionDetails) {
        EditMqttConnectionController editMqttConnectionController = this;
        synchronized (editMqttConnectionController) {
            this.editedConnectionDetails = connectionDetails;
            this.openNewMode = true;
            this.existingConnection = null;
            this.connectButton.setText("Open connection");
            logger.debug("Editing connection id={} name={}", (Object)this.editedConnectionDetails.getID(), (Object)this.editedConnectionDetails.getName());
            this.checkIfOpened(connectionDetails.getID());
            this.lastGeneratedConnectionName = this.editedConnectionDetails.getName().equals(ConnectionUtils.composeConnectionName(this.editedConnectionDetails.getClientID(), this.editedConnectionDetails.getServerURI())) ? this.editedConnectionDetails.getName() : "";
            this.displayConnectionDetails(this.editedConnectionDetails);
            this.editConnectionConnectivityController.updateClientIdLength();
            this.updateConnectionName();
            this.updateButtons();
        }
    }

    private void updateButtons() {
        if (this.editedConnectionDetails != null && this.editedConnectionDetails.isModified()) {
            this.saveButton.setDisable(false);
            this.undoButton.setDisable(false);
        } else {
            this.saveButton.setDisable(true);
            this.undoButton.setDisable(true);
        }
    }

    private void displayConnectionDetails(ConfiguredMqttConnectionDetails connection) {
        ConfigurationUtils.populateConnectionDefaults(connection);
        this.connectionNameText.setText(connection.getName());
        this.editConnectionConnectivityController.displayConnectionDetails(connection);
        this.editConnectionSecurityController.displayConnectionDetails(connection);
        this.editConnectionMessageLogController.displayConnectionDetails(connection);
        this.editConnectionOtherController.displayConnectionDetails(connection);
        this.editConnectionPublicationsController.displayConnectionDetails(connection);
        this.editConnectionSubscriptionsController.displayConnectionDetails(connection);
        this.editConnectionLastWillController.displayConnectionDetails(connection);
        connection.setBeingCreated(false);
    }

    public void setConfigurationManager(IConfigurationManager configurationManager) {
        this.configurationManager = configurationManager;
    }

    public void setEditConnectionsController(EditConnectionsController editConnectionsController) {
        this.editConnectionsController = editConnectionsController;
    }

    public void setRecordModifications(boolean recordModifications) {
        if (!recordModifications) {
            logger.trace("Modifications suspended...");
            ++this.noModificationsLock;
            this.recordModifications = recordModifications;
        } else {
            --this.noModificationsLock;
            if (this.noModificationsLock == 0) {
                logger.trace("Modifications restored...");
                this.recordModifications = recordModifications;
            }
        }
    }

    public boolean isRecordModifications() {
        return this.recordModifications;
    }

    public void setEmptyConnectionListMode(boolean emptyConnectionList) {
        this.emptyConnectionList = emptyConnectionList;
        this.connectButton.setDisable(emptyConnectionList);
        this.updateButtons();
    }

    public void setConnectionManager(MqttConnectionViewManager connectionManager) {
        this.connectionManager = connectionManager;
    }

    public TextField getConnectionName() {
        return this.connectionNameText;
    }

    public ConfiguredMqttConnectionDetails getEditedConnectionDetails() {
        return this.editedConnectionDetails;
    }

    public SpyPerspective getPerspective() {
        return this.perspective;
    }

    public void setPerspective(SpyPerspective perspective) {
        this.perspective = perspective;
        this.perspectiveCombo.getSelectionModel().select((Object)perspective);
    }

    public void setEventBus(IKBus eventBus) {
        this.eventBus = eventBus;
    }
}

