/*
 * Decompiled with CFR 0.152.
 */
package pl.baczkowicz.mqttspy.ui;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import javafx.fxml.FXMLLoader;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.MenuItem;
import javafx.scene.control.Tab;
import javafx.scene.control.TabPane;
import javafx.scene.control.Tooltip;
import javafx.scene.layout.AnchorPane;
import javafx.scene.paint.Color;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pl.baczkowicz.mqttspy.configuration.generated.TabbedSubscriptionDetails;
import pl.baczkowicz.mqttspy.connectivity.MqttAsyncConnection;
import pl.baczkowicz.mqttspy.connectivity.MqttSubscription;
import pl.baczkowicz.mqttspy.messages.FormattedMqttMessage;
import pl.baczkowicz.mqttspy.scripts.MqttScriptManager;
import pl.baczkowicz.mqttspy.ui.MqttViewManager;
import pl.baczkowicz.mqttspy.ui.controllers.MqttConnectionController;
import pl.baczkowicz.mqttspy.ui.controllers.SubscriptionController;
import pl.baczkowicz.mqttspy.ui.events.SubscriptionStatusChangeEvent;
import pl.baczkowicz.mqttspy.ui.utils.ContextMenuUtils;
import pl.baczkowicz.spy.connectivity.ConnectionStatus;
import pl.baczkowicz.spy.eventbus.IKBus;
import pl.baczkowicz.spy.formatting.FormattingManager;
import pl.baczkowicz.spy.ui.configuration.IConfigurationManager;
import pl.baczkowicz.spy.ui.configuration.UiProperties;
import pl.baczkowicz.spy.ui.events.queuable.EventQueueManager;
import pl.baczkowicz.spy.ui.panes.PaneVisibilityStatus;
import pl.baczkowicz.spy.ui.panes.SpyPerspective;
import pl.baczkowicz.spy.ui.panes.TabStatus;
import pl.baczkowicz.spy.ui.storage.ManagedMessageStoreWithFiltering;
import pl.baczkowicz.spy.ui.utils.FxmlUtils;
import pl.baczkowicz.spy.ui.utils.StylingUtils;
import pl.baczkowicz.spy.ui.utils.TabUtils;

public class MqttSubscriptionViewManager {
    public static String ALL_SUBSCRIPTIONS_TAB_TITLE = "All";
    public static int ALL_SUBSCRIPTIONS_TAB_INDEX = 0;
    private static final Logger logger = LoggerFactory.getLogger(MqttSubscriptionViewManager.class);
    private final Map<String, SubscriptionController> subscriptionControllers = new LinkedHashMap<String, SubscriptionController>();
    private final EventQueueManager<FormattedMqttMessage> uiEventQueue;
    private IConfigurationManager configurationManager;
    private MqttViewManager viewManager;
    private IKBus eventBus;

    public MqttSubscriptionViewManager(IKBus eventBus, IConfigurationManager configurationManager, MqttViewManager viewManager, EventQueueManager<FormattedMqttMessage> uiEventQueue) {
        this.eventBus = eventBus;
        this.configurationManager = configurationManager;
        this.viewManager = viewManager;
        this.uiEventQueue = uiEventQueue;
    }

    public void createSubscription(Color color, boolean subscribe, TabbedSubscriptionDetails subscriptionDetails, MqttAsyncConnection connection, MqttConnectionController connectionController, Object parent) {
        logger.info("Creating subscription for " + subscriptionDetails.getTopic());
        MqttSubscription subscription = new MqttSubscription(subscriptionDetails.getTopic(), subscriptionDetails.getQos(), color, connection.getProperties().getConfiguredProperties().getMinMessagesStoredPerTopic(), connection.getPreferredStoreSize(), this.uiEventQueue, this.eventBus, connection.getStore().getFormattingManager(), UiProperties.getSummaryMaxPayloadLength(this.configurationManager.getUiPropertyFile()));
        subscription.setConnection(connection);
        subscription.setDetails(subscriptionDetails);
        SubscriptionController subscriptionController = this.createSubscriptionTab(false, (ManagedMessageStoreWithFiltering<FormattedMqttMessage>)subscription.getStore(), subscription, connection, connectionController);
        subscriptionController.getTab().setContextMenu(ContextMenuUtils.createSubscriptionTabContextMenu(connection, subscription, this.eventBus, this, this.configurationManager, subscriptionController));
        subscriptionController.setConnectionController(connectionController);
        subscriptionController.setFormatters(this.configurationManager.getFormatters());
        subscriptionController.setTabStatus(new TabStatus());
        subscriptionController.getTabStatus().setVisibility(PaneVisibilityStatus.NOT_VISIBLE);
        subscriptionController.init();
        subscriptionController.onSubscriptionStatusChanged(new SubscriptionStatusChangeEvent(subscription));
        subscription.setSubscriptionController(subscriptionController);
        SpyPerspective perspective = this.viewManager.getPerspective();
        subscriptionController.setViewVisibility(MqttViewManager.getDetailedViewStatus(perspective), MqttViewManager.getBasicViewStatus(perspective));
        subscriptionController.getTabStatus().setVisibility(PaneVisibilityStatus.ATTACHED);
        subscriptionController.getTabStatus().setParent(connectionController.getSubscriptionTabs());
        TabPane subscriptionTabs = connectionController.getSubscriptionTabs();
        subscriptionTabs.getTabs().add((Object)subscriptionController.getTab());
        ((Tab)subscriptionTabs.getTabs().get(ALL_SUBSCRIPTIONS_TAB_INDEX)).setDisable(false);
        if (subscribe) {
            logger.debug("Trying to subscribe {}", (Object)subscription.getTopic());
            connection.subscribe(subscription);
        } else {
            connection.addSubscription(subscription);
            subscription.setActive(false);
        }
    }

    public SubscriptionController createSubscriptionTab(boolean allTab, ManagedMessageStoreWithFiltering<FormattedMqttMessage> observableMessageStore, MqttSubscription subscription, MqttAsyncConnection connection, MqttConnectionController connectionController) {
        FXMLLoader loader = FxmlUtils.createFxmlLoaderForProjectFile("SubscriptionMessageListPane.fxml");
        AnchorPane subscriptionPane = FxmlUtils.loadAnchorPane(loader);
        SubscriptionController subscriptionController = (SubscriptionController)loader.getController();
        Tab tab = new Tab();
        if (subscription != null) {
            this.eventBus.subscribeWithFilterOnly(subscriptionController, subscriptionController::onSubscriptionStatusChanged, SubscriptionStatusChangeEvent.class, subscription);
        }
        subscriptionController.setStore(observableMessageStore);
        subscriptionController.setEventBus(this.eventBus);
        subscriptionController.setConfingurationManager(this.configurationManager);
        if (connection != null) {
            subscriptionController.setFormattingManager(connection.getStore().getFormattingManager());
            subscriptionController.setConnectionProperties(connection.getProperties());
        } else {
            subscriptionController.setFormattingManager(new FormattingManager(new MqttScriptManager(null, null, null)));
        }
        subscriptionController.setTab(tab);
        subscriptionController.toggleMessagePayloadSize(connectionController.getResizeMessageContentMenu().isSelected());
        tab.setClosable(false);
        tab.setContent((Node)subscriptionPane);
        if (subscription != null) {
            tab.setStyle(StylingUtils.createBaseRGBString(subscription.getColor()));
        }
        if (allTab) {
            this.subscriptionControllers.put(ALL_SUBSCRIPTIONS_TAB_TITLE, subscriptionController);
            tab.setGraphic((Node)new Label(ALL_SUBSCRIPTIONS_TAB_TITLE));
            tab.getGraphic().getStyleClass().add((Object)"subscribed");
        } else {
            logger.debug("Mapping subscription topic {} to controller", (Object)subscription.getTopic());
            this.subscriptionControllers.put(subscription.getTopic(), subscriptionController);
            tab.setGraphic((Node)new Label(subscription.getTopic()));
            tab.getGraphic().getStyleClass().add((Object)"unsubscribed");
            tab.setTooltip(new Tooltip("Status: unsubscribed"));
        }
        return subscriptionController;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeSubscription(String topic) {
        Map<String, SubscriptionController> map = this.subscriptionControllers;
        synchronized (map) {
            logger.debug("Trying to remove subscription {}", (Object)topic);
            MqttSubscription subscription = this.subscriptionControllers.get(topic).getSubscription();
            subscription.getConnection().unsubscribeAndRemove(subscription);
            ((ManagedMessageStoreWithFiltering)subscription.getStore()).cleanUp();
            this.subscriptionControllers.get(topic).onClose();
            TabUtils.requestClose(this.subscriptionControllers.get(topic).getTab());
            this.subscriptionControllers.remove(topic);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<SubscriptionController> getSubscriptionControllers() {
        Map<String, SubscriptionController> map = this.subscriptionControllers;
        synchronized (map) {
            return Collections.unmodifiableCollection(this.subscriptionControllers.values());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, SubscriptionController> getSubscriptionControllersMap() {
        Map<String, SubscriptionController> map = this.subscriptionControllers;
        synchronized (map) {
            return Collections.unmodifiableMap(this.subscriptionControllers);
        }
    }

    public static void updateSubscriptionTabContextMenu(Tab tab, MqttSubscription subscription) {
        logger.debug("Updating subscription tab context menu [{}, {}, {}]", new Object[]{subscription.getTopic(), subscription.getConnection().getConnectionStatus(), subscription.isActive()});
        tab.getGraphic().getStyleClass().remove(tab.getGraphic().getStyleClass().size() - 1);
        if (subscription.isActive()) {
            tab.getGraphic().getStyleClass().add((Object)"subscribed");
            tab.getTooltip().setText("Status: subscribed");
        } else {
            tab.getGraphic().getStyleClass().add((Object)"unsubscribed");
            tab.getTooltip().setText("Status: unsubscribed");
        }
        if (subscription.getConnection().getConnectionStatus().equals((Object)ConnectionStatus.CONNECTED)) {
            if (subscription.isActive()) {
                ((MenuItem)tab.getContextMenu().getItems().get(0)).setDisable(false);
                ((MenuItem)tab.getContextMenu().getItems().get(1)).setDisable(true);
            } else {
                ((MenuItem)tab.getContextMenu().getItems().get(0)).setDisable(true);
                ((MenuItem)tab.getContextMenu().getItems().get(1)).setDisable(false);
            }
            ((MenuItem)tab.getContextMenu().getItems().get(2)).setDisable(false);
        } else {
            ((MenuItem)tab.getContextMenu().getItems().get(0)).setDisable(true);
            ((MenuItem)tab.getContextMenu().getItems().get(1)).setDisable(true);
            ((MenuItem)tab.getContextMenu().getItems().get(2)).setDisable(true);
        }
    }
}

