/*
 * Decompiled with CFR 0.152.
 */
package pl.baczkowicz.mqttspy.ui;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.LinkedBlockingQueue;
import javafx.application.Platform;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.scene.control.Tab;
import javafx.stage.Stage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pl.baczkowicz.mqttspy.common.generated.MessageLog;
import pl.baczkowicz.mqttspy.common.generated.MessageLogEnum;
import pl.baczkowicz.mqttspy.configuration.ConfiguredMqttConnectionDetails;
import pl.baczkowicz.mqttspy.configuration.generated.UserInterfaceMqttConnectionDetails;
import pl.baczkowicz.mqttspy.connectivity.BaseMqttSubscription;
import pl.baczkowicz.mqttspy.connectivity.MqttAsyncConnection;
import pl.baczkowicz.mqttspy.connectivity.MqttAsyncConnectionRunnable;
import pl.baczkowicz.mqttspy.connectivity.MqttRuntimeConnectionProperties;
import pl.baczkowicz.mqttspy.connectivity.handlers.MqttCallbackHandler;
import pl.baczkowicz.mqttspy.connectivity.handlers.MqttDisconnectionResultHandler;
import pl.baczkowicz.mqttspy.connectivity.handlers.MqttEventHandler;
import pl.baczkowicz.mqttspy.logger.MqttMessageLogger;
import pl.baczkowicz.mqttspy.messages.FormattedMqttMessage;
import pl.baczkowicz.mqttspy.ui.MqttSubscriptionViewManager;
import pl.baczkowicz.mqttspy.ui.MqttViewManager;
import pl.baczkowicz.mqttspy.ui.controllers.MqttConnectionController;
import pl.baczkowicz.mqttspy.ui.events.queuable.UIEventHandler;
import pl.baczkowicz.mqttspy.ui.events.queuable.connectivity.MqttConnectionAttemptFailureEvent;
import pl.baczkowicz.mqttspy.ui.events.queuable.connectivity.MqttDisconnectionAttemptFailureEvent;
import pl.baczkowicz.mqttspy.ui.scripts.InteractiveMqttScriptManager;
import pl.baczkowicz.mqttspy.ui.utils.ConnectivityUtils;
import pl.baczkowicz.mqttspy.ui.utils.DialogUtils;
import pl.baczkowicz.spy.common.generated.UserCredentials;
import pl.baczkowicz.spy.connectivity.ConnectionStatus;
import pl.baczkowicz.spy.connectivity.ReconnectionManager;
import pl.baczkowicz.spy.eventbus.IKBus;
import pl.baczkowicz.spy.exceptions.ConfigurationException;
import pl.baczkowicz.spy.exceptions.SpyException;
import pl.baczkowicz.spy.formatting.FormattingManager;
import pl.baczkowicz.spy.ui.IConnectionViewManager;
import pl.baczkowicz.spy.ui.configuration.IConfigurationManager;
import pl.baczkowicz.spy.ui.configuration.UiProperties;
import pl.baczkowicz.spy.ui.connections.IUiConnection;
import pl.baczkowicz.spy.ui.controllers.IConnectionController;
import pl.baczkowicz.spy.ui.events.queuable.EventQueueManager;
import pl.baczkowicz.spy.ui.properties.ModifiableConnection;
import pl.baczkowicz.spy.ui.stats.StatisticsManager;
import pl.baczkowicz.spy.ui.utils.DialogFactory;
import pl.baczkowicz.spy.ui.utils.TabUtils;

public class MqttConnectionViewManager
implements IConnectionViewManager {
    private static final Logger logger = LoggerFactory.getLogger(MqttConnectionViewManager.class);
    private final IKBus eventBus;
    private final IConfigurationManager configurationManager;
    private Map<String, MqttAsyncConnection> connections = new HashMap<String, MqttAsyncConnection>();
    private final Map<MqttAsyncConnection, MqttConnectionController> connectionControllersMapping = new HashMap<MqttAsyncConnection, MqttConnectionController>();
    private final Map<MqttAsyncConnection, Tab> connectionTabs = new HashMap<MqttAsyncConnection, Tab>();
    private final Map<MqttConnectionController, MqttSubscriptionViewManager> subscriptionManagers = new HashMap<MqttConnectionController, MqttSubscriptionViewManager>();
    private Stage parentStage;
    private final EventQueueManager<FormattedMqttMessage> uiEventQueue;
    private MqttViewManager viewManager;
    private ReconnectionManager reconnectionManager;
    private Set<MqttConnectionController> offlineConnectionControllers = new HashSet<MqttConnectionController>();

    public MqttConnectionViewManager(IKBus eventBus, StatisticsManager statisticsManager, IConfigurationManager configurationManager) {
        this.uiEventQueue = new EventQueueManager();
        this.eventBus = eventBus;
        this.configurationManager = configurationManager;
        this.reconnectionManager = new ReconnectionManager();
        new Thread(this.reconnectionManager).start();
        new Thread(new UIEventHandler(this.uiEventQueue, eventBus)).start();
    }

    @Override
    public void openConnection(ModifiableConnection configuredConnectionDetails) throws ConfigurationException {
        ConfiguredMqttConnectionDetails connectionDetails = new ConfiguredMqttConnectionDetails();
        connectionDetails.setConnectionDetails(configuredConnectionDetails);
        connectionDetails.setID(configuredConnectionDetails.getID());
        boolean cancelled = this.completeUserAuthenticationCredentials(connectionDetails, this.parentStage);
        if (!cancelled) {
            String validationResult = ConnectivityUtils.validateConnectionDetails(connectionDetails, true);
            if (validationResult != null) {
                DialogFactory.createWarningDialog("Invalid value detected", validationResult);
            } else {
                try {
                    final MqttRuntimeConnectionProperties connectionProperties = new MqttRuntimeConnectionProperties(connectionDetails);
                    new Thread(new Runnable(){

                        @Override
                        public void run() {
                            MqttConnectionViewManager.this.viewManager.loadConnectionTab(connectionProperties);
                        }
                    }).start();
                }
                catch (ConfigurationException e) {
                    logger.error("Cannot create connection properties", e);
                    DialogFactory.createExceptionDialog("Invalid configuration detected", e);
                }
            }
        }
    }

    private boolean completeUserAuthenticationCredentials(UserInterfaceMqttConnectionDetails connectionDetails, Stage stage) {
        if (connectionDetails.getUserAuthentication() != null) {
            UserCredentials userCredentials = new UserCredentials();
            connectionDetails.getUserCredentials().copyTo(userCredentials);
            if ((connectionDetails.getUserAuthentication().isAskForPassword() || connectionDetails.getUserAuthentication().isAskForUsername()) && !DialogUtils.createMqttUsernameAndPasswordDialog(stage, connectionDetails.getName(), userCredentials)) {
                return true;
            }
            connectionDetails.setUserCredentials(userCredentials);
        }
        return false;
    }

    public Collection<MqttAsyncConnection> getMqttConnections() {
        return this.connections.values();
    }

    @Override
    public Collection<IUiConnection> getConnections() {
        return new ArrayList<IUiConnection>(this.connections.values());
    }

    @Override
    public void disconnectAll() {
        for (MqttAsyncConnection connection : this.getMqttConnections()) {
            this.disconnectFromBroker(connection);
        }
    }

    public void disconnectAndCloseTab(MqttAsyncConnection connection) {
        this.disconnectFromBroker(connection);
        connection.closeConnection();
        if (connection.getMessageLogger() != null && connection.getMessageLogger().isRunning()) {
            connection.getMessageLogger().stop();
        }
        TabUtils.requestClose(this.connectionControllersMapping.get(connection).getTab());
        this.subscriptionManagers.remove(this.connectionControllersMapping.get(connection));
        this.connectionControllersMapping.remove(connection);
        this.connectionTabs.remove(connection);
        logger.debug("Closing connection tab; sm = {}; cc = {}; ct = {}", this.subscriptionManagers.keySet().size(), this.connectionControllersMapping.keySet().size(), this.connectionTabs.keySet().size());
        connection.getScriptManager().stopScripts();
        for (BaseMqttSubscription subscription : connection.getSubscriptions().values()) {
            subscription.getStore().cleanUp();
        }
        connection.getStore().cleanUp();
    }

    public void closeOfflineTab(MqttConnectionController connectionController) {
        TabUtils.requestClose(connectionController.getTab());
        this.offlineConnectionControllers.remove(connectionController);
    }

    @Override
    public IConnectionController getControllerForTab(Tab tab) {
        for (MqttConnectionController controller : this.getConnectionControllers()) {
            if (!controller.getTab().equals(tab)) continue;
            return controller;
        }
        return null;
    }

    public MqttAsyncConnection createConnection(MqttRuntimeConnectionProperties connectionProperties, EventQueueManager<FormattedMqttMessage> uiEventQueue) {
        InteractiveMqttScriptManager scriptManager = new InteractiveMqttScriptManager(this.eventBus, null);
        FormattingManager formattingManager = new FormattingManager(scriptManager);
        MqttAsyncConnection connection = new MqttAsyncConnection(this.reconnectionManager, connectionProperties, ConnectionStatus.DISCONNECTED, this.eventBus, scriptManager, formattingManager, uiEventQueue, UiProperties.getSummaryMaxPayloadLength(this.configurationManager.getUiPropertyFile()));
        formattingManager.initialiseFormatter(connection.getProperties().getFormatter());
        scriptManager.setConnection(connection);
        MessageLog messageLog = connectionProperties.getConfiguredProperties().getMessageLog();
        if (messageLog != null && !messageLog.getValue().equals((Object)MessageLogEnum.DISABLED) && messageLog.getLogFile() != null && !messageLog.getLogFile().isEmpty()) {
            LinkedBlockingQueue<FormattedMqttMessage> messageQueue = new LinkedBlockingQueue<FormattedMqttMessage>();
            if (connection.getMessageLogger() == null) {
                MqttMessageLogger messageLogger = new MqttMessageLogger(connection.getId(), messageQueue, messageLog, true, 50);
                connection.setMessageLogger(messageLogger);
            }
            if (!connection.getMessageLogger().isRunning()) {
                new Thread(connection.getMessageLogger()).start();
            }
        }
        this.connections.put(connectionProperties.getConfiguredProperties().getID(), connection);
        return connection;
    }

    public boolean connectToBroker(MqttAsyncConnection connection) {
        try {
            connection.connect(new MqttCallbackHandler(connection), new MqttAsyncConnectionRunnable(connection));
            return true;
        }
        catch (SpyException e) {
            Platform.runLater((Runnable)new MqttEventHandler(new MqttConnectionAttemptFailureEvent(connection, e)));
            logger.error(e.getMessage(), e);
            return false;
        }
    }

    public void disconnectFromBroker(MqttAsyncConnection connection) {
        try {
            connection.disconnect(new MqttDisconnectionResultHandler());
        }
        catch (SpyException e) {
            Platform.runLater((Runnable)new MqttEventHandler(new MqttDisconnectionAttemptFailureEvent(connection, e)));
            logger.error(e.getMessage(), e);
        }
    }

    @Override
    public void disconnectAndCloseAll() {
        for (MqttAsyncConnection connection : this.getMqttConnections()) {
            this.disconnectAndCloseTab(connection);
        }
    }

    public Map<MqttAsyncConnection, MqttConnectionController> getConnectionControllersMapping() {
        return this.connectionControllersMapping;
    }

    public Collection<MqttConnectionController> getConnectionControllers() {
        return this.connectionControllersMapping.values();
    }

    public Collection<MqttConnectionController> getOfflineConnectionControllers() {
        return this.offlineConnectionControllers;
    }

    public MqttSubscriptionViewManager getSubscriptionManager(MqttConnectionController connectionController) {
        return this.subscriptionManagers.get(connectionController);
    }

    public void setViewManager(MqttViewManager viewManager) {
        this.viewManager = viewManager;
    }

    public void setParentStage(Stage parentStage) {
        this.parentStage = parentStage;
    }

    public Map<MqttAsyncConnection, Tab> getConnectionTabs() {
        return this.connectionTabs;
    }

    public EventQueueManager<FormattedMqttMessage> getUiEventQueue() {
        return this.uiEventQueue;
    }

    public void setOfflineConnectionControllers(Set<MqttConnectionController> offlineConnectionControllers) {
        this.offlineConnectionControllers = offlineConnectionControllers;
    }

    public Map<MqttConnectionController, MqttSubscriptionViewManager> getSubscriptionManagers() {
        return this.subscriptionManagers;
    }

    @Override
    public void autoOpenConnections() {
        for (ModifiableConnection modifiableConnection : this.configurationManager.getConnections()) {
            ConfiguredMqttConnectionDetails details = (ConfiguredMqttConnectionDetails)modifiableConnection;
            if (details.isAutoOpen() == null || !details.isAutoOpen().booleanValue()) continue;
            try {
                this.openConnection(details);
            }
            catch (ConfigurationException e) {
                logger.error("Cannot open conection {}", (Object)modifiableConnection.getName(), (Object)e);
            }
        }
    }

    public static EventHandler<ActionEvent> createDisconnectAction(final MqttConnectionViewManager connectionManager, final MqttAsyncConnection connection) {
        return new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                connectionManager.disconnectFromBroker(connection);
                event.consume();
            }
        };
    }

    public static EventHandler<ActionEvent> createEmptyAction() {
        return new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                event.consume();
            }
        };
    }

    public static EventHandler<ActionEvent> createDisconnectAndCloseAction(final MqttConnectionViewManager connectionManager, final MqttAsyncConnection connection) {
        return new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                connectionManager.disconnectAndCloseTab(connection);
                event.consume();
            }
        };
    }

    public static EventHandler<ActionEvent> createConnectAction(final MqttConnectionViewManager connectionManager, final MqttAsyncConnection connection) {
        return new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                connectionManager.connectToBroker(connection);
                event.consume();
            }
        };
    }

    public static EventHandler<ActionEvent> createNextAction(ConnectionStatus state, MqttAsyncConnection connection, MqttConnectionViewManager connectionManager) {
        if (state == null) {
            return MqttConnectionViewManager.createEmptyAction();
        }
        switch (state) {
            case CONNECTED: {
                return MqttConnectionViewManager.createDisconnectAction(connectionManager, connection);
            }
            case CONNECTING: {
                return MqttConnectionViewManager.createEmptyAction();
            }
            case DISCONNECTED: {
                return MqttConnectionViewManager.createConnectAction(connectionManager, connection);
            }
            case DISCONNECTING: {
                return MqttConnectionViewManager.createEmptyAction();
            }
            case NOT_CONNECTED: {
                return MqttConnectionViewManager.createConnectAction(connectionManager, connection);
            }
        }
        return MqttConnectionViewManager.createEmptyAction();
    }
}

