/*
 * Decompiled with CFR 0.152.
 */
package pl.baczkowicz.mqttspy.messages;

import java.util.Date;
import org.eclipse.paho.client.mqttv3.MqttMessage;
import pl.baczkowicz.mqttspy.messages.IBaseMqttMessage;
import pl.baczkowicz.spy.messages.FormattedMessage;
import pl.baczkowicz.spy.utils.ConversionUtils;

public class BaseMqttMessage
extends FormattedMessage
implements IBaseMqttMessage {
    private final MqttMessage rawMessage;

    public BaseMqttMessage(long id, String topic, MqttMessage message) {
        super(id, topic, null, new Date());
        this.rawMessage = message;
    }

    public BaseMqttMessage(long id, String topic, MqttMessage message, Date date) {
        super(id, topic, null, date);
        this.rawMessage = message;
    }

    public static MqttMessage copyMqttMessage(MqttMessage message) {
        MqttMessage copy = new MqttMessage();
        copy.setPayload(message.getPayload());
        copy.setQos(message.getQos());
        copy.setRetained(message.isRetained());
        return copy;
    }

    public MqttMessage getRawMessage() {
        return this.rawMessage;
    }

    @Override
    public String getPayload() {
        return ConversionUtils.arrayToString(this.rawMessage.getPayload());
    }

    @Override
    public void setPayload(String payload) {
        this.rawMessage.setPayload(ConversionUtils.stringToArray(payload));
    }

    @Override
    public int getQoS() {
        return this.rawMessage.getQos();
    }

    @Override
    public boolean isRetained() {
        return this.rawMessage.isRetained();
    }

    @Override
    public byte[] getRawPayload() {
        return this.getRawMessage().getPayload();
    }
}

