/*
 * Decompiled with CFR 0.152.
 */
package pl.baczkowicz.mqttspy.logger;

import java.util.Queue;
import org.apache.log4j.Logger;
import org.apache.log4j.RollingFileAppender;
import pl.baczkowicz.mqttspy.common.generated.MessageLog;
import pl.baczkowicz.mqttspy.logger.SimpleMqttMessageLogComposer;
import pl.baczkowicz.mqttspy.messages.FormattedMqttMessage;
import pl.baczkowicz.mqttspy.utils.Utils;
import pl.baczkowicz.spy.utils.ThreadingUtils;

public class MqttMessageLogger
implements Runnable {
    private static final Logger logger = Logger.getLogger(MqttMessageLogger.class);
    private static final int LOG_INTERVAL = 10000;
    private Logger localLogger;
    private final Queue<FormattedMqttMessage> queue;
    private final MessageLog messageLogSettings;
    private boolean running;
    private int sleepWhenNoMessages;

    public MqttMessageLogger(String connectionId, Queue<FormattedMqttMessage> queue, MessageLog messageLogSettings, boolean useAsTemplate, int sleepWhenNoMessages) {
        this.queue = queue;
        this.messageLogSettings = messageLogSettings;
        this.sleepWhenNoMessages = sleepWhenNoMessages;
        String file = messageLogSettings.getLogFile();
        if (file != null) {
            if (useAsTemplate) {
                RollingFileAppender templateAppender = (RollingFileAppender)logger.getAppender("messagelog");
                RollingFileAppender appender = new RollingFileAppender();
                appender.setThreshold(templateAppender.getThreshold());
                appender.setMaximumFileSize(templateAppender.getMaximumFileSize());
                appender.setMaxBackupIndex(templateAppender.getMaxBackupIndex());
                appender.setLayout(templateAppender.getLayout());
                appender.setFile(file);
                appender.activateOptions();
                this.localLogger = Logger.getLogger("pl.baczkowicz.mqttspy.logger.ConnectionSpecificLogger" + connectionId);
                this.localLogger.addAppender(appender);
                this.localLogger.setAdditivity(false);
            } else {
                RollingFileAppender appender = (RollingFileAppender)logger.getAppender("messagelog");
                appender.setFile(file);
            }
        }
    }

    @Override
    public void run() {
        ThreadingUtils.logThreadStarting("Message Audit Logger");
        this.running = true;
        while (this.running) {
            try {
                int mesagesProcessed = 0;
                while (this.queue.size() > 0) {
                    ++mesagesProcessed;
                    if (this.localLogger != null) {
                        this.localLogger.info(SimpleMqttMessageLogComposer.createReceivedMessageLog(this.queue.remove(), this.messageLogSettings));
                    } else {
                        logger.info(SimpleMqttMessageLogComposer.createReceivedMessageLog(this.queue.remove(), this.messageLogSettings));
                    }
                    if (mesagesProcessed <= 10000) continue;
                    Utils.logger.warn("Logged 10000 messages; logger not keeping up; queue size = " + this.queue.size());
                    mesagesProcessed = 0;
                }
                Thread.sleep(this.sleepWhenNoMessages);
            }
            catch (InterruptedException interruptedException) {}
        }
        ThreadingUtils.logThreadEnding();
    }

    public int getMessagesToProcess() {
        return this.queue.size();
    }

    public boolean isRunning() {
        return this.running;
    }

    public void stop() {
        this.running = false;
    }

    public Queue<FormattedMqttMessage> getQueue() {
        return this.queue;
    }
}

