/*
 * Decompiled with CFR 0.152.
 */
package pl.baczkowicz.mqttspy.logger;

import java.io.File;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.codec.binary.Base64;
import org.eclipse.paho.client.mqttv3.MqttMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pl.baczkowicz.mqttspy.common.generated.LoggedMqttMessage;
import pl.baczkowicz.mqttspy.logger.MqttMessageLogParser;
import pl.baczkowicz.mqttspy.messages.BaseMqttMessage;
import pl.baczkowicz.spy.exceptions.SpyException;
import pl.baczkowicz.spy.exceptions.XMLException;
import pl.baczkowicz.spy.files.FileUtils;
import pl.baczkowicz.spy.utils.ConversionUtils;
import pl.baczkowicz.spy.utils.TimeUtils;
import pl.baczkowicz.spy.utils.tasks.ProgressUpdater;

public class MqttMessageLogParserUtils {
    private static final Logger logger = LoggerFactory.getLogger(MqttMessageLogParserUtils.class);

    public static List<BaseMqttMessage> readAndConvertMessageLog(File selectedFile) throws SpyException {
        List<String> lines = FileUtils.readFileAsLines(selectedFile);
        logger.info("Message audit log - read {} messages from {}", (Object)lines.size(), (Object)selectedFile.getAbsoluteFile());
        return MqttMessageLogParserUtils.processMessageLog(MqttMessageLogParserUtils.parseMessageLog(lines, null, 0L, 0L), null, 0L, 0L);
    }

    public static List<LoggedMqttMessage> parseMessageLog(List<String> messages, ProgressUpdater progress, long current, long max) throws SpyException {
        try {
            long startTime = TimeUtils.getMonotonicTime();
            int items = messages.size();
            long chunkSize = items / 10;
            MqttMessageLogParser parser = new MqttMessageLogParser();
            ArrayList<LoggedMqttMessage> list = new ArrayList<LoggedMqttMessage>();
            long item = 0L;
            long reportAt = 1L;
            for (int i = 0; i < items; ++i) {
                String message = messages.get(i);
                if (progress != null) {
                    if (progress.isCancelled()) {
                        logger.info("Task cancelled!");
                        return null;
                    }
                    if (++item % 1000L == 0L) {
                        progress.update(current + item, max);
                    }
                }
                if (i > 0 && (long)i == chunkSize * reportAt) {
                    long currentTime = TimeUtils.getMonotonicTime();
                    long timeTaken = currentTime - startTime;
                    long totalTimeExpected = timeTaken * (long)items / (long)i;
                    if (timeTaken > 1000L) {
                        logger.info("Processed {}%, estimated time left = {}s", (Object)(reportAt * 10L), (Object)((totalTimeExpected - timeTaken) / 1000L));
                    }
                    ++reportAt;
                }
                try {
                    list.add(parser.parse(message));
                    continue;
                }
                catch (XMLException e) {
                    logger.error("Can't process message " + message, e);
                }
            }
            logger.info("Message audit log - parsed {} XML messages", (Object)list.size());
            return list;
        }
        catch (XMLException e) {
            throw new SpyException("Can't parse the message audit log file", e);
        }
    }

    public static List<BaseMqttMessage> processMessageLog(List<LoggedMqttMessage> list, ProgressUpdater progress, long current, long max) {
        ArrayList<BaseMqttMessage> mqttMessageList = new ArrayList<BaseMqttMessage>();
        long item = 0L;
        for (LoggedMqttMessage loggedMessage : list) {
            if (progress != null) {
                if (progress.isCancelled()) {
                    logger.info("Task cancelled!");
                    return null;
                }
                if (++item % 1000L == 0L) {
                    progress.update(current + item, max);
                }
            }
            mqttMessageList.add(MqttMessageLogParserUtils.convertToBaseMqttMessage(loggedMessage));
        }
        logger.info("Message audit log - processed {} MQTT messages", (Object)list.size());
        return mqttMessageList;
    }

    public static BaseMqttMessage convertToBaseMqttMessage(LoggedMqttMessage loggedMessage) {
        MqttMessage mqttMessage = new MqttMessage();
        if (logger.isTraceEnabled()) {
            logger.trace("Processing message with payload {}", (Object)loggedMessage.getValue());
        }
        if (Boolean.TRUE.equals(loggedMessage.isEncoded())) {
            mqttMessage.setPayload(Base64.decodeBase64(loggedMessage.getValue()));
        } else {
            mqttMessage.setPayload(ConversionUtils.stringToArray(loggedMessage.getValue()));
        }
        mqttMessage.setQos(loggedMessage.getQos() == null ? 0 : loggedMessage.getQos());
        mqttMessage.setRetained(loggedMessage.isRetained() == null ? false : loggedMessage.isRetained());
        return new BaseMqttMessage((long)loggedMessage.getId(), loggedMessage.getTopic(), mqttMessage, new Date(loggedMessage.getTimestamp()));
    }
}

