/*
 * Decompiled with CFR 0.152.
 */
package pl.baczkowicz.mqttspy.kura;

import java.io.IOException;
import org.eclipse.kura.KuraInvalidMessageException;
import org.eclipse.kura.core.cloud.CloudPayloadProtoBufDecoderImpl;
import org.eclipse.kura.message.KuraPayload;
import org.json.JSONObject;

public class KuraPayloadFormatter {
    public static String format(byte[] data) {
        CloudPayloadProtoBufDecoderImpl decoder = new CloudPayloadProtoBufDecoderImpl(data);
        try {
            KuraPayload kuraPayload = decoder.buildFromByteArray();
            return KuraPayloadFormatter.payloadToString(kuraPayload);
        }
        catch (IOException | KuraInvalidMessageException e) {
            return e.getLocalizedMessage();
        }
    }

    public static String payloadToString(KuraPayload payload) {
        String body = payload.getBody() != null ? ", body: " + new JSONObject(payload.getBody()).toString() : "";
        String position = payload.getPosition() != null ? ", position: " + new JSONObject(payload.getPosition()).toString() : "";
        return "{kuraPayload: {timestamp: " + payload.getTimestamp() + ", metrics: " + new JSONObject(payload.metrics()).toString() + position + body + "}}";
    }
}

