/*
 * Decompiled with CFR 0.152.
 */
package pl.baczkowicz.mqttspy.connectivity.topicmatching;

import io.moquette.proto.messages.AbstractMessage;
import io.moquette.spi.ClientSession;
import io.moquette.spi.ISessionsStore;
import io.moquette.spi.impl.subscriptions.Subscription;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class MapBasedSubscriptionStore
implements ISessionsStore {
    private final Map<String, List<ISessionsStore.ClientTopicCouple>> subscriptions = new HashMap<String, List<ISessionsStore.ClientTopicCouple>>();

    @Override
    public void wipeSubscriptions(String clientID) {
        this.subscriptions.remove(clientID);
    }

    @Override
    public List<ISessionsStore.ClientTopicCouple> listAllSubscriptions() {
        ArrayList<ISessionsStore.ClientTopicCouple> list = new ArrayList<ISessionsStore.ClientTopicCouple>();
        for (List<ISessionsStore.ClientTopicCouple> clientSubscriptions : this.subscriptions.values()) {
            list.addAll(clientSubscriptions);
        }
        return list;
    }

    @Override
    public void addNewSubscription(Subscription newSubscription) {
        String clientID = newSubscription.getClientId();
        List<ISessionsStore.ClientTopicCouple> clientSubscriptions = this.subscriptions.get(clientID);
        if (clientSubscriptions == null) {
            clientSubscriptions = new ArrayList<ISessionsStore.ClientTopicCouple>();
            this.subscriptions.put(clientID, clientSubscriptions);
        }
        clientSubscriptions.add(newSubscription.asClientTopicCouple());
    }

    @Override
    public boolean contains(String clientID) {
        return this.subscriptions.containsKey(clientID);
    }

    @Override
    public void removeSubscription(String topic, String clientID) {
        List<ISessionsStore.ClientTopicCouple> clientSubscriptions = this.subscriptions.get(clientID);
        if (clientSubscriptions != null) {
            clientSubscriptions.remove(topic);
        }
    }

    @Override
    public void bindToDeliver(String arg0, String arg1) {
    }

    @Override
    public ClientSession createNewSession(String arg0, boolean arg1) {
        return null;
    }

    @Override
    public Collection<String> enqueued(String arg0) {
        return null;
    }

    @Override
    public Subscription getSubscription(ISessionsStore.ClientTopicCouple couple) {
        Subscription subscription = new Subscription(couple.clientID, couple.topicFilter, AbstractMessage.QOSType.LEAST_ONE);
        return subscription;
    }

    @Override
    public void inFlight(String arg0, int arg1, String arg2) {
    }

    @Override
    public void inFlightAck(String arg0, int arg1) {
    }

    @Override
    public void initStore() {
    }

    @Override
    public String mapToGuid(String arg0, int arg1) {
        return null;
    }

    @Override
    public int nextPacketID(String arg0) {
        return 0;
    }

    @Override
    public void removeEnqueued(String arg0, String arg1) {
    }

    @Override
    public void secondPhaseAckWaiting(String arg0, int arg1) {
    }

    @Override
    public void secondPhaseAcknowledged(String arg0, int arg1) {
    }

    @Override
    public ClientSession sessionForClient(String arg0) {
        return null;
    }
}

