/*
 * Decompiled with CFR 0.152.
 */
package pl.baczkowicz.mqttspy.connectivity.handlers;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pl.baczkowicz.mqttspy.connectivity.MqttAsyncConnection;
import pl.baczkowicz.mqttspy.ui.events.queuable.connectivity.MqttConnectionAttemptSuccessEvent;
import pl.baczkowicz.mqttspy.ui.events.queuable.connectivity.MqttConnectionFailureEvent;
import pl.baczkowicz.mqttspy.ui.events.queuable.connectivity.MqttConnectionLostEvent;
import pl.baczkowicz.mqttspy.ui.events.queuable.connectivity.MqttDisconnectionAttemptSuccessEvent;
import pl.baczkowicz.spy.connectivity.ConnectionStatus;
import pl.baczkowicz.spy.events.SpyEvent;
import pl.baczkowicz.spy.exceptions.ExceptionUtils;

public class MqttEventHandler
implements Runnable {
    private static final Logger logger = LoggerFactory.getLogger(MqttEventHandler.class);
    private SpyEvent event;

    public MqttEventHandler(SpyEvent event) {
        this.event = event;
    }

    @Override
    public void run() {
        if (this.event instanceof MqttConnectionLostEvent) {
            ((MqttConnectionLostEvent)this.event).getConnection().connectionLost(((MqttConnectionLostEvent)this.event).getCause());
        }
        if (this.event instanceof MqttConnectionFailureEvent) {
            MqttConnectionFailureEvent mqttConnectionFailureEvent = (MqttConnectionFailureEvent)this.event;
            mqttConnectionFailureEvent.getConnection().setDisconnectionReason(ExceptionUtils.getInfo(mqttConnectionFailureEvent.getCause()));
            mqttConnectionFailureEvent.getConnection().setConnectionStatus(ConnectionStatus.DISCONNECTED);
        }
        if (this.event instanceof MqttConnectionAttemptSuccessEvent) {
            MqttAsyncConnection connection = ((MqttConnectionAttemptSuccessEvent)this.event).getConnection();
            connection.recordSuccessfulConnection();
            connection.setConnectionStatus(ConnectionStatus.CONNECTED);
            logger.info("About to resubscribe to all requested topics");
            connection.resubscribeAll(true);
            connection.startBackgroundScripts();
        }
        if (this.event instanceof MqttDisconnectionAttemptSuccessEvent) {
            MqttDisconnectionAttemptSuccessEvent mqttDisconnectionAttemptSuccessEvent = (MqttDisconnectionAttemptSuccessEvent)this.event;
            mqttDisconnectionAttemptSuccessEvent.getConnection().setDisconnectionReason("");
            mqttDisconnectionAttemptSuccessEvent.getConnection().setConnectionStatus(ConnectionStatus.DISCONNECTED);
        }
    }
}

