/*
 * Decompiled with CFR 0.152.
 */
package pl.baczkowicz.mqttspy.connectivity.handlers;

import java.util.Queue;
import java.util.concurrent.LinkedBlockingQueue;
import javafx.application.Platform;
import org.eclipse.paho.client.mqttv3.IMqttDeliveryToken;
import org.eclipse.paho.client.mqttv3.MqttCallback;
import org.eclipse.paho.client.mqttv3.MqttMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pl.baczkowicz.mqttspy.connectivity.MqttAsyncConnection;
import pl.baczkowicz.mqttspy.connectivity.handlers.MqttEventHandler;
import pl.baczkowicz.mqttspy.connectivity.handlers.MqttMessageHandler;
import pl.baczkowicz.mqttspy.messages.FormattedMqttMessage;
import pl.baczkowicz.mqttspy.ui.events.queuable.connectivity.MqttConnectionLostEvent;
import pl.baczkowicz.spy.messages.MessageIdGenerator;

public class MqttCallbackHandler
implements MqttCallback {
    private static final Logger logger = LoggerFactory.getLogger(MqttCallbackHandler.class);
    private final Queue<FormattedMqttMessage> messageQueue = new LinkedBlockingQueue<FormattedMqttMessage>();
    private MqttAsyncConnection connection;
    private MqttMessageHandler messageHandler;

    public MqttCallbackHandler(MqttAsyncConnection connection) {
        this.setConnection(connection);
        this.messageHandler = new MqttMessageHandler(connection, this.messageQueue);
        new Thread(this.messageHandler).start();
    }

    @Override
    public void connectionLost(Throwable cause) {
        logger.error("Connection " + this.connection.getProperties().getName() + " lost", cause);
        Platform.runLater((Runnable)new MqttEventHandler(new MqttConnectionLostEvent(this.connection, cause)));
    }

    @Override
    public void messageArrived(String topic, MqttMessage message) {
        logger.debug("[{}] Received message on topic \"{}\". Payload = \"{}\"", this.messageQueue.size(), topic, new String(message.getPayload()));
        this.messageQueue.add(new FormattedMqttMessage(MessageIdGenerator.getNewId(), topic, message, this.connection));
    }

    @Override
    public void deliveryComplete(IMqttDeliveryToken token) {
        logger.trace("Delivery complete for " + token.getMessageId());
    }

    public MqttAsyncConnection getConnection() {
        return this.connection;
    }

    public void setConnection(MqttAsyncConnection connection) {
        this.connection = connection;
    }
}

