/*
 * Decompiled with CFR 0.152.
 */
package pl.baczkowicz.mqttspy.connectivity;

import org.eclipse.paho.client.mqttv3.MqttException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pl.baczkowicz.mqttspy.common.generated.MqttConnectionDetails;
import pl.baczkowicz.mqttspy.connectivity.MqttConnectionDetailsWithOptions;
import pl.baczkowicz.mqttspy.connectivity.MqttConnectionWithReconnection;
import pl.baczkowicz.spy.connectivity.ConnectionStatus;
import pl.baczkowicz.spy.connectivity.ReconnectionManager;
import pl.baczkowicz.spy.exceptions.ConfigurationException;
import pl.baczkowicz.spy.exceptions.SpyException;
import pl.baczkowicz.spy.utils.ConversionUtils;

public class SimpleMqttConnection
extends MqttConnectionWithReconnection {
    private static final Logger logger = LoggerFactory.getLogger(SimpleMqttConnection.class);

    public SimpleMqttConnection(ReconnectionManager reconnectionManager, String id, MqttConnectionDetails connectionDetails) throws ConfigurationException {
        super(reconnectionManager, new MqttConnectionDetailsWithOptions(id, connectionDetails));
    }

    public boolean connect() {
        this.setConnectionStatus(ConnectionStatus.CONNECTING);
        try {
            this.connectAndWait(this.connectionDetails.getOptions());
            logger.info("Successfully connected to {}", (Object)this.connectionDetails.getName());
            this.setConnectionStatus(ConnectionStatus.CONNECTED);
            return true;
        }
        catch (SpyException e) {
            logger.error("Connection attempt failed", e);
            this.setConnectionStatus(ConnectionStatus.NOT_CONNECTED);
            return false;
        }
    }

    public boolean publish(String publicationTopic, String payload, int qos) {
        return this.publish(publicationTopic, ConversionUtils.stringToArray(payload), qos, false);
    }

    @Override
    public boolean publish(String publicationTopic, String payload, int qos, boolean retained) {
        return this.publish(publicationTopic, ConversionUtils.stringToArray(payload), qos, retained);
    }

    @Override
    public boolean publish(String publicationTopic, byte[] payload, int qos, boolean retained) {
        if (this.canPublish()) {
            try {
                logger.info("Publishing message on topic \"" + publicationTopic + "\". Payload size = " + payload.length);
                this.client.publish(publicationTopic, payload, qos, retained);
                logger.trace("Published message on topic \"" + publicationTopic + "\". Payload size = " + payload.length);
                return true;
            }
            catch (MqttException e) {
                logger.error("Cannot publish message on " + publicationTopic, e);
            }
        } else {
            logger.warn("Publication attempt failure - no connection available...");
        }
        return false;
    }

    @Override
    public boolean unsubscribeAll(boolean manualOverride) {
        throw new UnsupportedOperationException("This operation is not available");
    }
}

