/*
 * Decompiled with CFR 0.152.
 */
package pl.baczkowicz.mqttspy.connectivity;

import javafx.scene.paint.Color;
import pl.baczkowicz.mqttspy.connectivity.BaseMqttSubscription;
import pl.baczkowicz.mqttspy.connectivity.MqttAsyncConnection;
import pl.baczkowicz.mqttspy.messages.FormattedMqttMessage;
import pl.baczkowicz.mqttspy.ui.controllers.SubscriptionController;
import pl.baczkowicz.mqttspy.ui.events.SubscriptionStatusChangeEvent;
import pl.baczkowicz.spy.eventbus.IKBus;
import pl.baczkowicz.spy.formatting.FormattingManager;
import pl.baczkowicz.spy.ui.events.queuable.EventQueueManager;
import pl.baczkowicz.spy.ui.storage.ManagedMessageStoreWithFiltering;

public class MqttSubscription
extends BaseMqttSubscription {
    private Color color;
    private SubscriptionController subscriptionController;
    private MqttAsyncConnection connection;
    private final ManagedMessageStoreWithFiltering<FormattedMqttMessage> store;
    private IKBus eventBus;

    public MqttSubscription(String topic, Integer qos, Color color, int minMessagesPerTopic, int preferredStoreSize, EventQueueManager<FormattedMqttMessage> uiEventQueue, IKBus eventBus, FormattingManager formattingManager, int summaryMaxPayloadLength) {
        super(topic, qos, minMessagesPerTopic, preferredStoreSize);
        this.store = new ManagedMessageStoreWithFiltering<FormattedMqttMessage>(topic, minMessagesPerTopic, preferredStoreSize, preferredStoreSize * 2, uiEventQueue, formattingManager, summaryMaxPayloadLength);
        this.color = color;
        this.eventBus = eventBus;
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color color) {
        this.color = color;
    }

    @Override
    public void setActive(boolean active) {
        super.setActive(active);
        this.subscriptionStatusChanged();
    }

    public void subscriptionStatusChanged() {
        this.eventBus.publish(new SubscriptionStatusChangeEvent(this));
    }

    public void setSubscriptionController(SubscriptionController subscriptionController) {
        this.subscriptionController = subscriptionController;
    }

    public SubscriptionController getSubscriptionController() {
        return this.subscriptionController;
    }

    public void setConnection(MqttAsyncConnection connection) {
        this.connection = connection;
    }

    @Override
    public MqttAsyncConnection getConnection() {
        return this.connection;
    }

    public ManagedMessageStoreWithFiltering<FormattedMqttMessage> getStore() {
        return this.store;
    }
}

