/*
 * Decompiled with CFR 0.152.
 */
package pl.baczkowicz.mqttspy.connectivity;

import org.eclipse.paho.client.mqttv3.IMqttActionListener;
import org.eclipse.paho.client.mqttv3.MqttCallback;
import org.eclipse.paho.client.mqttv3.MqttException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pl.baczkowicz.mqttspy.connectivity.BaseMqttConnection;
import pl.baczkowicz.mqttspy.connectivity.MqttConnectionDetailsWithOptions;
import pl.baczkowicz.spy.common.generated.ReconnectionSettings;
import pl.baczkowicz.spy.connectivity.ConnectionStatus;
import pl.baczkowicz.spy.connectivity.IConnectionWithReconnect;
import pl.baczkowicz.spy.connectivity.ReconnectionManager;
import pl.baczkowicz.spy.exceptions.SpyException;

public abstract class MqttConnectionWithReconnection
extends BaseMqttConnection
implements IConnectionWithReconnect {
    private static final Logger logger = LoggerFactory.getLogger(MqttConnectionWithReconnection.class);
    private ReconnectionManager reconnectionManager;

    public MqttConnectionWithReconnection(ReconnectionManager reconnectionManager, MqttConnectionDetailsWithOptions connectionDetails) {
        super(connectionDetails);
        this.reconnectionManager = reconnectionManager;
    }

    public void connect(MqttCallback callback, Runnable connectionRunnable) throws SpyException {
        this.createClient(callback);
        ReconnectionSettings reconnectionSettings = this.getMqttConnectionDetails().getReconnectionSettings();
        if (reconnectionSettings == null) {
            new Thread(connectionRunnable).start();
        } else {
            this.reconnectionManager.addConnection(this, connectionRunnable);
        }
    }

    public void disconnect(IMqttActionListener diconnectionResultHandler) throws SpyException {
        this.reconnectionManager.removeConnection(this);
        this.setConnectionStatus(ConnectionStatus.DISCONNECTING);
        this.unsubscribeAll(true);
        try {
            logger.info("Disconnecting " + this.getMqttConnectionDetails().getClientID() + " from " + this.getMqttConnectionDetails().getServerURI());
            if (this.getClient() != null && this.getClient().isConnected()) {
                this.getClient().disconnect(this, diconnectionResultHandler);
            } else {
                logger.debug("Already disconnected");
            }
        }
        catch (MqttException e) {
            throw new SpyException("Cannot disconnect from connection " + this.getMqttConnectionDetails().getId() + " " + this.getMqttConnectionDetails().getName(), e);
        }
    }
}

