/*
 * Decompiled with CFR 0.152.
 */
package pl.baczkowicz.mqttspy.connectivity;

import javafx.application.Platform;
import org.eclipse.paho.client.mqttv3.MqttConnectOptions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pl.baczkowicz.mqttspy.connectivity.MqttAsyncConnection;
import pl.baczkowicz.mqttspy.connectivity.handlers.MqttConnectionResultHandler;
import pl.baczkowicz.mqttspy.connectivity.handlers.MqttEventHandler;
import pl.baczkowicz.mqttspy.ui.events.queuable.connectivity.MqttConnectionAttemptFailureEvent;
import pl.baczkowicz.spy.connectivity.ConnectionStatus;
import pl.baczkowicz.spy.exceptions.SpyException;
import pl.baczkowicz.spy.utils.ThreadingUtils;

public class MqttAsyncConnectionRunnable
implements Runnable {
    public static final int CONNECT_DELAY = 500;
    private static final Logger logger = LoggerFactory.getLogger(MqttAsyncConnectionRunnable.class);
    private MqttAsyncConnection connection;

    public MqttAsyncConnectionRunnable(MqttAsyncConnection connection) {
        this.connection = connection;
    }

    @Override
    public void run() {
        ThreadingUtils.logThreadStarting("ConnectionRunnable for " + this.connection.getName());
        this.connection.setConnectionStatus(ConnectionStatus.CONNECTING);
        try {
            if (ThreadingUtils.sleep(500L)) {
                return;
            }
            MqttConnectOptions options = this.connection.getProperties().getOptions();
            logger.info("Connecting client ID [{}] to server [{}]; options = {}", this.connection.getProperties().getClientID(), this.connection.getProperties().getServerURI(), options.toString());
            this.connection.connect(options, this.connection, new MqttConnectionResultHandler());
        }
        catch (SpyException e) {
            Platform.runLater((Runnable)new MqttEventHandler(new MqttConnectionAttemptFailureEvent(this.connection, e)));
            logger.error("Cannot connect to " + this.connection.getProperties().getServerURI(), e);
        }
        ThreadingUtils.logThreadEnding();
    }
}

