/*
 * Decompiled with CFR 0.152.
 */
package pl.baczkowicz.mqttspy.connectivity;

import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.paho.client.mqttv3.MqttException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pl.baczkowicz.mqttspy.connectivity.BaseMqttSubscription;
import pl.baczkowicz.mqttspy.connectivity.MqttConnectionWithReconnection;
import pl.baczkowicz.mqttspy.connectivity.MqttRuntimeConnectionProperties;
import pl.baczkowicz.mqttspy.logger.MqttMessageLogger;
import pl.baczkowicz.mqttspy.messages.FormattedMqttMessage;
import pl.baczkowicz.mqttspy.ui.scripts.InteractiveMqttScriptManager;
import pl.baczkowicz.spy.common.generated.ScriptDetails;
import pl.baczkowicz.spy.connectivity.ConnectionStatus;
import pl.baczkowicz.spy.connectivity.ReconnectionManager;
import pl.baczkowicz.spy.eventbus.IKBus;
import pl.baczkowicz.spy.formatting.FormattingManager;
import pl.baczkowicz.spy.scripts.Script;
import pl.baczkowicz.spy.ui.connections.IUiConnection;
import pl.baczkowicz.spy.ui.events.ConnectionStatusChangeEvent;
import pl.baczkowicz.spy.ui.events.queuable.EventQueueManager;
import pl.baczkowicz.spy.ui.stats.StatisticsManager;
import pl.baczkowicz.spy.ui.storage.ManagedMessageStoreWithFiltering;
import pl.baczkowicz.spy.utils.ConversionUtils;

public class MqttAsyncConnection
extends MqttConnectionWithReconnection
implements IUiConnection {
    private static final Logger logger = LoggerFactory.getLogger(MqttAsyncConnection.class);
    private final MqttRuntimeConnectionProperties properties;
    private boolean isOpened;
    private boolean isOpening;
    private final ManagedMessageStoreWithFiltering<FormattedMqttMessage> store;
    private int preferredStoreSize;
    private StatisticsManager statisticsManager;
    private IKBus eventBus;
    private final InteractiveMqttScriptManager scriptManager;
    private MqttMessageLogger messageLogger;

    public MqttAsyncConnection(ReconnectionManager reconnectionManager, MqttRuntimeConnectionProperties properties, ConnectionStatus status, IKBus eventBus, InteractiveMqttScriptManager scriptManager, FormattingManager formattingManager, EventQueueManager<FormattedMqttMessage> uiEventQueue, int summaryMaxPayloadLength) {
        super(reconnectionManager, properties);
        this.setScriptManager(scriptManager);
        this.store = new ManagedMessageStoreWithFiltering<FormattedMqttMessage>(properties.getName(), properties.getConfiguredProperties().getMinMessagesStoredPerTopic(), properties.getMaxMessagesStored(), properties.getMaxMessagesStored() * 2, uiEventQueue, formattingManager, summaryMaxPayloadLength);
        this.setPreferredStoreSize(properties.getMaxMessagesStored());
        this.properties = properties;
        this.eventBus = eventBus;
        this.scriptManager = scriptManager;
        this.setConnectionStatus(status);
    }

    public void messageReceived(FormattedMqttMessage receivedMessage) {
        List<String> matchingSubscriptionTopics = this.getTopicMatcher().getMatchingSubscriptions(receivedMessage.getTopic());
        logger.trace("Matching subscriptions = " + matchingSubscriptionTopics);
        ArrayList<String> matchingActiveSubscriptions = new ArrayList<String>();
        BaseMqttSubscription lastMatchingSubscription = this.matchMessageToSubscriptions(matchingSubscriptionTopics, receivedMessage, matchingActiveSubscriptions);
        FormattedMqttMessage message = new FormattedMqttMessage(receivedMessage);
        if (this.messageLogger != null && this.messageLogger.isRunning()) {
            message.setMatchingSubscriptionTopics(matchingActiveSubscriptions);
            this.messageLogger.getQueue().add(message);
        }
        this.statisticsManager.messageReceived(this.getId(), matchingActiveSubscriptions);
        if (lastMatchingSubscription != null) {
            message.setSubscription(lastMatchingSubscription.getTopic());
        } else {
            logger.warn("Cannot find a matching subscription for " + receivedMessage.getTopic());
        }
        this.store.messageReceived(message);
    }

    private BaseMqttSubscription matchMessageToSubscriptions(List<String> matchingSubscriptionTopics, FormattedMqttMessage receivedMessage, List<String> matchingActiveSubscriptions) {
        BaseMqttSubscription lastMatchingSubscription = this.matchMessageToSubscriptions(matchingSubscriptionTopics, receivedMessage, matchingActiveSubscriptions, false);
        if (matchingActiveSubscriptions.isEmpty()) {
            logger.debug("No active subscription available for {}, trying to find first matching...", (Object)receivedMessage.getTopic());
            lastMatchingSubscription = this.matchMessageToSubscriptions(matchingSubscriptionTopics, receivedMessage, matchingActiveSubscriptions, true);
            logger.debug("First matching = {} {}", (Object)lastMatchingSubscription, (Object)matchingSubscriptionTopics);
        }
        return lastMatchingSubscription;
    }

    private BaseMqttSubscription matchMessageToSubscriptions(List<String> matchingSubscriptionTopics, FormattedMqttMessage receivedMessage, List<String> matchingSubscriptions, boolean anySubscription) {
        BaseMqttSubscription foundMqttSubscription = null;
        for (String matchingSubscriptionTopic : matchingSubscriptionTopics) {
            logger.trace("Message on topic " + receivedMessage.getTopic() + " matched to " + matchingSubscriptionTopic);
            BaseMqttSubscription mqttSubscription = this.getMqttSubscriptionForTopic(matchingSubscriptionTopic);
            if (mqttSubscription == null || !anySubscription && !mqttSubscription.isSubscribing() && !mqttSubscription.isActive()) continue;
            matchingSubscriptions.add(matchingSubscriptionTopic);
            receivedMessage.setSubscription(mqttSubscription.getTopic());
            foundMqttSubscription = mqttSubscription;
            if (mqttSubscription.isScriptActive()) {
                this.scriptManager.runScriptWithReceivedMessage(mqttSubscription.getScript(), receivedMessage);
            }
            FormattedMqttMessage message = new FormattedMqttMessage(receivedMessage);
            mqttSubscription.getStore().messageReceived(message);
            if (!anySubscription) continue;
            logger.trace("Found one match - exiting...");
            break;
        }
        return foundMqttSubscription;
    }

    public boolean publish(String publicationTopic, String data, int qos) {
        return this.publish(publicationTopic, ConversionUtils.stringToArray(data), qos, false);
    }

    @Override
    public boolean publish(String publicationTopic, String data, int qos, boolean retained) {
        return this.publish(publicationTopic, ConversionUtils.stringToArray(data), qos, retained);
    }

    @Override
    public boolean publish(String publicationTopic, byte[] data, int qos, boolean retained) {
        if (this.canPublish()) {
            try {
                logger.info("Publishing message on topic \"" + publicationTopic + "\". Payload size = \"" + data.length + "\"");
                this.client.publish(publicationTopic, data, qos, retained);
                logger.trace("Published message on topic \"" + publicationTopic + "\". Payload size = \"" + data.length + "\"");
                this.statisticsManager.messagePublished(this.getId(), publicationTopic);
                return true;
            }
            catch (MqttException e) {
                logger.error("Cannot publish message on " + publicationTopic, e);
            }
        } else {
            logger.warn("Publication attempt failure - no connection available...");
        }
        return false;
    }

    @Override
    public void connectionLost(Throwable cause) {
        super.connectionLost(cause);
        this.unsubscribeAll(false);
    }

    public void startBackgroundScripts() {
        boolean firstConnection;
        boolean bl = firstConnection = this.getConnectionAttempts() == 1;
        if (firstConnection) {
            for (ScriptDetails scriptDetails : this.properties.getConfiguredProperties().getBackgroundScript()) {
                File scriptFile = new File(scriptDetails.getFile());
                Script script = this.scriptManager.getScriptsMap().get(Script.getScriptIdFromFile(scriptFile));
                if (scriptDetails.isAutoStart().booleanValue() && scriptFile.exists() && script != null) {
                    this.scriptManager.runScript(script, true);
                    continue;
                }
                if (!scriptFile.exists()) {
                    logger.warn("File " + scriptDetails.getFile() + " does not exist");
                    continue;
                }
                if (script != null) continue;
                logger.warn("Couldn't retrieve a script for " + scriptDetails.getFile());
            }
        }
    }

    public boolean resubscribeAll(boolean requestedOnly) {
        boolean firstConnection = this.getConnectionAttempts() == 1;
        boolean resubscribeEnabled = this.connectionDetails.getReconnectionSettings() != null && this.connectionDetails.getReconnectionSettings().isResubscribe();
        boolean tryAutoSubscribe = firstConnection || resubscribeEnabled;
        for (BaseMqttSubscription subscription : this.subscriptions.values()) {
            logger.debug("Subscription {} status [requestedOnly = {}, firstConnection = {}, resubscribeEnabled = {}, subscriptionRequested = {}", subscription.getTopic(), requestedOnly, firstConnection, resubscribeEnabled, subscription.getSubscriptionRequested());
            if (requestedOnly && (!tryAutoSubscribe || !subscription.getSubscriptionRequested())) continue;
            this.resubscribe(subscription);
        }
        return true;
    }

    public boolean resubscribe(BaseMqttSubscription subscription) {
        return this.subscribe(subscription);
    }

    @Override
    public boolean unsubscribeAll(boolean manualOverride) {
        HashSet allSubscriptions = new HashSet(this.subscriptions.values());
        for (BaseMqttSubscription subscription : allSubscriptions) {
            this.unsubscribe(subscription, manualOverride);
        }
        return true;
    }

    public boolean unsubscribe(BaseMqttSubscription subscription, boolean manualOverride) {
        if (manualOverride && subscription.getSubscriptionRequested()) {
            subscription.setSubscriptionRequested(false);
        }
        if (!subscription.isActive()) {
            return false;
        }
        logger.debug("Unsubscribing from " + subscription.getTopic());
        this.removeSubscriptionFromMatcher(subscription);
        boolean unsubscribed = this.unsubscribe(subscription.getTopic());
        if (subscription.isScriptActive()) {
            this.scriptManager.invokeAfter(subscription.getScript());
        }
        subscription.setActive(false);
        logger.trace("Subscription " + subscription.getTopic() + " is active = " + subscription.isActive());
        return unsubscribed;
    }

    public boolean unsubscribeAndRemove(BaseMqttSubscription subscription) {
        boolean unsubscribed = this.unsubscribe(subscription, true);
        this.removeSubscription(subscription);
        logger.info("Subscription " + subscription.getTopic() + " removed");
        return unsubscribed;
    }

    @Override
    public boolean subscribe(BaseMqttSubscription subscription) {
        boolean subscribed = super.subscribe(subscription);
        if (subscribed) {
            StatisticsManager.newSubscription();
        }
        return subscribed;
    }

    @Override
    public void setConnectionStatus(ConnectionStatus connectionStatus) {
        super.setConnectionStatus(connectionStatus);
        this.eventBus.publish(new ConnectionStatusChangeEvent(this, this.getName(), this.getConnectionStatus()));
    }

    public MqttRuntimeConnectionProperties getProperties() {
        return this.properties;
    }

    public Map<String, BaseMqttSubscription> getSubscriptions() {
        return this.subscriptions;
    }

    public int getPreferredStoreSize() {
        return this.preferredStoreSize;
    }

    public void setPreferredStoreSize(int preferredStoreSize) {
        this.preferredStoreSize = preferredStoreSize;
    }

    @Override
    public String getId() {
        return this.properties.getId();
    }

    @Override
    public boolean isOpened() {
        return this.isOpened;
    }

    public void closeConnection() {
        this.setOpened(false);
    }

    public void setOpened(boolean isOpened) {
        this.isOpened = isOpened;
        this.eventBus.publish(new ConnectionStatusChangeEvent(this, this.getName(), this.getConnectionStatus()));
    }

    @Override
    public boolean isOpening() {
        return this.isOpening;
    }

    public void setOpening(boolean isOpening) {
        this.isOpening = isOpening;
        this.eventBus.publish(new ConnectionStatusChangeEvent(this, this.getName(), this.getConnectionStatus()));
    }

    public ManagedMessageStoreWithFiltering<FormattedMqttMessage> getStore() {
        return this.store;
    }

    @Override
    public String getName() {
        return this.store.getName();
    }

    public void setStatisticsManager(StatisticsManager statisticsManager) {
        this.statisticsManager = statisticsManager;
    }

    public InteractiveMqttScriptManager getScriptManager() {
        return this.scriptManager;
    }

    public void setMessageLogger(MqttMessageLogger messageLogger) {
        this.messageLogger = messageLogger;
    }

    public MqttMessageLogger getMessageLogger() {
        return this.messageLogger;
    }
}

