/*
 * Decompiled with CFR 0.152.
 */
package pl.baczkowicz.mqttspy.connectivity;

import pl.baczkowicz.mqttspy.connectivity.BaseMqttConnection;
import pl.baczkowicz.mqttspy.messages.FormattedMqttMessage;
import pl.baczkowicz.spy.connectivity.BaseSubscription;
import pl.baczkowicz.spy.storage.BasicMessageStore;
import pl.baczkowicz.spy.storage.MessageList;

public class BaseMqttSubscription
extends BaseSubscription {
    private Integer qos;
    private boolean subscribing;
    private boolean subscriptionRequested;
    private boolean active;
    private BaseMqttConnection connection;
    private BasicMessageStore<FormattedMqttMessage> store;

    public BaseMqttSubscription(String topic, Integer qos) {
        super(topic);
        this.qos = qos;
        this.subscriptionRequested = false;
        this.store = null;
    }

    public BaseMqttSubscription(String topic, Integer qos, int minMessagesPerTopic, int preferredStoreSize) {
        this(topic, qos);
        this.store = new BasicMessageStore(new MessageList(minMessagesPerTopic, preferredStoreSize, topic));
    }

    public Integer getQos() {
        return this.qos;
    }

    public void setQos(Integer qos) {
        this.qos = qos;
    }

    @Override
    public boolean isActive() {
        return this.active;
    }

    @Override
    public void setActive(boolean active) {
        this.active = active;
    }

    public void setConnection(BaseMqttConnection connection) {
        this.connection = connection;
    }

    public BaseMqttConnection getConnection() {
        return this.connection;
    }

    @Override
    public boolean isSubscribing() {
        return this.subscribing;
    }

    @Override
    public void setSubscribing(boolean value) {
        this.subscribing = value;
    }

    public boolean getSubscriptionRequested() {
        return this.subscriptionRequested;
    }

    public void setSubscriptionRequested(boolean subscriptionRequested) {
        this.subscriptionRequested = subscriptionRequested;
    }

    public BasicMessageStore<FormattedMqttMessage> getStore() {
        return this.store;
    }
}

