/*
 * Decompiled with CFR 0.152.
 */
package pl.baczkowicz.mqttspy.configuration;

import pl.baczkowicz.mqttspy.configuration.generated.UserInterfaceMqttConnectionDetails;
import pl.baczkowicz.spy.common.generated.ConnectionGroup;
import pl.baczkowicz.spy.common.generated.ConnectionGroupReference;
import pl.baczkowicz.spy.ui.configuration.ConfiguredConnectionGroupDetails;
import pl.baczkowicz.spy.ui.properties.ModifiableConnection;

public class ConfiguredMqttConnectionDetails
extends UserInterfaceMqttConnectionDetails
implements ModifiableConnection {
    private static final long serialVersionUID = -111271741915161354L;
    private boolean modified;
    private boolean begingCreated;
    private boolean deleted;
    private boolean newConnection;
    private boolean valid;
    private ConfiguredMqttConnectionDetails lastSavedValues;
    private ConnectionGroupReference group;
    private boolean groupingModified;

    public ConfiguredMqttConnectionDetails() {
    }

    public ConfiguredMqttConnectionDetails(ConnectionGroupReference group, UserInterfaceMqttConnectionDetails connection) {
        this.group = group;
        connection.copyTo(this);
    }

    public ConfiguredMqttConnectionDetails(boolean created, boolean newConnection, UserInterfaceMqttConnectionDetails connection) {
        this.modified = newConnection;
        this.begingCreated = created;
        this.newConnection = newConnection;
        ConfiguredMqttConnectionDetails connectionDetails = new ConfiguredMqttConnectionDetails(null, connection);
        this.setConnectionDetails(connectionDetails);
        this.setLastSavedValues(connectionDetails);
    }

    public void setConnectionDetails(ModifiableConnection connectionDetails) {
        ConnectionGroup group = connectionDetails.getGroup() != null ? (ConnectionGroup)connectionDetails.getGroup().getReference() : null;
        connectionDetails.setGroup(null);
        if (connectionDetails != null) {
            ((UserInterfaceMqttConnectionDetails)((Object)connectionDetails)).copyTo(this);
        }
        connectionDetails.setGroup(new ConnectionGroupReference(group));
        this.setGroup(new ConnectionGroupReference(group));
    }

    @Override
    public boolean isModified() {
        return this.modified;
    }

    public void setModified(boolean modified) {
        this.modified = modified;
    }

    @Override
    public boolean isBeingCreated() {
        return this.begingCreated;
    }

    public void setBeingCreated(boolean created) {
        this.begingCreated = created;
    }

    public UserInterfaceMqttConnectionDetails getSavedValues() {
        return this.lastSavedValues;
    }

    private void setLastSavedValues(ConfiguredMqttConnectionDetails savedValues) {
        this.lastSavedValues = savedValues;
    }

    public boolean isValid() {
        return this.valid;
    }

    public void setValid(boolean valid) {
        this.valid = valid;
    }

    public void undo() {
        ConfiguredConnectionGroupDetails group = (ConfiguredConnectionGroupDetails)this.getGroup().getReference();
        this.setConnectionDetails(this.lastSavedValues);
        this.setGroup(new ConnectionGroupReference(group));
        this.modified = this.newConnection;
    }

    @Override
    public void undoAll() {
        this.setConnectionDetails(this.lastSavedValues);
        this.modified = this.newConnection;
        this.groupingModified = false;
    }

    @Override
    public void apply() {
        ConfiguredMqttConnectionDetails valuesToSave = new ConfiguredMqttConnectionDetails(false, false, this);
        this.setLastSavedValues(valuesToSave);
        this.begingCreated = false;
        this.newConnection = false;
        this.modified = false;
        this.groupingModified = false;
    }

    public boolean isDeleted() {
        return this.deleted;
    }

    @Override
    public void setDeleted(boolean deleted) {
        this.deleted = deleted;
    }

    @Override
    public boolean isNew() {
        return this.newConnection;
    }

    @Override
    public void removeFromGroup() {
        ConfiguredConnectionGroupDetails.removeFromGroup(this, (ConnectionGroup)this.getGroup().getReference());
    }

    @Override
    public void setGroupingModified(boolean modified) {
        this.groupingModified = modified;
    }

    @Override
    public boolean isGroupingModified() {
        return this.groupingModified;
    }

    @Override
    public ConnectionGroupReference getGroup() {
        return this.group;
    }

    @Override
    public void setGroup(ConnectionGroupReference group) {
        this.group = group;
    }
}

