/*
 * Decompiled with CFR 0.152.
 */
package pl.baczkowicz.mqttspy.audit;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pl.baczkowicz.mqttspy.logger.MqttMessageLogParser;
import pl.baczkowicz.mqttspy.logger.MqttMessageLogParserUtils;
import pl.baczkowicz.mqttspy.messages.BaseMqttMessage;
import pl.baczkowicz.spy.audit.AuditReplay;
import pl.baczkowicz.spy.exceptions.SpyException;
import pl.baczkowicz.spy.exceptions.XMLException;
import pl.baczkowicz.spy.messages.BaseMessage;

public class MqttAuditReplay
extends AuditReplay {
    private static final Logger logger = LoggerFactory.getLogger(MqttAuditReplay.class);
    private boolean messageReadAhead = false;
    private final MqttMessageLogParser parser;
    private BaseMqttMessage message;
    private long messageIndex = 0L;

    public MqttAuditReplay() throws SpyException {
        try {
            this.parser = new MqttMessageLogParser();
        }
        catch (XMLException e) {
            throw new SpyException("Cannot initiate the audit replay", e);
        }
    }

    private void processNextMessage() {
        try {
            ++this.messageIndex;
            String next = this.auditReader.getNextLine();
            this.message = MqttMessageLogParserUtils.convertToBaseMqttMessage(this.parser.parse(next));
            this.messageReadAhead = true;
        }
        catch (Exception e) {
            logger.error("Cannot parse message number {}", (Object)this.messageIndex, (Object)e);
        }
    }

    @Override
    protected long getMessageTime() {
        if (!this.messageReadAhead) {
            this.processNextMessage();
        }
        return this.message.getDate().getTime();
    }

    @Override
    protected BaseMessage getMessage() {
        if (!this.messageReadAhead) {
            this.processNextMessage();
        }
        this.messageReadAhead = false;
        return this.message;
    }
}

