/*
 * Decompiled with CFR 0.152.
 */
package pl.baczkowicz.mqttspy;

import java.io.File;
import javafx.application.Application;
import javafx.stage.Stage;
import org.slf4j.LoggerFactory;
import pl.baczkowicz.mqttspy.configuration.MqttConfigurationManager;
import pl.baczkowicz.mqttspy.connectivity.MqttConnectionFactory;
import pl.baczkowicz.mqttspy.scripts.MqttScriptManager;
import pl.baczkowicz.mqttspy.ui.MqttConnectionViewManager;
import pl.baczkowicz.mqttspy.ui.MqttViewManager;
import pl.baczkowicz.mqttspy.ui.stats.MqttStatsFileIO;
import pl.baczkowicz.spy.eventbus.KBus;
import pl.baczkowicz.spy.ui.events.LoadConfigurationFileEvent;
import pl.baczkowicz.spy.ui.stats.StatisticsManager;
import pl.baczkowicz.spy.ui.utils.FxmlUtils;
import pl.baczkowicz.spy.ui.versions.VersionManager;

public class Main
extends Application {
    private static final String CONFIGURATION_PARAMETER_NAME = "configuration";
    private static final String NO_CONFIGURATION_PARAMETER_NAME = "no-configuration";

    public void start(Stage primaryStage) {
        KBus eventBus = new KBus();
        try {
            MqttConfigurationManager configurationManager = new MqttConfigurationManager();
            FxmlUtils.setParentClass(((Object)((Object)this)).getClass());
            StatisticsManager statisticsManager = new StatisticsManager(new MqttStatsFileIO());
            VersionManager versionManager = new VersionManager(configurationManager.getDefaultPropertyFile());
            MqttViewManager viewManager = new MqttViewManager();
            MqttConnectionViewManager connectionManager = new MqttConnectionViewManager(eventBus, statisticsManager, configurationManager);
            connectionManager.setViewManager(viewManager);
            MqttConnectionFactory connectionFactory = new MqttConnectionFactory();
            connectionFactory.setConfigurationManager(configurationManager);
            connectionFactory.setConnectionManager(connectionManager);
            connectionFactory.setEventBus(eventBus);
            viewManager.setConnectionFactory(connectionFactory);
            viewManager.setGenericScriptManager(new MqttScriptManager(null, null, null));
            viewManager.setEventBus(eventBus);
            viewManager.setConfigurationManager(configurationManager);
            viewManager.setConnectionManager(connectionManager);
            viewManager.setStatisticsManager(statisticsManager);
            viewManager.setVersionManager(versionManager);
            viewManager.setApplication(this);
            viewManager.init();
            viewManager.createMainWindow(primaryStage);
            primaryStage.show();
            String noConfig = (String)this.getParameters().getNamed().get(NO_CONFIGURATION_PARAMETER_NAME);
            String configurationFileLocation = (String)this.getParameters().getNamed().get(CONFIGURATION_PARAMETER_NAME);
            if (noConfig == null) {
                if (configurationFileLocation != null) {
                    eventBus.publish(new LoadConfigurationFileEvent(new File(configurationFileLocation)));
                } else {
                    viewManager.loadDefaultConfigurationFile();
                }
            }
        }
        catch (Exception e) {
            LoggerFactory.getLogger(Main.class).error("Error while loading the main window", e);
        }
    }

    public static void main(String[] args) {
        Main.launch((String[])args);
    }
}

