/*
 * Decompiled with CFR 0.152.
 */
package org.reactfx.util;

import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.util.Duration;
import org.reactfx.util.Timer;

public class FxTimer
implements Timer {
    private final Duration timeout;
    private final Timeline timeline;
    private final Runnable action;
    private long seq = 0L;

    public static Timer create(java.time.Duration delay, Runnable action) {
        return new FxTimer(delay, action, 1);
    }

    public static Timer runLater(java.time.Duration delay, Runnable action) {
        Timer timer = FxTimer.create(delay, action);
        timer.restart();
        return timer;
    }

    public static Timer createPeriodic(java.time.Duration interval, Runnable action) {
        return new FxTimer(interval, action, -1);
    }

    public static Timer runPeriodically(java.time.Duration interval, Runnable action) {
        Timer timer = FxTimer.createPeriodic(interval, action);
        timer.restart();
        return timer;
    }

    private FxTimer(java.time.Duration timeout, Runnable action, int cycles) {
        this.timeout = Duration.millis((double)timeout.toMillis());
        this.timeline = new Timeline();
        this.action = action;
        this.timeline.setCycleCount(cycles);
    }

    @Override
    public void restart() {
        this.stop();
        long expected = this.seq;
        this.timeline.getKeyFrames().setAll((Object[])new KeyFrame[]{new KeyFrame(this.timeout, ae -> {
            if (this.seq == expected) {
                this.action.run();
            }
        }, new KeyValue[0])});
        this.timeline.play();
    }

    @Override
    public void stop() {
        this.timeline.stop();
        ++this.seq;
    }
}

