/*
 * Decompiled with CFR 0.152.
 */
package org.reactfx.util;

import java.util.ArrayList;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.ToIntFunction;
import org.reactfx.util.BiIndex;
import org.reactfx.util.Either;
import org.reactfx.util.LL;
import org.reactfx.util.Lists;
import org.reactfx.util.MapToMonoid;
import org.reactfx.util.TetraFunction;
import org.reactfx.util.TriFunction;
import org.reactfx.util.Tuple2;
import org.reactfx.util.Tuple3;
import org.reactfx.util.Tuples;

public abstract class FingerTree<T, S> {
    final MapToMonoid<? super T, S> monoid;

    public static <T, S> FingerTree<T, S> empty(MapToMonoid<? super T, S> statisticsProvider) {
        return new Empty<T, S>(statisticsProvider);
    }

    public static <T, S> FingerTree<T, S> mkTree(List<? extends T> initialItems, MapToMonoid<? super T, S> statisticsProvider) {
        if (initialItems.isEmpty()) {
            return new Empty<T, S>(statisticsProvider);
        }
        ArrayList<FingerTree<T, S>> leafs = new ArrayList<FingerTree<T, S>>(initialItems.size());
        for (T item : initialItems) {
            leafs.add(new Leaf<T, S>(statisticsProvider, item));
        }
        return FingerTree.mkTree(leafs);
    }

    private static <T, S> FingerTree<T, S> mkTree(List<FingerTree<T, S>> trees) {
        while (trees.size() > 1) {
            for (int i = 0; i < trees.size(); ++i) {
                FingerTree<T, S> t2;
                FingerTree<T, S> t1;
                if (trees.size() - i >= 5 || trees.size() - i == 3) {
                    t1 = trees.get(i);
                    t2 = trees.get(i + 1);
                    FingerTree<T, S> t3 = trees.get(i + 2);
                    Branch<T, S> branch = t1.branch(t1, t2, t3);
                    trees.set(i, branch);
                    trees.subList(i + 1, i + 3).clear();
                    continue;
                }
                t1 = trees.get(i);
                t2 = trees.get(i + 1);
                Branch<T, S> b = t1.branch(t1, t2);
                trees.set(i, b);
                trees.remove(i + 1);
            }
        }
        return trees.get(0);
    }

    private static <T, S> FingerTree<T, S> concat(LL.Cons<? extends FingerTree<T, S>> nodes) {
        FingerTree<T, S> head = nodes.head();
        return nodes.tail().fold(head, (v, w) -> v.appendTree((FingerTree)w));
    }

    private FingerTree(MapToMonoid<? super T, S> monoid) {
        this.monoid = monoid;
    }

    public abstract int getDepth();

    public abstract int getLeafCount();

    public abstract S getStats();

    public final boolean isEmpty() {
        return this.getDepth() == 0;
    }

    public T getLeaf(int index) {
        Lists.checkIndex(index, this.getLeafCount());
        return this.getLeaf0(index);
    }

    abstract T getLeaf0(int var1);

    public Tuple2<T, BiIndex> get(ToIntFunction<? super S> metric, int index) {
        int size = metric.applyAsInt(this.getStats());
        Lists.checkIndex(index, size);
        BiIndex location = this.locateProgressively(metric, index);
        return Tuples.t(this.getLeaf(location.major), location);
    }

    public <E> E get(ToIntFunction<? super S> metric, int index, BiFunction<? super T, Integer, ? extends E> leafAccessor) {
        return (E)this.locateProgressively(metric, index).map((major, minor) -> leafAccessor.apply((T)this.getLeaf((int)major), (Integer)minor));
    }

    public FingerTree<T, S> updateLeaf(int index, T data) {
        Lists.checkIndex(index, this.getLeafCount());
        return this.updateLeaf0(index, data);
    }

    abstract FingerTree<T, S> updateLeaf0(int var1, T var2);

    public BiIndex locateProgressively(ToIntFunction<? super S> metric, int position) {
        if (this.getLeafCount() == 0) {
            throw new IndexOutOfBoundsException("no leafs to locate in");
        }
        Lists.checkPosition(position, this.measure(metric));
        return this.locateProgressively0(metric, position);
    }

    abstract BiIndex locateProgressively0(ToIntFunction<? super S> var1, int var2);

    public BiIndex locateRegressively(ToIntFunction<? super S> metric, int position) {
        if (this.getLeafCount() == 0) {
            throw new IndexOutOfBoundsException("no leafs to locate in");
        }
        Lists.checkPosition(position, this.measure(metric));
        return this.locateRegressively0(metric, position);
    }

    abstract BiIndex locateRegressively0(ToIntFunction<? super S> var1, int var2);

    abstract <R> R fold(R var1, BiFunction<? super R, ? super T, ? extends R> var2);

    public <R> R foldBetween(R acc, BiFunction<? super R, ? super T, ? extends R> reduction, int startLeaf, int endLeaf) {
        Lists.checkRange(startLeaf, endLeaf, this.getLeafCount());
        if (startLeaf == endLeaf) {
            return acc;
        }
        return this.foldBetween0(acc, reduction, startLeaf, endLeaf);
    }

    abstract <R> R foldBetween0(R var1, BiFunction<? super R, ? super T, ? extends R> var2, int var3, int var4);

    public <R> R foldBetween(R acc, BiFunction<? super R, ? super T, ? extends R> reduction, ToIntFunction<? super S> metric, int startPosition, int endPosition, TetraFunction<? super R, ? super T, Integer, Integer, ? extends R> rangeReduction) {
        Lists.checkRange(startPosition, endPosition, this.measure(metric));
        if (startPosition == endPosition) {
            return acc;
        }
        return this.foldBetween0(acc, reduction, metric, startPosition, endPosition, rangeReduction);
    }

    abstract <R> R foldBetween0(R var1, BiFunction<? super R, ? super T, ? extends R> var2, ToIntFunction<? super S> var3, int var4, int var5, TetraFunction<? super R, ? super T, Integer, Integer, ? extends R> var6);

    public S getStatsBetween(int startLeaf, int endLeaf) {
        Lists.checkRange(startLeaf, endLeaf, this.getLeafCount());
        if (startLeaf == endLeaf) {
            return (S)this.monoid.unit();
        }
        return this.getStatsBetween0(startLeaf, endLeaf);
    }

    abstract S getStatsBetween0(int var1, int var2);

    public S getStatsBetween(ToIntFunction<? super S> metric, int startPosition, int endPosition, TriFunction<? super T, Integer, Integer, ? extends S> subStats) {
        Lists.checkRange(startPosition, endPosition, this.measure(metric));
        if (startPosition == endPosition) {
            return (S)this.monoid.unit();
        }
        return this.getStatsBetween0(metric, startPosition, endPosition, subStats);
    }

    abstract S getStatsBetween0(ToIntFunction<? super S> var1, int var2, int var3, TriFunction<? super T, Integer, Integer, ? extends S> var4);

    public Tuple2<FingerTree<T, S>, FingerTree<T, S>> split(int beforeLeaf) {
        Lists.checkPosition(beforeLeaf, this.getLeafCount());
        return this.split0(beforeLeaf);
    }

    abstract Tuple2<FingerTree<T, S>, FingerTree<T, S>> split0(int var1);

    public Tuple3<FingerTree<T, S>, Optional<Tuple2<T, Integer>>, FingerTree<T, S>> split(ToIntFunction<? super S> metric, int position) {
        Lists.checkPosition(position, this.measure(metric));
        return this.split0(metric, position);
    }

    abstract Tuple3<FingerTree<T, S>, Optional<Tuple2<T, Integer>>, FingerTree<T, S>> split0(ToIntFunction<? super S> var1, int var2);

    public FingerTree<T, S> removeLeafs(int fromLeaf, int toLeaf) {
        Lists.checkRange(fromLeaf, toLeaf, this.getLeafCount());
        if (fromLeaf == toLeaf) {
            return this;
        }
        if (fromLeaf == 0 && toLeaf == this.getLeafCount()) {
            return this.empty();
        }
        FingerTree left = (FingerTree)this.split0((int)fromLeaf)._1;
        FingerTree right = (FingerTree)this.split0((int)toLeaf)._2;
        return left.appendTree(right);
    }

    public FingerTree<T, S> insertLeaf(int position, T data) {
        Lists.checkPosition(position, this.getLeafCount());
        return this.split0(position).map((l, r) -> l.appendTree(this.leaf(data)).appendTree((FingerTree<Object, S>)r));
    }

    public FingerTree<T, S> join(FingerTree<T, S> rightTree) {
        return this.appendTree(rightTree);
    }

    final FingerTree<T, S> appendTree(FingerTree<T, S> right) {
        if (this.getDepth() >= right.getDepth()) {
            return this.appendLte(right).toLeft(two -> two.map(this::branch));
        }
        return right.prependTree(this);
    }

    final FingerTree<T, S> prependTree(FingerTree<T, S> left) {
        if (this.getDepth() >= left.getDepth()) {
            return this.prependLte(left).toLeft(two -> two.map(this::branch));
        }
        return left.appendTree(this);
    }

    abstract Either<FingerTree<T, S>, Tuple2<FingerTree<T, S>, FingerTree<T, S>>> appendLte(FingerTree<T, S> var1);

    abstract Either<FingerTree<T, S>, Tuple2<FingerTree<T, S>, FingerTree<T, S>>> prependLte(FingerTree<T, S> var1);

    public FingerTree<T, S> append(T data) {
        return this.appendTree(this.leaf(data));
    }

    public FingerTree<T, S> prepend(T data) {
        return this.prependTree(this.leaf(data));
    }

    abstract T getData();

    Empty<T, S> empty() {
        return new Empty<T, S>(this.monoid);
    }

    Leaf<T, S> leaf(T data) {
        return new Leaf<T, S>(this.monoid, data);
    }

    Branch<T, S> branch(FingerTree<T, S> left, FingerTree<T, S> right) {
        return this.branch(LL.of(left, right));
    }

    Branch<T, S> branch(FingerTree<T, S> left, FingerTree<T, S> middle, FingerTree<T, S> right) {
        return this.branch(LL.of(left, middle, right));
    }

    Branch<T, S> branch(LL.Cons<FingerTree<T, S>> children) {
        return new Branch(this.monoid, children);
    }

    final int measure(ToIntFunction<? super S> metric) {
        return metric.applyAsInt(this.getStats());
    }

    private static final class Branch<T, S>
    extends FingerTree<T, S> {
        private final LL.Cons<FingerTree<T, S>> children;
        private final int depth;
        private final int leafCount;
        private final S stats;

        private Branch(MapToMonoid<? super T, S> monoid, LL.Cons<FingerTree<T, S>> children) {
            super(monoid);
            assert (children.size() == 2 || children.size() == 3);
            FingerTree<T, S> head = children.head();
            int headDepth = head.getDepth();
            assert (children.all(n -> n.getDepth() == headDepth));
            this.children = children;
            this.depth = 1 + headDepth;
            this.leafCount = children.fold(0, (s, n) -> s + n.getLeafCount());
            this.stats = children.mapReduce1(FingerTree::getStats, monoid::reduce);
        }

        public String toString() {
            return "Branch" + this.children;
        }

        @Override
        public int getDepth() {
            return this.depth;
        }

        @Override
        public int getLeafCount() {
            return this.leafCount;
        }

        @Override
        final T getData() {
            throw new UnsupportedOperationException("Only leaf nodes hold data");
        }

        @Override
        final T getLeaf0(int index) {
            assert (Lists.isValidIndex(index, this.getLeafCount()));
            return this.getLeaf0(index, this.children);
        }

        private T getLeaf0(int index, LL<? extends FingerTree<T, S>> nodes) {
            FingerTree<T, S> head = nodes.head();
            int headSize = head.getLeafCount();
            if (index < headSize) {
                return head.getLeaf0(index);
            }
            return this.getLeaf0(index - headSize, nodes.tail());
        }

        @Override
        FingerTree<T, S> updateLeaf0(int index, T data) {
            assert (Lists.isValidIndex(index, this.getLeafCount()));
            return this.branch(this.updateLeaf0(index, data, this.children));
        }

        private LL.Cons<FingerTree<T, S>> updateLeaf0(int index, T data, LL<? extends FingerTree<T, S>> nodes) {
            FingerTree<T, S> head = nodes.head();
            int headSize = head.getLeafCount();
            if (index < headSize) {
                return LL.cons(head.updateLeaf0(index, data), nodes.tail());
            }
            return LL.cons(head, this.updateLeaf0(index - headSize, data, nodes.tail()));
        }

        @Override
        final BiIndex locateProgressively0(ToIntFunction<? super S> metric, int position) {
            assert (Lists.isValidPosition(position, this.measure(metric)));
            return this.locateProgressively0(metric, position, this.children);
        }

        private BiIndex locateProgressively0(ToIntFunction<? super S> metric, int position, LL<? extends FingerTree<T, S>> nodes) {
            FingerTree<T, Object> head = nodes.head();
            int headLen = head.measure(metric);
            if (position < headLen || position == headLen && nodes.tail().isEmpty()) {
                return head.locateProgressively0(metric, position);
            }
            return this.locateProgressively0(metric, position - headLen, nodes.tail()).adjustMajor(head.getLeafCount());
        }

        @Override
        final BiIndex locateRegressively0(ToIntFunction<? super S> metric, int position) {
            assert (Lists.isValidPosition(position, this.measure(metric)));
            return this.locateRegressively0(metric, position, this.children);
        }

        private BiIndex locateRegressively0(ToIntFunction<? super S> metric, int position, LL<? extends FingerTree<T, S>> nodes) {
            FingerTree<T, Object> head = nodes.head();
            int headLen = head.measure(metric);
            if (position <= headLen) {
                return head.locateRegressively0(metric, position);
            }
            return this.locateRegressively0(metric, position - headLen, nodes.tail()).adjustMajor(head.getLeafCount());
        }

        @Override
        final <R> R fold(R acc, BiFunction<? super R, ? super T, ? extends R> reduction) {
            return (R)this.children.fold(acc, (r, n) -> n.fold(r, reduction));
        }

        @Override
        final <R> R foldBetween0(R acc, BiFunction<? super R, ? super T, ? extends R> reduction, int startLeaf, int endLeaf) {
            assert (Lists.isNonEmptyRange(startLeaf, endLeaf, this.getLeafCount()));
            return this.foldBetween0(acc, reduction, startLeaf, endLeaf, this.children);
        }

        private <R> R foldBetween0(R acc, BiFunction<? super R, ? super T, ? extends R> reduction, int startLeaf, int endLeaf, LL<? extends FingerTree<T, S>> nodes) {
            FingerTree<? super T, S> head = nodes.head();
            int headSize = head.getLeafCount();
            int headTo = Math.min(endLeaf, headSize);
            int tailFrom = Math.max(startLeaf - headSize, 0);
            int tailTo = endLeaf - headSize;
            if (startLeaf < headTo) {
                acc = head.foldBetween0(acc, reduction, startLeaf, headTo);
            }
            if (tailFrom < tailTo) {
                acc = this.foldBetween0(acc, reduction, tailFrom, tailTo, nodes.tail());
            }
            return acc;
        }

        @Override
        final <R> R foldBetween0(R acc, BiFunction<? super R, ? super T, ? extends R> reduction, ToIntFunction<? super S> metric, int startPosition, int endPosition, TetraFunction<? super R, ? super T, Integer, Integer, ? extends R> rangeReduction) {
            assert (Lists.isNonEmptyRange(startPosition, endPosition, this.measure(metric)));
            return this.foldBetween0(acc, reduction, metric, startPosition, endPosition, rangeReduction, this.children);
        }

        private <R> R foldBetween0(R acc, BiFunction<? super R, ? super T, ? extends R> reduction, ToIntFunction<? super S> metric, int startPosition, int endPosition, TetraFunction<? super R, ? super T, Integer, Integer, ? extends R> rangeReduction, LL<? extends FingerTree<T, S>> nodes) {
            FingerTree<? super T, Object> head = nodes.head();
            int headLen = head.measure(metric);
            int headTo = Math.min(endPosition, headLen);
            int tailFrom = Math.max(startPosition - headLen, 0);
            int tailTo = endPosition - headLen;
            if (startPosition < headTo) {
                acc = head.foldBetween0(acc, reduction, metric, startPosition, headTo, rangeReduction);
            }
            if (tailFrom < tailTo) {
                acc = this.foldBetween0(acc, reduction, metric, tailFrom, tailTo, rangeReduction, nodes.tail());
            }
            return acc;
        }

        @Override
        public S getStats() {
            return this.stats;
        }

        @Override
        final S getStatsBetween0(int startLeaf, int endLeaf) {
            assert (Lists.isNonEmptyRange(startLeaf, endLeaf, this.getLeafCount()));
            if (startLeaf == 0 && endLeaf == this.getLeafCount()) {
                return this.getStats();
            }
            return this.getStatsBetween0(startLeaf, endLeaf, this.children);
        }

        private S getStatsBetween0(int startLeaf, int endLeaf, LL<? extends FingerTree<T, S>> nodes) {
            FingerTree<T, S> head = nodes.head();
            int headSize = head.getLeafCount();
            int headTo = Math.min(endLeaf, headSize);
            int tailFrom = Math.max(startLeaf - headSize, 0);
            int tailTo = endLeaf - headSize;
            if (startLeaf < headTo && tailFrom < tailTo) {
                return this.monoid.reduce(head.getStatsBetween0(startLeaf, headTo), this.getStatsBetween0(tailFrom, tailTo, nodes.tail()));
            }
            if (startLeaf < headTo) {
                return head.getStatsBetween0(startLeaf, headTo);
            }
            if (tailFrom < tailTo) {
                return this.getStatsBetween0(tailFrom, tailTo, nodes.tail());
            }
            throw new AssertionError((Object)("Didn't expect empty range: [" + startLeaf + ", " + endLeaf + ")"));
        }

        @Override
        final S getStatsBetween0(ToIntFunction<? super S> metric, int startPosition, int endPosition, TriFunction<? super T, Integer, Integer, ? extends S> subStats) {
            int len = this.measure(metric);
            assert (Lists.isNonEmptyRange(startPosition, endPosition, len));
            if (startPosition == 0 && endPosition == len) {
                return this.getStats();
            }
            return this.getStatsBetween0(metric, startPosition, endPosition, subStats, this.children);
        }

        private S getStatsBetween0(ToIntFunction<? super S> metric, int startPosition, int endPosition, TriFunction<? super T, Integer, Integer, ? extends S> subStats, LL<? extends FingerTree<T, S>> nodes) {
            FingerTree<Object, Object> head = nodes.head();
            int headLen = head.measure(metric);
            int headTo = Math.min(endPosition, headLen);
            int tailFrom = Math.max(startPosition - headLen, 0);
            int tailTo = endPosition - headLen;
            if (startPosition < headTo && tailFrom < tailTo) {
                return this.monoid.reduce(head.getStatsBetween0(metric, startPosition, headTo, subStats), this.getStatsBetween0(metric, tailFrom, tailTo, subStats, nodes.tail()));
            }
            if (startPosition < headTo) {
                return head.getStatsBetween0(metric, startPosition, headTo, subStats);
            }
            if (tailFrom < tailTo) {
                return this.getStatsBetween0(metric, tailFrom, tailTo, subStats, nodes.tail());
            }
            throw new AssertionError((Object)("Didn't expect empty range: [" + startPosition + ", " + endPosition + ")"));
        }

        @Override
        Either<FingerTree<T, S>, Tuple2<FingerTree<T, S>, FingerTree<T, S>>> appendLte(FingerTree<T, S> suffix) {
            assert (suffix.getDepth() <= this.getDepth());
            if (suffix.getDepth() == this.getDepth()) {
                return Either.right(Tuples.t(this, suffix));
            }
            if (this.children.size() == 2) {
                return this.children.mapFirst2((left, right) -> right.appendLte(suffix).unify(r -> Either.left(this.branch(left, r)), mr -> Either.left(mr.map((m, r) -> this.branch(left, m, r)))));
            }
            assert (this.children.size() == 3);
            return this.children.mapFirst3((left, middle, right) -> right.appendLte(suffix).unify(r -> Either.left(this.branch(left, middle, r)), mr -> Either.right(Tuples.t(this.branch(left, middle), mr.map(this::branch)))));
        }

        @Override
        Either<FingerTree<T, S>, Tuple2<FingerTree<T, S>, FingerTree<T, S>>> prependLte(FingerTree<T, S> prefix) {
            assert (prefix.getDepth() <= this.getDepth());
            if (prefix.getDepth() == this.getDepth()) {
                return Either.right(Tuples.t(prefix, this));
            }
            if (this.children.size() == 2) {
                return this.children.mapFirst2((left, right) -> left.prependLte(prefix).unify(l -> Either.left(this.branch(l, right)), lm -> Either.left(lm.map((l, m) -> this.branch(l, m, right)))));
            }
            assert (this.children.size() == 3);
            return this.children.mapFirst3((left, middle, right) -> left.prependLte(prefix).unify(l -> Either.left(this.branch(l, middle, right)), lm -> Either.right(Tuples.t(lm.map(this::branch), this.branch(middle, right)))));
        }

        @Override
        Tuple2<FingerTree<T, S>, FingerTree<T, S>> split0(int beforeLeaf) {
            assert (Lists.isValidPosition(beforeLeaf, this.getLeafCount()));
            if (beforeLeaf == 0) {
                return Tuples.t(this.empty(), this);
            }
            return this.split0(beforeLeaf, this.children);
        }

        private Tuple2<FingerTree<T, S>, FingerTree<T, S>> split0(int beforeLeaf, LL<? extends FingerTree<T, S>> nodes) {
            assert (beforeLeaf > 0);
            FingerTree head = nodes.head();
            int headSize = head.getLeafCount();
            if (beforeLeaf <= headSize) {
                return head.split0(beforeLeaf).map((l, r) -> Tuples.t(l, FingerTree.concat(LL.cons(r, nodes.tail()))));
            }
            return this.split0(beforeLeaf - headSize, nodes.tail()).map((l, r) -> Tuples.t(head.appendTree((FingerTree)l), r));
        }

        @Override
        Tuple3<FingerTree<T, S>, Optional<Tuple2<T, Integer>>, FingerTree<T, S>> split0(ToIntFunction<? super S> metric, int position) {
            assert (Lists.isValidPosition(position, this.measure(metric)));
            if (position == 0) {
                return Tuples.t(this.empty(), Optional.empty(), this);
            }
            return this.split0(metric, position, this.children);
        }

        private Tuple3<FingerTree<T, S>, Optional<Tuple2<T, Integer>>, FingerTree<T, S>> split0(ToIntFunction<? super S> metric, int position, LL<? extends FingerTree<T, S>> nodes) {
            assert (position > 0);
            FingerTree head = nodes.head();
            int headLen = head.measure(metric);
            if (position <= headLen) {
                return head.split0(metric, position).map((l, m, r) -> Tuples.t(l, m, FingerTree.concat(LL.cons(r, nodes.tail()))));
            }
            return this.split0(metric, position - headLen, nodes.tail()).map((l, m, r) -> Tuples.t(head.appendTree((FingerTree)l), m, r));
        }
    }

    private static class Leaf<T, S>
    extends FingerTree<T, S> {
        private final T data;
        private final S stats;

        Leaf(MapToMonoid<? super T, S> monoid, T data) {
            super(monoid);
            this.data = data;
            this.stats = monoid.apply(data);
        }

        public String toString() {
            return "Leaf(" + this.data + ")";
        }

        @Override
        public int getDepth() {
            return 1;
        }

        @Override
        public int getLeafCount() {
            return 1;
        }

        @Override
        T getLeaf0(int index) {
            assert (index == 0);
            return this.data;
        }

        @Override
        FingerTree<T, S> updateLeaf0(int index, T data) {
            assert (index == 0);
            return this.leaf(data);
        }

        @Override
        T getData() {
            return this.data;
        }

        @Override
        public S getStats() {
            return this.stats;
        }

        @Override
        BiIndex locateProgressively0(ToIntFunction<? super S> metric, int position) {
            assert (Lists.isValidPosition(position, this.measure(metric)));
            return new BiIndex(0, position);
        }

        @Override
        BiIndex locateRegressively0(ToIntFunction<? super S> metric, int position) {
            assert (Lists.isValidPosition(position, this.measure(metric)));
            return new BiIndex(0, position);
        }

        @Override
        <R> R fold(R acc, BiFunction<? super R, ? super T, ? extends R> reduction) {
            return reduction.apply(acc, this.data);
        }

        @Override
        <R> R foldBetween0(R acc, BiFunction<? super R, ? super T, ? extends R> reduction, int startLeaf, int endLeaf) {
            assert (0 <= startLeaf);
            assert (endLeaf <= 1);
            if (startLeaf < endLeaf) {
                return reduction.apply(acc, this.data);
            }
            return acc;
        }

        @Override
        <R> R foldBetween0(R acc, BiFunction<? super R, ? super T, ? extends R> reduction, ToIntFunction<? super S> metric, int startPosition, int endPosition, TetraFunction<? super R, ? super T, Integer, Integer, ? extends R> rangeReduction) {
            assert (Lists.isValidRange(startPosition, endPosition, this.measure(metric)));
            return rangeReduction.apply(acc, this.data, startPosition, endPosition);
        }

        @Override
        S getStatsBetween0(int startLeaf, int endLeaf) {
            assert (Lists.isNonEmptyRange(startLeaf, endLeaf, this.getLeafCount())) : "Didn't expect empty range [" + startLeaf + ", " + endLeaf + ")";
            return this.getStats();
        }

        @Override
        S getStatsBetween0(ToIntFunction<? super S> metric, int startPosition, int endPosition, TriFunction<? super T, Integer, Integer, ? extends S> subStats) {
            assert (Lists.isNonEmptyRange(startPosition, endPosition, this.measure(metric))) : "Didn't expect empty range [" + startPosition + ", " + endPosition + ")";
            if (startPosition == 0 && endPosition == this.measure(metric)) {
                return this.stats;
            }
            return subStats.apply(this.data, startPosition, endPosition);
        }

        @Override
        Either<FingerTree<T, S>, Tuple2<FingerTree<T, S>, FingerTree<T, S>>> appendLte(FingerTree<T, S> right) {
            assert (right.getDepth() <= this.getDepth());
            if (right.getDepth() == 0) {
                return Either.left(this);
            }
            return Either.right(Tuples.t(this, right));
        }

        @Override
        Either<FingerTree<T, S>, Tuple2<FingerTree<T, S>, FingerTree<T, S>>> prependLte(FingerTree<T, S> left) {
            assert (left.getDepth() <= this.getDepth());
            if (left.getDepth() == 0) {
                return Either.left(this);
            }
            return Either.right(Tuples.t(left, this));
        }

        @Override
        Tuple2<FingerTree<T, S>, FingerTree<T, S>> split0(int beforeLeaf) {
            assert (Lists.isValidPosition(beforeLeaf, 1));
            if (beforeLeaf == 0) {
                return Tuples.t(this.empty(), this);
            }
            return Tuples.t(this, this.empty());
        }

        @Override
        Tuple3<FingerTree<T, S>, Optional<Tuple2<T, Integer>>, FingerTree<T, S>> split0(ToIntFunction<? super S> metric, int position) {
            assert (Lists.isValidPosition(position, this.measure(metric)));
            if (position == 0) {
                return Tuples.t(this.empty(), Optional.empty(), this);
            }
            if (position == this.measure(metric)) {
                return Tuples.t(this, Optional.empty(), this.empty());
            }
            return Tuples.t(this.empty(), Optional.of(Tuples.t(this.data, position)), this.empty());
        }
    }

    private static final class Empty<T, S>
    extends FingerTree<T, S> {
        Empty(MapToMonoid<? super T, S> monoid) {
            super(monoid);
        }

        public String toString() {
            return "<emtpy tree>";
        }

        @Override
        public int getDepth() {
            return 0;
        }

        @Override
        public int getLeafCount() {
            return 0;
        }

        @Override
        T getLeaf0(int index) {
            throw new IndexOutOfBoundsException();
        }

        @Override
        FingerTree<T, S> updateLeaf0(int index, T data) {
            throw new IndexOutOfBoundsException();
        }

        @Override
        T getData() {
            throw new NoSuchElementException();
        }

        @Override
        public S getStats() {
            return (S)this.monoid.unit();
        }

        @Override
        BiIndex locateProgressively0(ToIntFunction<? super S> metric, int position) {
            throw new IndexOutOfBoundsException();
        }

        @Override
        BiIndex locateRegressively0(ToIntFunction<? super S> metric, int position) {
            throw new IndexOutOfBoundsException();
        }

        @Override
        <R> R fold(R acc, BiFunction<? super R, ? super T, ? extends R> reduction) {
            return acc;
        }

        @Override
        <R> R foldBetween0(R acc, BiFunction<? super R, ? super T, ? extends R> reduction, int startLeaf, int endLeaf) {
            assert (Lists.isValidRange(startLeaf, endLeaf, 0));
            return acc;
        }

        @Override
        <R> R foldBetween0(R acc, BiFunction<? super R, ? super T, ? extends R> reduction, ToIntFunction<? super S> metric, int startPosition, int endPosition, TetraFunction<? super R, ? super T, Integer, Integer, ? extends R> rangeReduction) {
            assert (Lists.isValidRange(startPosition, endPosition, 0));
            return acc;
        }

        @Override
        S getStatsBetween0(int startLeaf, int endLeaf) {
            assert (Lists.isValidRange(startLeaf, endLeaf, 0));
            return (S)this.monoid.unit();
        }

        @Override
        S getStatsBetween0(ToIntFunction<? super S> metric, int startPosition, int endPosition, TriFunction<? super T, Integer, Integer, ? extends S> subStats) {
            assert (Lists.isValidRange(startPosition, endPosition, 0));
            return (S)this.monoid.unit();
        }

        @Override
        Tuple2<FingerTree<T, S>, FingerTree<T, S>> split0(int beforeLeaf) {
            assert (beforeLeaf == 0);
            return Tuples.t(this, this);
        }

        @Override
        Tuple3<FingerTree<T, S>, Optional<Tuple2<T, Integer>>, FingerTree<T, S>> split0(ToIntFunction<? super S> metric, int position) {
            assert (position == 0);
            return Tuples.t(this, Optional.empty(), this);
        }

        @Override
        Either<FingerTree<T, S>, Tuple2<FingerTree<T, S>, FingerTree<T, S>>> appendLte(FingerTree<T, S> right) {
            assert (right.getDepth() == 0);
            return Either.left(right);
        }

        @Override
        Either<FingerTree<T, S>, Tuple2<FingerTree<T, S>, FingerTree<T, S>>> prependLte(FingerTree<T, S> left) {
            assert (left.getDepth() == 0);
            return Either.left(left);
        }
    }
}

