/*
 * Decompiled with CFR 0.152.
 */
package org.reactfx.collection;

import java.util.function.BinaryOperator;
import javafx.collections.ObservableList;
import org.reactfx.Subscription;
import org.reactfx.collection.ListChange;
import org.reactfx.collection.ListModification;
import org.reactfx.collection.LiveList;
import org.reactfx.util.FingerTree;
import org.reactfx.util.MapToMonoid;
import org.reactfx.value.ValBase;

class ListReduction<T>
extends ValBase<T> {
    private final ObservableList<T> input;
    private final BinaryOperator<T> reduction;
    private final MapToMonoid<T, T> monoid;
    private FingerTree<T, T> tree = null;

    ListReduction(ObservableList<T> input, final BinaryOperator<T> reduction) {
        this.input = input;
        this.reduction = reduction;
        this.monoid = new MapToMonoid<T, T>(){

            @Override
            public T apply(T t) {
                return t;
            }

            @Override
            public T unit() {
                return null;
            }

            @Override
            public T reduce(T left, T right) {
                return reduction.apply(left, right);
            }
        };
    }

    @Override
    protected Subscription connect() {
        assert (this.tree == null);
        this.tree = FingerTree.mkTree(this.input, this.monoid);
        return LiveList.observeChanges(this.input, (? super ListChange<? extends E> ch) -> {
            for (ListModification mod : ch) {
                FingerTree left = (FingerTree)this.tree.split((int)mod.getFrom())._1;
                FingerTree right = (FingerTree)this.tree.split((int)(mod.getFrom() + mod.getRemovedSize()))._2;
                FingerTree middle = FingerTree.mkTree(mod.getAddedSubList(), this.monoid);
                this.tree = left.join(middle).join(right);
            }
            this.invalidate();
        }).and(() -> {
            this.tree = null;
        });
    }

    protected int getFrom(int max) {
        return 0;
    }

    protected int getTo(int max) {
        return max;
    }

    @Override
    protected final T computeValue() {
        if (this.isObservingInputs()) {
            assert (this.tree != null);
            int max = this.tree.getLeafCount();
            return this.tree.getStatsBetween(this.getFrom(max), this.getTo(max));
        }
        assert (this.tree == null);
        int max = this.input.size();
        return this.input.subList(this.getFrom(max), this.getTo(max)).stream().reduce(this.reduction).orElse(null);
    }
}

