/*
 * Decompiled with CFR 0.152.
 */
package org.reactfx.collection;

import java.util.function.Function;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import org.reactfx.Subscription;
import org.reactfx.collection.LiveList;
import org.reactfx.collection.LiveListBase;
import org.reactfx.collection.MappedList;
import org.reactfx.collection.QuasiListChange;
import org.reactfx.collection.ReadOnlyLiveListImpl;
import org.reactfx.util.Lists;
import org.reactfx.value.Val;

class DynamicallyMappedList<E, F>
extends LiveListBase<F>
implements ReadOnlyLiveListImpl<F> {
    private final ObservableList<? extends E> source;
    private final Val<? extends Function<? super E, ? extends F>> mapper;

    public DynamicallyMappedList(ObservableList<? extends E> source, ObservableValue<? extends Function<? super E, ? extends F>> mapper) {
        this.source = source;
        this.mapper = Val.wrap(mapper);
    }

    @Override
    public F get(int index) {
        return (F)((Function)this.mapper.getValue()).apply(this.source.get(index));
    }

    @Override
    public int size() {
        return this.source.size();
    }

    @Override
    protected Subscription observeInputs() {
        return Subscription.multi(LiveList.observeQuasiChanges(this.source, this::sourceChanged), this.mapper.observeInvalidations(this::mapperInvalidated));
    }

    private void sourceChanged(QuasiListChange<? extends E> change) {
        this.notifyObservers(MappedList.mappedChangeView(change, (Function)this.mapper.getValue()));
    }

    private void mapperInvalidated(Function<? super E, ? extends F> oldMapper) {
        this.fireContentReplacement(Lists.mappedView(this.source, oldMapper));
    }
}

