/*
 * Decompiled with CFR 0.152.
 */
package org.reactfx;

import javafx.beans.value.ObservableValue;
import org.reactfx.EventStreamBase;
import org.reactfx.EventStreams;
import org.reactfx.Guard;
import org.reactfx.Subscription;
import org.reactfx.SuspendableEventStream;

class SuspendWhenStream<T>
extends EventStreamBase<T> {
    private final SuspendableEventStream<T> source;
    private final ObservableValue<Boolean> condition;
    private Guard suspensionGuard = null;

    public SuspendWhenStream(SuspendableEventStream<T> source, ObservableValue<Boolean> condition) {
        this.source = source;
        this.condition = condition;
    }

    @Override
    protected Subscription observeInputs() {
        Subscription s1 = EventStreams.valuesOf(this.condition).subscribe(this::suspendSource);
        Subscription s2 = this.source.subscribe(this::emit);
        return s1.and(s2).and(this::resumeSource);
    }

    private void suspendSource(boolean suspend) {
        if (suspend) {
            this.suspendSource();
        } else {
            this.resumeSource();
        }
    }

    private void suspendSource() {
        if (this.suspensionGuard == null) {
            this.suspensionGuard = this.source.suspend();
        }
    }

    private void resumeSource() {
        if (this.suspensionGuard != null) {
            Guard toClose = this.suspensionGuard;
            this.suspensionGuard = null;
            toClose.close();
        }
    }
}

