/*
 * Decompiled with CFR 0.152.
 */
package org.gillius.jfxutils.chart;

import javafx.event.EventHandler;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.chart.XYChart;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Region;
import javafx.scene.layout.StackPane;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Rectangle;
import javafx.scene.shape.StrokeType;
import org.gillius.jfxutils.JFXUtil;
import org.gillius.jfxutils.chart.ChartZoomManager;

public class JFXChartUtil {
    public static Region setupZooming(XYChart<?, ?> chart) {
        return JFXChartUtil.setupZooming(chart, ChartZoomManager.DEFAULT_FILTER);
    }

    public static Region setupZooming(XYChart<?, ?> chart, EventHandler<? super MouseEvent> mouseFilter) {
        StackPane chartPane = new StackPane();
        if (chart.getParent() != null) {
            JFXUtil.replaceComponent(chart, (Node)chartPane);
        }
        Rectangle selectRect = new Rectangle(0.0, 0.0, 0.0, 0.0);
        selectRect.setFill((Paint)Color.DODGERBLUE);
        selectRect.setMouseTransparent(true);
        selectRect.setOpacity(0.3);
        selectRect.setStroke((Paint)Color.rgb((int)0, (int)41, (int)102));
        selectRect.setStrokeType(StrokeType.INSIDE);
        selectRect.setStrokeWidth(3.0);
        StackPane.setAlignment((Node)selectRect, (Pos)Pos.TOP_LEFT);
        chartPane.getChildren().addAll((Object[])new Node[]{chart, selectRect});
        ChartZoomManager zoomManager = new ChartZoomManager((Pane)chartPane, selectRect, chart);
        zoomManager.setMouseFilter(mouseFilter);
        zoomManager.start();
        return chartPane;
    }
}

