/*
 * Decompiled with CFR 0.152.
 */
package org.gillius.jfxutils.chart;

import org.gillius.jfxutils.chart.AxisConstraint;
import org.gillius.jfxutils.chart.AxisConstraintStrategy;
import org.gillius.jfxutils.chart.ChartInputContext;

public class AxisConstraintStrategies {
    private static final AxisConstraintStrategy DEFAULT = new DefaultAxisConstraintStrategy();
    private static final AxisConstraintStrategy IGNORE_OUTSIDE_CHART = new IgnoreOutsideChartAxisConstraintStrategy();

    public static AxisConstraintStrategy getDefault() {
        return DEFAULT;
    }

    public static AxisConstraintStrategy getIgnoreOutsideChart() {
        return IGNORE_OUTSIDE_CHART;
    }

    public static AxisConstraintStrategy getFixed(AxisConstraint constraint) {
        return new FixedAxisConstraintStrategy(constraint);
    }

    private static class FixedAxisConstraintStrategy
    implements AxisConstraintStrategy {
        private final AxisConstraint constraint;

        public FixedAxisConstraintStrategy(AxisConstraint constraint) {
            this.constraint = constraint;
        }

        @Override
        public AxisConstraint getConstraint(ChartInputContext context) {
            return this.constraint;
        }
    }

    private static class IgnoreOutsideChartAxisConstraintStrategy
    implements AxisConstraintStrategy {
        private IgnoreOutsideChartAxisConstraintStrategy() {
        }

        @Override
        public AxisConstraint getConstraint(ChartInputContext context) {
            if (context.isInXAxis()) {
                return AxisConstraint.Horizontal;
            }
            if (context.isInYAxis()) {
                return AxisConstraint.Vertical;
            }
            if (context.isInPlotArea()) {
                return AxisConstraint.Both;
            }
            return AxisConstraint.None;
        }
    }

    private static class DefaultAxisConstraintStrategy
    implements AxisConstraintStrategy {
        private DefaultAxisConstraintStrategy() {
        }

        @Override
        public AxisConstraint getConstraint(ChartInputContext context) {
            if (context.isInXAxis()) {
                return AxisConstraint.Horizontal;
            }
            if (context.isInYAxis()) {
                return AxisConstraint.Vertical;
            }
            return AxisConstraint.Both;
        }
    }
}

