/*
 * Decompiled with CFR 0.152.
 */
package org.fxmisc.richtext.skin;

import java.time.Duration;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.IntSupplier;
import java.util.function.IntUnaryOperator;
import java.util.function.UnaryOperator;
import java.util.stream.Stream;
import javafx.beans.Observable;
import javafx.beans.binding.Binding;
import javafx.beans.binding.Bindings;
import javafx.beans.binding.BooleanBinding;
import javafx.beans.binding.ObjectBinding;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableSet;
import javafx.css.CssMetaData;
import javafx.css.Styleable;
import javafx.css.StyleableObjectProperty;
import javafx.event.Event;
import javafx.geometry.BoundingBox;
import javafx.geometry.Bounds;
import javafx.geometry.Point2D;
import javafx.scene.control.IndexRange;
import javafx.scene.layout.Region;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.stage.PopupWindow;
import org.fxmisc.flowless.Cell;
import org.fxmisc.flowless.VirtualFlow;
import org.fxmisc.flowless.VirtualFlowHit;
import org.fxmisc.richtext.MouseOverTextEvent;
import org.fxmisc.richtext.Paragraph;
import org.fxmisc.richtext.PopupAlignment;
import org.fxmisc.richtext.StyledTextArea;
import org.fxmisc.richtext.TwoDimensional;
import org.fxmisc.richtext.TwoLevelNavigator;
import org.fxmisc.richtext.skin.CharacterHit;
import org.fxmisc.richtext.skin.CssProperties;
import org.fxmisc.richtext.skin.ParagraphBox;
import org.fxmisc.richtext.skin.TextExt;
import org.reactfx.EventStream;
import org.reactfx.EventStreams;
import org.reactfx.Subscription;
import org.reactfx.value.Val;

class StyledTextAreaView<S>
extends Region {
    private final StyleableObjectProperty<Paint> highlightFill = new CssProperties.HighlightFillProperty((Object)this, (Paint)Color.DODGERBLUE);
    private final StyleableObjectProperty<Paint> highlightTextFill = new CssProperties.HighlightTextFillProperty((Object)this, (Paint)Color.WHITE);
    private final StyledTextArea<S> area;
    private Subscription subscriptions = () -> {};
    private final Binding<Boolean> caretVisible;
    private final Val<UnaryOperator<Point2D>> popupAnchorAdjustment;
    private final VirtualFlow<Paragraph<S>, Cell<Paragraph<S>, ParagraphBox<S>>> virtualFlow;
    private final TwoLevelNavigator navigator;
    private boolean followCaretRequested = false;

    public StyledTextAreaView(StyledTextArea<S> styledTextArea, BiConsumer<? super TextExt, S> applyStyle) {
        this.area = styledTextArea;
        this.area.getStylesheets().add((Object)StyledTextAreaView.class.getResource("styled-text-area.css").toExternalForm());
        ObservableSet nonEmptyCells = FXCollections.observableSet((Object[])new ParagraphBox[0]);
        this.virtualFlow = VirtualFlow.createVertical(this.area.getParagraphs(), par -> {
            Cell cell = this.createCell((Paragraph<S>)par, applyStyle);
            nonEmptyCells.add(cell.getNode());
            return cell.beforeReset(() -> nonEmptyCells.remove(cell.getNode())).afterUpdateItem(p -> nonEmptyCells.add(cell.getNode()));
        });
        this.getChildren().add(this.virtualFlow);
        IntSupplier cellCount = () -> this.area.getParagraphs().size();
        IntUnaryOperator cellLength = i -> this.virtualFlow.getCell(i).getNode().getLineCount();
        this.navigator = new TwoLevelNavigator(cellCount, cellLength);
        EventStream<Void> caretPosDirty = EventStreams.invalidationsOf(this.area.caretPositionProperty());
        EventStream<Void> paragraphsDirty = EventStreams.invalidationsOf(this.area.getParagraphs());
        EventStream<Void> selectionDirty = EventStreams.invalidationsOf(this.area.selectionProperty());
        EventStream caretDirty = EventStreams.merge(caretPosDirty, paragraphsDirty, selectionDirty);
        this.subscribeTo(caretDirty, x -> this.requestFollowCaret());
        BooleanBinding blinkCaret = this.area.focusedProperty().and((ObservableBooleanValue)this.area.editableProperty()).and((ObservableBooleanValue)this.area.disabledProperty().not());
        this.manageBinding((Binding<?>)blinkCaret);
        this.caretVisible = EventStreams.valuesOf(blinkCaret).flatMap(blink -> blink != false ? StyledTextAreaView.booleanPulse(Duration.ofMillis(500L)) : EventStreams.valuesOf(Val.constant(false))).toBinding(false);
        this.manageBinding(this.caretVisible);
        Val<UnaryOperator> userOffset = Val.map(this.area.popupAnchorOffsetProperty(), offset -> anchor -> anchor.add(offset));
        this.popupAnchorAdjustment = Val.orElse(this.area.popupAnchorAdjustmentProperty(), userOffset).orElseConst(UnaryOperator.identity());
        EventStreams.valuesOf(this.area.mouseOverTextDelayProperty()).flatMap(delay -> delay != null ? this.mouseOverTextEvents((ObservableSet<ParagraphBox<S>>)nonEmptyCells, (Duration)delay) : EventStreams.never()).subscribe(evt -> Event.fireEvent(this.area, (Event)evt));
    }

    public void dispose() {
        this.subscriptions.unsubscribe();
        this.virtualFlow.dispose();
    }

    protected void layoutChildren() {
        this.virtualFlow.resize(this.getWidth(), this.getHeight());
        if (this.followCaretRequested) {
            this.followCaretRequested = false;
            this.followCaret();
        }
        PopupWindow popup = this.area.getPopupWindow();
        PopupAlignment alignment = this.area.getPopupAlignment();
        UnaryOperator adjustment = (UnaryOperator)this.popupAnchorAdjustment.getValue();
        if (popup != null) {
            this.positionPopup(popup, alignment, adjustment);
        }
    }

    public List<CssMetaData<? extends Styleable, ?>> getCssMetaData() {
        return Arrays.asList(this.highlightFill.getCssMetaData(), this.highlightTextFill.getCssMetaData());
    }

    void scrollBy(Point2D deltas) {
        this.virtualFlow.scrollX(deltas.getX());
        this.virtualFlow.scrollY(deltas.getY());
    }

    void show(double y) {
        this.virtualFlow.show(y);
    }

    void showCaretAtBottom() {
        int parIdx = this.area.getCurrentParagraph();
        Cell<Paragraph<S>, ParagraphBox<S>> cell = this.virtualFlow.getCell(parIdx);
        Bounds caretBounds = cell.getNode().getCaretBounds();
        double y = caretBounds.getMaxY();
        this.virtualFlow.showAtOffset(parIdx, this.getViewportHeight() - y);
    }

    void showCaretAtTop() {
        int parIdx = this.area.getCurrentParagraph();
        Cell<Paragraph<S>, ParagraphBox<S>> cell = this.virtualFlow.getCell(parIdx);
        Bounds caretBounds = cell.getNode().getCaretBounds();
        double y = caretBounds.getMinY();
        this.virtualFlow.showAtOffset(parIdx, -y);
    }

    void requestFollowCaret() {
        this.followCaretRequested = true;
        this.requestLayout();
    }

    private void followCaret() {
        int parIdx = this.area.getCurrentParagraph();
        Cell<Paragraph<S>, ParagraphBox<S>> cell = this.virtualFlow.getCell(parIdx);
        Bounds caretBounds = cell.getNode().getCaretBounds();
        double graphicWidth = cell.getNode().getGraphicPrefWidth();
        Bounds region = StyledTextAreaView.extendLeft(caretBounds, graphicWidth);
        this.virtualFlow.show(parIdx, region);
    }

    Optional<Bounds> getCaretBounds() {
        return this.virtualFlow.getCellIfVisible(this.area.getCurrentParagraph()).map(c -> {
            Bounds cellBounds = ((ParagraphBox)((Object)((Object)c.getNode()))).getCaretBounds();
            return this.virtualFlow.cellToViewport((Cell<Paragraph<S>, ParagraphBox<S>>)c, cellBounds);
        });
    }

    ParagraphBox.CaretOffsetX getCaretOffsetX() {
        int idx = this.area.getCurrentParagraph();
        return this.getCell(idx).getCaretOffsetX();
    }

    double getViewportHeight() {
        return this.virtualFlow.getViewportHeight();
    }

    CharacterHit hit(ParagraphBox.CaretOffsetX x, TwoDimensional.Position targetLine) {
        int parIdx = targetLine.getMajor();
        ParagraphBox<S> cell = this.virtualFlow.getCell(parIdx).getNode();
        CharacterHit parHit = cell.hitTextLine(x, targetLine.getMinor());
        return parHit.offset(this.getParagraphOffset(parIdx));
    }

    CharacterHit hit(ParagraphBox.CaretOffsetX x, double y) {
        VirtualFlowHit<Cell<Paragraph<S>, ParagraphBox<S>>> hit = this.virtualFlow.hit(0.0, y);
        if (hit.isBeforeCells()) {
            return CharacterHit.insertionAt(0);
        }
        if (hit.isAfterCells()) {
            return CharacterHit.insertionAt(this.area.getLength());
        }
        int parIdx = hit.getCellIndex();
        int parOffset = this.getParagraphOffset(parIdx);
        ParagraphBox<S> cell = hit.getCell().getNode();
        Point2D cellOffset = hit.getCellOffset();
        CharacterHit parHit = cell.hitText(x, cellOffset.getY());
        return parHit.offset(parOffset);
    }

    CharacterHit hit(double x, double y) {
        VirtualFlowHit<Cell<Paragraph<S>, ParagraphBox<S>>> hit = this.virtualFlow.hit(x, y);
        if (hit.isBeforeCells()) {
            return CharacterHit.insertionAt(0);
        }
        if (hit.isAfterCells()) {
            return CharacterHit.insertionAt(this.area.getLength());
        }
        int parIdx = hit.getCellIndex();
        int parOffset = this.getParagraphOffset(parIdx);
        ParagraphBox<S> cell = hit.getCell().getNode();
        Point2D cellOffset = hit.getCellOffset();
        CharacterHit parHit = cell.hit(cellOffset);
        return parHit.offset(parOffset);
    }

    TwoDimensional.Position currentLine() {
        int parIdx = this.area.getCurrentParagraph();
        Cell<Paragraph<S>, ParagraphBox<S>> cell = this.virtualFlow.getCell(parIdx);
        int lineIdx = cell.getNode().getCurrentLineIndex();
        return this.position(parIdx, lineIdx);
    }

    TwoDimensional.Position position(int par, int line) {
        return this.navigator.position(par, line);
    }

    private Cell<Paragraph<S>, ParagraphBox<S>> createCell(Paragraph<S> paragraph, BiConsumer<? super TextExt, S> applyStyle) {
        final ParagraphBox<S> box = new ParagraphBox<S>(paragraph, applyStyle);
        box.highlightFillProperty().bind(this.highlightFill);
        box.highlightTextFillProperty().bind(this.highlightTextFill);
        box.wrapTextProperty().bind((ObservableValue)this.area.wrapTextProperty());
        box.graphicFactoryProperty().bind(this.area.paragraphGraphicFactoryProperty());
        box.graphicOffset.bind((ObservableValue)this.virtualFlow.breadthOffsetProperty());
        Val<Boolean> hasCaret = Val.combine(box.indexProperty(), this.area.currentParagraphProperty(), (bi, cp) -> bi.intValue() == cp.intValue());
        Val<Boolean> cellCaretVisible = Val.combine(hasCaret, this.caretVisible, (a, b) -> a != false && b != false);
        box.caretVisibleProperty().bind(cellCaretVisible);
        box.caretPositionProperty().bind(hasCaret.flatMap(has -> has != false ? this.area.caretColumnProperty() : Val.constant(0)));
        final ObjectBinding cellSelection = Bindings.createObjectBinding(() -> {
            int idx = box.getIndex();
            return idx != -1 ? this.area.getParagraphSelection(idx) : StyledTextArea.EMPTY_RANGE;
        }, (Observable[])new Observable[]{this.area.selectionProperty(), box.indexProperty()});
        box.selectionProperty().bind((ObservableValue)cellSelection);
        return new Cell<Paragraph<S>, ParagraphBox<S>>(){

            @Override
            public ParagraphBox<S> getNode() {
                return box;
            }

            @Override
            public void updateIndex(int index) {
                box.setIndex(index);
            }

            @Override
            public void dispose() {
                box.highlightFillProperty().unbind();
                box.highlightTextFillProperty().unbind();
                box.wrapTextProperty().unbind();
                box.graphicFactoryProperty().unbind();
                box.graphicOffset.unbind();
                box.caretVisibleProperty().unbind();
                box.caretPositionProperty().unbind();
                box.selectionProperty().unbind();
                cellSelection.dispose();
            }
        };
    }

    private ParagraphBox<S> getCell(int index) {
        return this.virtualFlow.getCell(index).getNode();
    }

    private EventStream<MouseOverTextEvent> mouseOverTextEvents(ObservableSet<ParagraphBox<S>> cells, Duration delay) {
        return EventStreams.merge(cells, c -> c.stationaryIndices(delay).map(e -> e.unify(l -> l.map((pos, charIdx) -> MouseOverTextEvent.beginAt(c.localToScreen((Point2D)pos), this.getParagraphOffset(c.getIndex()) + charIdx)), r -> MouseOverTextEvent.end())));
    }

    private int getParagraphOffset(int parIdx) {
        return this.area.position(parIdx, 0).toOffset();
    }

    private void positionPopup(PopupWindow popup, PopupAlignment alignment, UnaryOperator<Point2D> adjustment) {
        Optional<Bounds> bounds = null;
        switch (alignment.getAnchorObject()) {
            case CARET: {
                bounds = this.getCaretBoundsOnScreen();
                break;
            }
            case SELECTION: {
                bounds = this.getSelectionBoundsOnScreen();
            }
        }
        bounds.ifPresent(b -> {
            double x = 0.0;
            double y = 0.0;
            switch (alignment.getHorizontalAlignment()) {
                case LEFT: {
                    x = b.getMinX();
                    break;
                }
                case H_CENTER: {
                    x = (b.getMinX() + b.getMaxX()) / 2.0;
                    break;
                }
                case RIGHT: {
                    x = b.getMaxX();
                }
            }
            switch (alignment.getVerticalAlignment()) {
                case TOP: {
                    y = b.getMinY();
                }
                case V_CENTER: {
                    y = (b.getMinY() + b.getMaxY()) / 2.0;
                    break;
                }
                case BOTTOM: {
                    y = b.getMaxY();
                }
            }
            Point2D anchor = (Point2D)adjustment.apply(new Point2D(x, y));
            popup.setAnchorX(anchor.getX());
            popup.setAnchorY(anchor.getY());
        });
    }

    private Optional<Bounds> getCaretBoundsOnScreen() {
        return this.virtualFlow.getCellIfVisible(this.area.getCurrentParagraph()).map(c -> ((ParagraphBox)((Object)((Object)c.getNode()))).getCaretBoundsOnScreen());
    }

    private Optional<Bounds> getSelectionBoundsOnScreen() {
        IndexRange selection = this.area.getSelection();
        if (selection.getLength() == 0) {
            return this.getCaretBoundsOnScreen();
        }
        Bounds[] bounds = (Bounds[])this.virtualFlow.visibleCells().stream().map(c -> ((ParagraphBox)((Object)((Object)c.getNode()))).getSelectionBoundsOnScreen()).filter(opt -> opt.isPresent()).map(opt -> (Bounds)opt.get()).toArray(Bounds[]::new);
        if (bounds.length == 0) {
            return Optional.empty();
        }
        double minX = Stream.of(bounds).mapToDouble(Bounds::getMinX).min().getAsDouble();
        double maxX = Stream.of(bounds).mapToDouble(Bounds::getMaxX).max().getAsDouble();
        double minY = Stream.of(bounds).mapToDouble(Bounds::getMinY).min().getAsDouble();
        double maxY = Stream.of(bounds).mapToDouble(Bounds::getMaxY).max().getAsDouble();
        return Optional.of(new BoundingBox(minX, minY, maxX - minX, maxY - minY));
    }

    private <T> void subscribeTo(EventStream<T> src, Consumer<T> consumer) {
        this.manageSubscription(src.subscribe(consumer));
    }

    private void manageSubscription(Subscription subscription) {
        this.subscriptions = this.subscriptions.and(subscription);
    }

    private void manageBinding(Binding<?> binding) {
        this.subscriptions = this.subscriptions.and(() -> binding.dispose());
    }

    private static Bounds extendLeft(Bounds b, double w) {
        if (w == 0.0) {
            return b;
        }
        return new BoundingBox(b.getMinX() - w, b.getMinY(), b.getWidth() + w, b.getHeight());
    }

    private static EventStream<Boolean> booleanPulse(Duration duration) {
        return EventStreams.ticks(duration).accumulate(true, (b, x) -> b == false);
    }
}

