/*
 * Decompiled with CFR 0.152.
 */
package org.fxmisc.richtext.skin;

import java.time.Duration;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.function.BiConsumer;
import java.util.function.IntFunction;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.Property;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ChangeListener;
import javafx.geometry.Bounds;
import javafx.geometry.Insets;
import javafx.geometry.Point2D;
import javafx.scene.Node;
import javafx.scene.control.IndexRange;
import javafx.scene.layout.Region;
import javafx.scene.paint.Paint;
import org.fxmisc.richtext.Paragraph;
import org.fxmisc.richtext.skin.CharacterHit;
import org.fxmisc.richtext.skin.ParagraphText;
import org.fxmisc.richtext.skin.TextExt;
import org.fxmisc.richtext.util.MouseStationaryHelper;
import org.reactfx.EventStream;
import org.reactfx.util.Either;
import org.reactfx.util.Tuple2;
import org.reactfx.util.Tuples;
import org.reactfx.value.Val;
import org.reactfx.value.Var;

class ParagraphBox<S>
extends Region {
    private final ParagraphText<S> text;
    private final ObjectProperty<IntFunction<? extends Node>> graphicFactory = new SimpleObjectProperty(null);
    private final Val<Node> graphic;
    final DoubleProperty graphicOffset = new SimpleDoubleProperty(0.0);
    private final BooleanProperty wrapText = new SimpleBooleanProperty(false);
    private final Var<Integer> index;

    public ObjectProperty<IntFunction<? extends Node>> graphicFactoryProperty() {
        return this.graphicFactory;
    }

    public BooleanProperty wrapTextProperty() {
        return this.wrapText;
    }

    public Val<Integer> indexProperty() {
        return this.index;
    }

    public void setIndex(int index) {
        this.index.setValue(index);
    }

    public int getIndex() {
        return (Integer)this.index.getValue();
    }

    public ParagraphBox(Paragraph<S> par, BiConsumer<? super TextExt, S> applyStyle) {
        this.wrapText.addListener((obs, old, w) -> this.requestLayout());
        this.getStyleClass().add((Object)"paragraph-box");
        this.text = new ParagraphText<S>(par, applyStyle);
        this.index = Var.newSimpleVar(0);
        this.getChildren().add(this.text);
        this.graphic = Val.combine(this.graphicFactory, this.index, (f, i) -> f != null ? (Node)f.apply((int)i) : null);
        this.graphic.addListener((ChangeListener<Node>)((ChangeListener)(obs, oldG, newG) -> {
            if (oldG != null) {
                this.getChildren().remove(oldG);
            }
            if (newG != null) {
                this.getChildren().add(newG);
            }
        }));
        this.graphicOffset.addListener(obs -> this.requestLayout());
    }

    public String toString() {
        return this.graphic.isPresent() ? "[#|" + this.text.getParagraph() + "]" : "[" + this.text.getParagraph() + "]";
    }

    public Property<Boolean> caretVisibleProperty() {
        return this.text.caretVisibleProperty();
    }

    public Property<Paint> highlightFillProperty() {
        return this.text.highlightFillProperty();
    }

    public Property<Paint> highlightTextFillProperty() {
        return this.text.highlightTextFillProperty();
    }

    public Var<Integer> caretPositionProperty() {
        return this.text.caretPositionProperty();
    }

    public Property<IndexRange> selectionProperty() {
        return this.text.selectionProperty();
    }

    Paragraph<S> getParagraph() {
        return this.text.getParagraph();
    }

    public EventStream<Either<Tuple2<Point2D, Integer>, Object>> stationaryIndices(Duration delay) {
        EventStream<Either<Point2D, Void>> stationaryEvents = new MouseStationaryHelper((Node)this).events(delay);
        EventStream<Void> hits = stationaryEvents.filterMap(Either::asLeft).filterMap(p -> {
            OptionalInt charIdx = this.hit((Point2D)p).getCharacterIndex();
            if (charIdx.isPresent()) {
                return Optional.of(Tuples.t(p, charIdx.getAsInt()));
            }
            return Optional.empty();
        });
        EventStream<Void> stops = stationaryEvents.filter(Either::isRight).map(Either::getRight);
        return hits.or(stops);
    }

    public CharacterHit hit(Point2D pos) {
        return this.hit(pos.getX(), pos.getY());
    }

    public CharacterHit hit(double x, double y) {
        Point2D onScreen = this.localToScreen(x, y);
        Point2D inText = this.text.screenToLocal(onScreen);
        return this.text.hit(inText.getX(), inText.getY());
    }

    public CaretOffsetX getCaretOffsetX() {
        this.layout();
        return new CaretOffsetX(this.text.getCaretOffsetX());
    }

    public int getLineCount() {
        this.layout();
        return this.text.getLineCount();
    }

    public int getCurrentLineIndex() {
        this.layout();
        return this.text.currentLineIndex();
    }

    public Bounds getCaretBounds() {
        this.layout();
        Bounds b = this.text.getCaretBounds();
        return this.text.localToParent(b);
    }

    public Bounds getCaretBoundsOnScreen() {
        this.layout();
        return this.text.getCaretBoundsOnScreen();
    }

    public Optional<Bounds> getSelectionBoundsOnScreen() {
        this.layout();
        return this.text.getSelectionBoundsOnScreen();
    }

    protected double computeMinWidth(double ignoredHeight) {
        return this.computePrefWidth(-1.0);
    }

    protected double computePrefWidth(double ignoredHeight) {
        Insets insets = this.getInsets();
        return this.wrapText.get() ? 0.0 : this.getGraphicPrefWidth() + this.text.prefWidth(-1.0) + insets.getLeft() + insets.getRight();
    }

    protected double computePrefHeight(double width) {
        Insets insets = this.getInsets();
        double overhead = this.getGraphicPrefWidth() - insets.getLeft() - insets.getRight();
        return this.text.prefHeight(width - overhead) + insets.getTop() + insets.getBottom();
    }

    protected void layoutChildren() {
        Bounds bounds = this.getLayoutBounds();
        double w = bounds.getWidth();
        double h = bounds.getHeight();
        double graphicWidth = this.getGraphicPrefWidth();
        this.text.resizeRelocate(graphicWidth, 0.0, w - graphicWidth, h);
        this.graphic.ifPresent(g -> g.resizeRelocate(this.graphicOffset.get(), 0.0, graphicWidth, h));
    }

    double getGraphicPrefWidth() {
        if (this.graphic.isPresent()) {
            return ((Node)this.graphic.getValue()).prefWidth(-1.0);
        }
        return 0.0;
    }

    CharacterHit hitTextLine(CaretOffsetX x, int line) {
        return this.text.hitLine(x.value, line);
    }

    CharacterHit hitText(CaretOffsetX x, double y) {
        return this.text.hit(x.value, y);
    }

    public static class CaretOffsetX {
        private final double value;

        private CaretOffsetX(double value) {
            this.value = value;
        }
    }
}

