/*
 * Decompiled with CFR 0.152.
 */
package org.fxmisc.richtext;

import org.fxmisc.richtext.StyleSpan;
import org.fxmisc.richtext.StyleSpans;
import org.fxmisc.richtext.StyleSpansBase;

class UpdatedSpans<S>
extends StyleSpansBase<S> {
    private final StyleSpans<S> original;
    private final int index;
    private final StyleSpan<S> update;
    private int length = -1;

    public UpdatedSpans(StyleSpans<S> original, int index, StyleSpan<S> update) {
        this.original = original;
        this.index = index;
        this.update = update;
    }

    @Override
    public int length() {
        if (this.length == -1) {
            this.length = this.original.length() - this.original.getStyleSpan(this.index).getLength() + this.update.getLength();
        }
        return this.length;
    }

    @Override
    public int getSpanCount() {
        return this.original.getSpanCount();
    }

    @Override
    public StyleSpan<S> getStyleSpan(int index) {
        if (index == this.index) {
            return this.update;
        }
        return this.original.getStyleSpan(index);
    }
}

