/*
 * Decompiled with CFR 0.152.
 */
package org.fxmisc.richtext;

import javafx.beans.property.BooleanProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.scene.control.IndexRange;
import org.fxmisc.richtext.Paragraph;
import org.fxmisc.richtext.PlainTextChange;
import org.fxmisc.richtext.RichTextChange;
import org.fxmisc.richtext.StyledDocument;
import org.reactfx.EventStream;

public interface TextEditingArea<S> {
    public int getLength();

    public ObservableValue<Integer> lengthProperty();

    public String getText();

    public ObservableValue<String> textProperty();

    public StyledDocument<S> getDocument();

    public int getCaretPosition();

    public ObservableValue<Integer> caretPositionProperty();

    public int getAnchor();

    public ObservableValue<Integer> anchorProperty();

    public IndexRange getSelection();

    public ObservableValue<IndexRange> selectionProperty();

    public String getSelectedText();

    public ObservableValue<String> selectedTextProperty();

    public int getCurrentParagraph();

    public ObservableValue<Integer> currentParagraphProperty();

    public int getCaretColumn();

    public ObservableValue<Integer> caretColumnProperty();

    public ObservableList<Paragraph<S>> getParagraphs();

    public EventStream<PlainTextChange> plainTextChanges();

    public EventStream<RichTextChange<S>> richChanges();

    public String getText(int var1);

    public String getText(int var1, int var2);

    public StyledDocument<S> subDocument(int var1);

    public StyledDocument<S> subDocument(int var1, int var2);

    public boolean isEditable();

    public void setEditable(boolean var1);

    public BooleanProperty editableProperty();

    public boolean isWrapText();

    public void setWrapText(boolean var1);

    public BooleanProperty wrapTextProperty();

    public void selectRange(int var1, int var2);

    public void replaceText(int var1, int var2, String var3);

    public void replace(int var1, int var2, StyledDocument<S> var3);

    default public void replaceText(IndexRange range, String text) {
        this.replaceText(range.getStart(), range.getEnd(), text);
    }

    default public void replace(IndexRange range, StyledDocument<S> replacement) {
        this.replace(range.getStart(), range.getEnd(), replacement);
    }

    public void positionCaret(int var1);
}

