/*
 * Decompiled with CFR 0.152.
 */
package org.fxmisc.richtext;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.fxmisc.richtext.Codec;

interface SuperCodec<S, T extends S>
extends Codec<T> {
    public void encodeSuper(DataOutputStream var1, S var2) throws IOException;

    @Override
    default public void encode(DataOutputStream os, T t) throws IOException {
        this.encodeSuper(os, t);
    }

    public static <S, U extends S, T extends U> SuperCodec<S, U> upCast(SuperCodec<S, T> sc) {
        return sc;
    }

    public static <T> SuperCodec<Collection<T>, List<T>> collectionListCodec(final Codec<T> elemCodec) {
        return new SuperCodec<Collection<T>, List<T>>(){

            @Override
            public String getName() {
                return "list<" + elemCodec.getName() + ">";
            }

            @Override
            public void encodeSuper(DataOutputStream os, Collection<T> col) throws IOException {
                os.writeInt(col.size());
                for (Object t : col) {
                    elemCodec.encode(os, t);
                }
            }

            @Override
            public List<T> decode(DataInputStream is) throws IOException {
                int size = is.readInt();
                ArrayList elems = new ArrayList(size);
                for (int i = 0; i < size; ++i) {
                    Object t = elemCodec.decode(is);
                    elems.add(t);
                }
                return elems;
            }
        };
    }
}

