/*
 * Decompiled with CFR 0.152.
 */
package org.fxmisc.richtext;

import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.IntFunction;
import java.util.function.UnaryOperator;
import javafx.beans.Observable;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.css.CssMetaData;
import javafx.css.Styleable;
import javafx.css.StyleableObjectProperty;
import javafx.geometry.Insets;
import javafx.geometry.Point2D;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.control.IndexRange;
import javafx.scene.control.Skin;
import javafx.scene.layout.Background;
import javafx.scene.layout.BackgroundFill;
import javafx.scene.layout.CornerRadii;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.text.Font;
import javafx.stage.PopupWindow;
import org.fxmisc.richtext.ClipboardActions;
import org.fxmisc.richtext.Codec;
import org.fxmisc.richtext.CssProperties;
import org.fxmisc.richtext.EditActions;
import org.fxmisc.richtext.EditableStyledDocument;
import org.fxmisc.richtext.NavigationActions;
import org.fxmisc.richtext.Paragraph;
import org.fxmisc.richtext.PlainTextChange;
import org.fxmisc.richtext.PopupAlignment;
import org.fxmisc.richtext.ReadOnlyStyledDocument;
import org.fxmisc.richtext.RichTextChange;
import org.fxmisc.richtext.StyleSpans;
import org.fxmisc.richtext.StyledDocument;
import org.fxmisc.richtext.TextChange;
import org.fxmisc.richtext.TextEditingArea;
import org.fxmisc.richtext.TwoDimensional;
import org.fxmisc.richtext.UndoActions;
import org.fxmisc.richtext.skin.StyledTextAreaBehavior;
import org.fxmisc.richtext.skin.StyledTextAreaVisual;
import org.fxmisc.richtext.skin.TextExt;
import org.fxmisc.undo.UndoManager;
import org.fxmisc.undo.UndoManagerFactory;
import org.fxmisc.wellbehaved.skin.Skins;
import org.reactfx.EventStream;
import org.reactfx.Guard;
import org.reactfx.Suspendable;
import org.reactfx.SuspendableEventStream;
import org.reactfx.SuspendableNo;
import org.reactfx.collection.LiveList;
import org.reactfx.collection.SuspendableList;
import org.reactfx.value.SuspendableVal;
import org.reactfx.value.SuspendableVar;
import org.reactfx.value.Val;
import org.reactfx.value.Var;

public class StyledTextArea<S>
extends Control
implements TextEditingArea<S>,
EditActions<S>,
ClipboardActions<S>,
NavigationActions<S>,
UndoActions<S>,
TwoDimensional {
    public static final IndexRange EMPTY_RANGE = new IndexRange(0, 0);
    private final BooleanProperty editable = new CssProperties.EditableProperty<StyledTextArea>(this);
    private final BooleanProperty wrapText = new SimpleBooleanProperty((Object)this, "wrapText");
    private UndoManager undoManager;
    private final StyleableObjectProperty<Font> font = new CssProperties.FontProperty<StyledTextArea>(this);
    private final ObjectProperty<PopupWindow> popupWindow = new SimpleObjectProperty();
    private final ObjectProperty<Point2D> popupAnchorOffset = new SimpleObjectProperty();
    private final ObjectProperty<UnaryOperator<Point2D>> popupAnchorAdjustment = new SimpleObjectProperty();
    private final ObjectProperty<PopupAlignment> popupAlignment = new SimpleObjectProperty((Object)PopupAlignment.CARET_TOP);
    private final ObjectProperty<Duration> mouseOverTextDelay = new SimpleObjectProperty(null);
    private final ObjectProperty<IntFunction<? extends Node>> paragraphGraphicFactory = new SimpleObjectProperty(null);
    private Optional<Codec<S>> styleCodec = Optional.empty();
    private final SuspendableVal<String> text;
    private final SuspendableVal<Integer> length;
    private final Var<Integer> internalCaretPosition = Var.newSimpleVar(0);
    private final SuspendableVal<Integer> caretPosition = this.internalCaretPosition.suspendable();
    private final SuspendableVar<Integer> anchor = Var.newSimpleVar(0).suspendable();
    private final Var<IndexRange> internalSelection = Var.newSimpleVar(EMPTY_RANGE);
    private final SuspendableVal<IndexRange> selection = this.internalSelection.suspendable();
    private final SuspendableVal<String> selectedText;
    private final SuspendableVal<Integer> currentParagraph;
    private final SuspendableVal<Integer> caretColumn;
    private final SuspendableList<Paragraph<S>> paragraphs;
    private final SuspendableNo beingUpdated = new SuspendableNo();
    private final SuspendableEventStream<PlainTextChange> plainTextChanges;
    private final SuspendableEventStream<RichTextChange<S>> richTextChanges;
    private TwoDimensional.Position selectionStart2D;
    private TwoDimensional.Position selectionEnd2D;
    private final EditableStyledDocument<S> content;
    private final S initialStyle;
    private final BiConsumer<? super TextExt, S> applyStyle;
    private final boolean preserveStyle;
    private final Suspendable omniSuspendable;

    private static int clamp(int min, int val, int max) {
        return val < min ? min : (val > max ? max : val);
    }

    @Override
    public final boolean isEditable() {
        return this.editable.get();
    }

    @Override
    public final void setEditable(boolean value) {
        this.editable.set(value);
    }

    @Override
    public final BooleanProperty editableProperty() {
        return this.editable;
    }

    @Override
    public final boolean isWrapText() {
        return this.wrapText.get();
    }

    @Override
    public final void setWrapText(boolean value) {
        this.wrapText.set(value);
    }

    @Override
    public final BooleanProperty wrapTextProperty() {
        return this.wrapText;
    }

    @Override
    public UndoManager getUndoManager() {
        return this.undoManager;
    }

    @Override
    public void setUndoManager(UndoManagerFactory undoManagerFactory) {
        this.undoManager.close();
        this.undoManager = this.preserveStyle ? this.createRichUndoManager(undoManagerFactory) : this.createPlainUndoManager(undoManagerFactory);
    }

    public final StyleableObjectProperty<Font> fontProperty() {
        return this.font;
    }

    public final void setFont(Font value) {
        this.font.setValue((Object)value);
    }

    public final Font getFont() {
        return (Font)this.font.getValue();
    }

    public void setPopupWindow(PopupWindow popup) {
        this.popupWindow.set((Object)popup);
    }

    public PopupWindow getPopupWindow() {
        return (PopupWindow)this.popupWindow.get();
    }

    public ObjectProperty<PopupWindow> popupWindowProperty() {
        return this.popupWindow;
    }

    @Deprecated
    public void setPopupAtCaret(PopupWindow popup) {
        this.popupWindow.set((Object)popup);
    }

    @Deprecated
    public PopupWindow getPopupAtCaret() {
        return (PopupWindow)this.popupWindow.get();
    }

    @Deprecated
    public ObjectProperty<PopupWindow> popupAtCaretProperty() {
        return this.popupWindow;
    }

    public void setPopupAnchorOffset(Point2D offset) {
        this.popupAnchorOffset.set((Object)offset);
    }

    public Point2D getPopupAnchorOffset() {
        return (Point2D)this.popupAnchorOffset.get();
    }

    public ObjectProperty<Point2D> popupAnchorOffsetProperty() {
        return this.popupAnchorOffset;
    }

    public void setPopupAnchorAdjustment(UnaryOperator<Point2D> f) {
        this.popupAnchorAdjustment.set(f);
    }

    public UnaryOperator<Point2D> getPopupAnchorAdjustment() {
        return (UnaryOperator)this.popupAnchorAdjustment.get();
    }

    public ObjectProperty<UnaryOperator<Point2D>> popupAnchorAdjustmentProperty() {
        return this.popupAnchorAdjustment;
    }

    public void setPopupAlignment(PopupAlignment pos) {
        this.popupAlignment.set((Object)pos);
    }

    public PopupAlignment getPopupAlignment() {
        return (PopupAlignment)((Object)this.popupAlignment.get());
    }

    public ObjectProperty<PopupAlignment> popupAlignmentProperty() {
        return this.popupAlignment;
    }

    public void setMouseOverTextDelay(Duration delay) {
        this.mouseOverTextDelay.set((Object)delay);
    }

    public Duration getMouseOverTextDelay() {
        return (Duration)this.mouseOverTextDelay.get();
    }

    public ObjectProperty<Duration> mouseOverTextDelayProperty() {
        return this.mouseOverTextDelay;
    }

    public void setParagraphGraphicFactory(IntFunction<? extends Node> factory) {
        this.paragraphGraphicFactory.set(factory);
    }

    public IntFunction<? extends Node> getParagraphGraphicFactory() {
        return (IntFunction)this.paragraphGraphicFactory.get();
    }

    public ObjectProperty<IntFunction<? extends Node>> paragraphGraphicFactoryProperty() {
        return this.paragraphGraphicFactory;
    }

    public void setUseInitialStyleForInsertion(boolean value) {
        this.content.useInitialStyleForInsertion.set(value);
    }

    public boolean getUseInitialStyleForInsertion() {
        return this.content.useInitialStyleForInsertion.get();
    }

    public BooleanProperty useInitialStyleForInsertionProperty() {
        return this.content.useInitialStyleForInsertion;
    }

    public void setStyleCodec(Codec<S> codec) {
        this.styleCodec = Optional.of(codec);
    }

    @Override
    public Optional<Codec<S>> getStyleCodec() {
        return this.styleCodec;
    }

    @Override
    public final String getText() {
        return (String)this.text.getValue();
    }

    @Override
    public final ObservableValue<String> textProperty() {
        return this.text;
    }

    @Override
    public final StyledDocument<S> getDocument() {
        return this.content.snapshot();
    }

    @Override
    public final int getLength() {
        return (Integer)this.length.getValue();
    }

    @Override
    public final ObservableValue<Integer> lengthProperty() {
        return this.length;
    }

    @Override
    public final int getCaretPosition() {
        return (Integer)this.caretPosition.getValue();
    }

    @Override
    public final ObservableValue<Integer> caretPositionProperty() {
        return this.caretPosition;
    }

    @Override
    public final int getAnchor() {
        return (Integer)this.anchor.getValue();
    }

    @Override
    public final ObservableValue<Integer> anchorProperty() {
        return this.anchor;
    }

    @Override
    public final IndexRange getSelection() {
        return (IndexRange)this.selection.getValue();
    }

    @Override
    public final ObservableValue<IndexRange> selectionProperty() {
        return this.selection;
    }

    @Override
    public final String getSelectedText() {
        return (String)this.selectedText.getValue();
    }

    @Override
    public final ObservableValue<String> selectedTextProperty() {
        return this.selectedText;
    }

    @Override
    public final int getCurrentParagraph() {
        return (Integer)this.currentParagraph.getValue();
    }

    @Override
    public final ObservableValue<Integer> currentParagraphProperty() {
        return this.currentParagraph;
    }

    @Override
    public final int getCaretColumn() {
        return (Integer)this.caretColumn.getValue();
    }

    @Override
    public final ObservableValue<Integer> caretColumnProperty() {
        return this.caretColumn;
    }

    @Override
    public ObservableList<Paragraph<S>> getParagraphs() {
        return this.paragraphs;
    }

    public ObservableBooleanValue beingUpdatedProperty() {
        return this.beingUpdated;
    }

    public boolean isBeingUpdated() {
        return this.beingUpdated.get();
    }

    @Override
    public final EventStream<PlainTextChange> plainTextChanges() {
        return this.plainTextChanges;
    }

    @Override
    public final EventStream<RichTextChange<S>> richChanges() {
        return this.richTextChanges;
    }

    public StyledTextArea(S initialStyle, BiConsumer<? super TextExt, S> applyStyle) {
        this(initialStyle, applyStyle, true);
    }

    public <C> StyledTextArea(S initialStyle, BiConsumer<? super TextExt, S> applyStyle, boolean preserveStyle) {
        this.initialStyle = initialStyle;
        this.applyStyle = applyStyle;
        this.preserveStyle = preserveStyle;
        this.content = new EditableStyledDocument<S>(initialStyle);
        this.paragraphs = LiveList.suspendable(this.content.getParagraphs());
        this.text = Val.suspendable(this.content.textProperty());
        this.length = Val.suspendable(this.content.lengthProperty());
        this.plainTextChanges = this.content.plainTextChanges().pausable();
        this.richTextChanges = this.content.richChanges().pausable();
        this.undoManager = preserveStyle ? this.createRichUndoManager(UndoManagerFactory.unlimitedHistoryFactory()) : this.createPlainUndoManager(UndoManagerFactory.unlimitedHistoryFactory());
        Val<TwoDimensional.Position> caretPosition2D = Val.create(() -> this.content.offsetToPosition((Integer)this.internalCaretPosition.getValue(), TwoDimensional.Bias.Forward), new Observable[]{this.internalCaretPosition, this.paragraphs});
        this.currentParagraph = caretPosition2D.map(TwoDimensional.Position::getMajor).suspendable();
        this.caretColumn = caretPosition2D.map(TwoDimensional.Position::getMinor).suspendable();
        this.selectionStart2D = this.position(0, 0);
        this.selectionEnd2D = this.position(0, 0);
        this.internalSelection.addListener(obs -> {
            IndexRange sel = (IndexRange)this.internalSelection.getValue();
            this.selectionStart2D = this.offsetToPosition(sel.getStart(), TwoDimensional.Bias.Forward);
            this.selectionEnd2D = sel.getLength() == 0 ? this.selectionStart2D : this.selectionStart2D.offsetBy(sel.getLength(), TwoDimensional.Bias.Backward);
        });
        this.selectedText = Val.create(() -> this.content.getText((IndexRange)this.internalSelection.getValue()), new Observable[]{this.internalSelection, this.content.getParagraphs()}).suspendable();
        this.omniSuspendable = Suspendable.combine(this.beingUpdated, this.text, this.length, this.caretPosition, this.anchor, this.selection, this.selectedText, this.currentParagraph, this.caretColumn, this.plainTextChanges, this.richTextChanges, this.paragraphs);
        this.setBackground(new Background(new BackgroundFill[]{new BackgroundFill((Paint)Color.WHITE, CornerRadii.EMPTY, Insets.EMPTY)}));
        this.getStyleClass().add((Object)"styled-text-area");
    }

    @Override
    public final String getText(int start, int end) {
        return this.content.getText(start, end);
    }

    @Override
    public String getText(int paragraph) {
        return ((Paragraph)this.paragraphs.get(paragraph)).toString();
    }

    public Paragraph<S> getParagraph(int index) {
        return (Paragraph)this.paragraphs.get(index);
    }

    @Override
    public StyledDocument<S> subDocument(int start, int end) {
        return this.content.subSequence(start, end);
    }

    @Override
    public StyledDocument<S> subDocument(int paragraphIndex) {
        return this.content.subDocument(paragraphIndex);
    }

    public IndexRange getParagraphSelection(int paragraph) {
        int startPar = this.selectionStart2D.getMajor();
        int endPar = this.selectionEnd2D.getMajor();
        if (paragraph < startPar || paragraph > endPar) {
            return EMPTY_RANGE;
        }
        int start = paragraph == startPar ? this.selectionStart2D.getMinor() : 0;
        int end = paragraph == endPar ? this.selectionEnd2D.getMinor() : ((Paragraph)this.paragraphs.get(paragraph)).length();
        this.getSelection();
        return new IndexRange(start, end);
    }

    public S getStyleOfChar(int index) {
        return this.content.getStyleOfChar(index);
    }

    public S getStyleAtPosition(int position) {
        return this.content.getStyleAtPosition(position);
    }

    public IndexRange getStyleRangeAtPosition(int position) {
        return this.content.getStyleRangeAtPosition(position);
    }

    public StyleSpans<S> getStyleSpans(int from, int to) {
        return this.content.getStyleSpans(from, to);
    }

    public StyleSpans<S> getStyleSpans(IndexRange range) {
        return this.getStyleSpans(range.getStart(), range.getEnd());
    }

    public S getStyleOfChar(int paragraph, int index) {
        return this.content.getStyleOfChar(paragraph, index);
    }

    public S getStyleAtPosition(int paragraph, int position) {
        return this.content.getStyleOfChar(paragraph, position);
    }

    public IndexRange getStyleRangeAtPosition(int paragraph, int position) {
        return this.content.getStyleRangeAtPosition(paragraph, position);
    }

    public StyleSpans<S> getStyleSpans(int paragraph) {
        return this.content.getStyleSpans(paragraph);
    }

    public StyleSpans<S> getStyleSpans(int paragraph, int from, int to) {
        return this.content.getStyleSpans(paragraph, from, to);
    }

    public StyleSpans<S> getStyleSpans(int paragraph, IndexRange range) {
        return this.getStyleSpans(paragraph, range.getStart(), range.getEnd());
    }

    @Override
    public TwoDimensional.Position position(int row, int col) {
        return this.content.position(row, col);
    }

    @Override
    public TwoDimensional.Position offsetToPosition(int charOffset, TwoDimensional.Bias bias) {
        return this.content.offsetToPosition(charOffset, bias);
    }

    public void setStyle(int from, int to, S style) {
        try (Guard g = this.omniSuspendable.suspend();){
            this.content.setStyle(from, to, style);
        }
    }

    public void setStyle(int paragraph, S style) {
        try (Guard g = this.omniSuspendable.suspend();){
            this.content.setStyle(paragraph, style);
        }
    }

    public void setStyle(int paragraph, int from, int to, S style) {
        try (Guard g = this.omniSuspendable.suspend();){
            this.content.setStyle(paragraph, from, to, style);
        }
    }

    public void setStyleSpans(int from, StyleSpans<? extends S> styleSpans) {
        try (Guard g = this.omniSuspendable.suspend();){
            this.content.setStyleSpans(from, styleSpans);
        }
    }

    public void setStyleSpans(int paragraph, int from, StyleSpans<? extends S> styleSpans) {
        try (Guard g = this.omniSuspendable.suspend();){
            this.content.setStyleSpans(paragraph, from, styleSpans);
        }
    }

    public void clearStyle(int from, int to) {
        this.setStyle(from, to, this.initialStyle);
    }

    public void clearStyle(int paragraph) {
        this.setStyle(paragraph, this.initialStyle);
    }

    public void clearStyle(int paragraph, int from, int to) {
        this.setStyle(paragraph, from, to, this.initialStyle);
    }

    @Override
    public void replaceText(int start, int end, String text) {
        ReadOnlyStyledDocument<S> doc = ReadOnlyStyledDocument.fromString(text, this.content.getStyleForInsertionAt(start));
        this.replace(start, end, doc);
    }

    @Override
    public void replace(int start, int end, StyledDocument<S> replacement) {
        try (Guard g = this.omniSuspendable.suspend();){
            start = StyledTextArea.clamp(0, start, this.getLength());
            end = StyledTextArea.clamp(0, end, this.getLength());
            this.content.replace(start, end, replacement);
            int newCaretPos = start + replacement.length();
            this.selectRange(newCaretPos, newCaretPos);
        }
    }

    @Override
    public void selectRange(int anchor, int caretPosition) {
        try (Guard g = this.suspend(this.caretPosition, this.currentParagraph, this.caretColumn, this.anchor, this.selection, this.selectedText);){
            this.internalCaretPosition.setValue(StyledTextArea.clamp(0, caretPosition, this.getLength()));
            this.anchor.setValue(StyledTextArea.clamp(0, anchor, this.getLength()));
            this.internalSelection.setValue(IndexRange.normalize((int)this.getAnchor(), (int)this.getCaretPosition()));
        }
    }

    @Override
    public void positionCaret(int pos) {
        try (Guard g = this.suspend(this.caretPosition, this.currentParagraph, this.caretColumn);){
            this.internalCaretPosition.setValue(pos);
        }
    }

    protected Skin<?> createDefaultSkin() {
        return Skins.createSimpleSkin(this, area -> new StyledTextAreaVisual<S>(area, this.applyStyle), StyledTextAreaBehavior::new);
    }

    public List<CssMetaData<? extends Styleable, ?>> getControlCssMetaData() {
        List superMetaData = super.getControlCssMetaData();
        List<CssMetaData> myMetaData = Arrays.asList(this.font.getCssMetaData());
        ArrayList res = new ArrayList(superMetaData.size() + myMetaData.size());
        res.addAll(superMetaData);
        res.addAll(myMetaData);
        return res;
    }

    private UndoManager createPlainUndoManager(UndoManagerFactory factory) {
        Consumer<PlainTextChange> apply = change -> this.replaceText(change.getPosition(), change.getPosition() + ((String)change.getRemoved()).length(), (String)change.getInserted());
        BiFunction<PlainTextChange, PlainTextChange, Optional> merge = (change1, change2) -> change1.mergeWith(change2);
        return factory.create(this.plainTextChanges(), TextChange::invert, apply, merge);
    }

    private UndoManager createRichUndoManager(UndoManagerFactory factory) {
        Consumer<RichTextChange> apply = change -> this.replace(change.getPosition(), change.getPosition() + ((StyledDocument)change.getRemoved()).length(), (StyledDocument)change.getInserted());
        BiFunction<RichTextChange, RichTextChange, Optional> merge = (change1, change2) -> change1.mergeWith(change2);
        return factory.create(this.richChanges(), TextChange::invert, apply, merge);
    }

    private Guard suspend(Suspendable ... suspendables) {
        return Suspendable.combine(this.beingUpdated, Suspendable.combine(suspendables)).suspend();
    }
}

