/*
 * Decompiled with CFR 0.152.
 */
package org.fxmisc.richtext;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javafx.scene.control.IndexRange;
import org.fxmisc.richtext.StyleSpan;
import org.fxmisc.richtext.StyleSpans;
import org.fxmisc.richtext.StyleSpansBuilder;
import org.fxmisc.richtext.StyledText;
import org.fxmisc.richtext.TwoDimensional;
import org.fxmisc.richtext.TwoLevelNavigator;

public final class Paragraph<S>
implements CharSequence {
    private final List<StyledText<S>> segments;
    private final TwoLevelNavigator navigator;
    private int length = -1;
    private String text = null;

    @SafeVarargs
    private static <T> List<T> list(T head, T ... tail) {
        if (tail.length == 0) {
            return Collections.singletonList(head);
        }
        ArrayList<T> list = new ArrayList<T>(1 + tail.length);
        list.add(head);
        for (T t : tail) {
            list.add(t);
        }
        return list;
    }

    public Paragraph(String text, S style) {
        this(new StyledText<S>(text, style));
    }

    @SafeVarargs
    public Paragraph(StyledText<S> text, StyledText<S> ... texts) {
        this(Paragraph.list(text, texts));
    }

    private Paragraph(StyledText<S> text) {
        this(Arrays.asList(text));
    }

    Paragraph(List<StyledText<S>> segments) {
        assert (!segments.isEmpty());
        this.segments = segments;
        this.navigator = new TwoLevelNavigator(() -> segments.size(), i -> ((StyledText)segments.get(i)).length());
    }

    public List<StyledText<S>> getSegments() {
        return Collections.unmodifiableList(this.segments);
    }

    @Override
    public int length() {
        if (this.length == -1) {
            this.length = this.segments.stream().mapToInt(s -> s.length()).sum();
        }
        return this.length;
    }

    @Override
    public char charAt(int index) {
        TwoDimensional.Position pos = this.navigator.offsetToPosition(index, TwoDimensional.Bias.Forward);
        return this.segments.get(pos.getMajor()).charAt(pos.getMinor());
    }

    public String substring(int from, int to) {
        return this.toString().substring(from, Math.min(to, this.length()));
    }

    public String substring(int from) {
        return this.toString().substring(from);
    }

    public Paragraph<S> concat(Paragraph<S> p) {
        if (this.length() == 0) {
            return p;
        }
        if (p.length() == 0) {
            return this;
        }
        StyledText<S> left = this.segments.get(this.segments.size() - 1);
        StyledText<S> right = p.segments.get(0);
        if (Objects.equals(left.getStyle(), right.getStyle())) {
            StyledText<S> segment = left.concat(right);
            ArrayList<StyledText<S>> segs = new ArrayList<StyledText<S>>(this.segments.size() + p.segments.size() - 1);
            segs.addAll(this.segments.subList(0, this.segments.size() - 1));
            segs.add(segment);
            segs.addAll(p.segments.subList(1, p.segments.size()));
            return new Paragraph<S>(segs);
        }
        ArrayList<StyledText<S>> segs = new ArrayList<StyledText<S>>(this.segments.size() + p.segments.size());
        segs.addAll(this.segments);
        segs.addAll(p.segments);
        return new Paragraph<S>(segs);
    }

    public Paragraph<S> concat(CharSequence str) {
        if (str.length() == 0) {
            return this;
        }
        ArrayList<StyledText<S>> segs = new ArrayList<StyledText<S>>(this.segments);
        int lastIdx = this.segments.size() - 1;
        segs.set(lastIdx, this.segments.get(lastIdx).concat(str));
        return new Paragraph<S>(segs);
    }

    public Paragraph<S> insert(int offset, CharSequence str) {
        if (offset < 0 || offset > this.length()) {
            throw new IndexOutOfBoundsException(String.valueOf(offset));
        }
        TwoDimensional.Position pos = this.navigator.offsetToPosition(offset, TwoDimensional.Bias.Backward);
        int segIdx = pos.getMajor();
        int segPos = pos.getMinor();
        StyledText<S> seg = this.segments.get(segIdx);
        StyledText<S> replacement = seg.spliced(segPos, segPos, str);
        ArrayList<StyledText<S>> segs = new ArrayList<StyledText<S>>(this.segments);
        segs.set(segIdx, replacement);
        return new Paragraph<S>(segs);
    }

    @Override
    public Paragraph<S> subSequence(int start, int end) {
        return this.trim(end).subSequence(start);
    }

    public Paragraph<S> trim(int length) {
        if (length >= this.length()) {
            return this;
        }
        TwoDimensional.Position pos = this.navigator.offsetToPosition(length, TwoDimensional.Bias.Backward);
        int segIdx = pos.getMajor();
        ArrayList<StyledText<S>> segs = new ArrayList<StyledText<S>>(segIdx + 1);
        segs.addAll(this.segments.subList(0, segIdx));
        segs.add((StyledText<S>)this.segments.get(segIdx).subSequence(0, pos.getMinor()));
        return new Paragraph<S>(segs);
    }

    public Paragraph<S> subSequence(int start) {
        if (start < 0) {
            throw new IllegalArgumentException("start must not be negative (was: " + start + ")");
        }
        if (start == 0) {
            return this;
        }
        if (start <= this.length()) {
            TwoDimensional.Position pos = this.navigator.offsetToPosition(start, TwoDimensional.Bias.Forward);
            int segIdx = pos.getMajor();
            ArrayList<StyledText<S>> segs = new ArrayList<StyledText<S>>(this.segments.size() - segIdx);
            segs.add(this.segments.get(segIdx).subSequence(pos.getMinor()));
            segs.addAll(this.segments.subList(segIdx + 1, this.segments.size()));
            return new Paragraph<S>(segs);
        }
        throw new IndexOutOfBoundsException(start + " not in [0, " + this.length() + "]");
    }

    public Paragraph<S> delete(int start, int end) {
        return this.trim(start).concat(this.subSequence(end));
    }

    public Paragraph<S> restyle(S style) {
        return new Paragraph<S>(this.toString(), style);
    }

    public Paragraph<S> restyle(int from, int to, S style) {
        if (from >= this.length()) {
            return this;
        }
        to = Math.min(to, this.length());
        CharSequence left = this.subSequence(0, from);
        Paragraph<S> middle = new Paragraph<S>(this.substring(from, to), style);
        Paragraph<S> right = this.subSequence(to);
        return ((Paragraph)left).concat(middle).concat(right);
    }

    public Paragraph<S> restyle(int from, StyleSpans<? extends S> styleSpans) {
        int len = styleSpans.length();
        if (styleSpans.equals(this.getStyleSpans(from, from + len))) {
            return this;
        }
        Paragraph<S> left = this.trim(from);
        Paragraph<S> right = this.subSequence(from + len);
        String middleString = this.substring(from, from + len);
        ArrayList<StyledText<S>> middleSegs = new ArrayList<StyledText<S>>(styleSpans.getSpanCount());
        int offset = 0;
        for (StyleSpan<S> span : styleSpans) {
            int end = offset + span.getLength();
            String text = middleString.substring(offset, end);
            middleSegs.add(new StyledText<S>(text, span.getStyle()));
            offset = end;
        }
        Paragraph<S> middle = new Paragraph<S>(middleSegs);
        return left.concat(middle).concat(right);
    }

    public S getStyleOfChar(int charIdx) {
        if (charIdx < 0) {
            return this.segments.get(0).getStyle();
        }
        TwoDimensional.Position pos = this.navigator.offsetToPosition(charIdx, TwoDimensional.Bias.Forward);
        return this.segments.get(pos.getMajor()).getStyle();
    }

    public S getStyleAtPosition(int position) {
        if (position < 0) {
            throw new IllegalArgumentException("Paragraph position cannot be negative (" + position + ")");
        }
        TwoDimensional.Position pos = this.navigator.offsetToPosition(position, TwoDimensional.Bias.Backward);
        return this.segments.get(pos.getMajor()).getStyle();
    }

    public IndexRange getStyleRangeAtPosition(int position) {
        TwoDimensional.Position pos = this.navigator.offsetToPosition(position, TwoDimensional.Bias.Backward);
        int start = position - pos.getMinor();
        int end = start + this.segments.get(pos.getMajor()).length();
        return new IndexRange(start, end);
    }

    public StyleSpans<S> getStyleSpans() {
        StyleSpansBuilder<S> builder = new StyleSpansBuilder<S>(this.segments.size());
        for (StyledText<S> seg : this.segments) {
            builder.add(seg.getStyle(), seg.length());
        }
        return builder.create();
    }

    public StyleSpans<S> getStyleSpans(int from, int to) {
        TwoDimensional.Position start = this.navigator.offsetToPosition(from, TwoDimensional.Bias.Forward);
        TwoDimensional.Position end = to == from ? start : start.offsetBy(to - from, TwoDimensional.Bias.Backward);
        int startSegIdx = start.getMajor();
        int endSegIdx = end.getMajor();
        int n = endSegIdx - startSegIdx + 1;
        StyleSpansBuilder<S> builder = new StyleSpansBuilder<S>(n);
        if (startSegIdx == endSegIdx) {
            StyledText<S> seg = this.segments.get(startSegIdx);
            builder.add(seg.getStyle(), to - from);
        } else {
            StyledText<S> startSeg = this.segments.get(startSegIdx);
            builder.add(startSeg.getStyle(), startSeg.length() - start.getMinor());
            for (int i = startSegIdx + 1; i < endSegIdx; ++i) {
                StyledText<S> seg = this.segments.get(i);
                builder.add(seg.getStyle(), seg.length());
            }
            StyledText<S> endSeg = this.segments.get(endSegIdx);
            builder.add(endSeg.getStyle(), end.getMinor());
        }
        return builder.create();
    }

    @Override
    public String toString() {
        if (this.text == null) {
            StringBuilder sb = new StringBuilder(this.length());
            for (StyledText<S> seg : this.segments) {
                sb.append(seg);
            }
            this.text = sb.toString();
        }
        return this.text;
    }

    public boolean equals(Object other) {
        if (other instanceof Paragraph) {
            Paragraph that = (Paragraph)other;
            return Objects.equals(this.segments, that.segments);
        }
        return false;
    }

    public int hashCode() {
        return this.segments.hashCode();
    }
}

