/*
 * Decompiled with CFR 0.152.
 */
package org.fxmisc.richtext;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.List;
import org.fxmisc.richtext.SuperCodec;

public interface Codec<T> {
    public static final Codec<String> STRING_CODEC = new Codec<String>(){

        @Override
        public String getName() {
            return "string";
        }

        @Override
        public void encode(DataOutputStream os, String s) throws IOException {
            os.writeUTF(s);
        }

        @Override
        public String decode(DataInputStream is) throws IOException {
            return is.readUTF();
        }
    };

    public String getName();

    public void encode(DataOutputStream var1, T var2) throws IOException;

    public T decode(DataInputStream var1) throws IOException;

    public static <T> Codec<List<T>> listCodec(Codec<T> elemCodec) {
        return SuperCodec.collectionListCodec(elemCodec);
    }
}

