/*
 * Decompiled with CFR 0.152.
 */
package org.fxmisc.flowless;

import java.util.Optional;
import java.util.function.Function;
import javafx.beans.property.ReadOnlyDoubleProperty;
import javafx.beans.property.ReadOnlyDoubleWrapper;
import javafx.beans.value.ObservableObjectValue;
import javafx.collections.ObservableList;
import javafx.geometry.Bounds;
import javafx.geometry.Orientation;
import javafx.scene.Node;
import javafx.scene.layout.Region;
import javafx.scene.shape.Rectangle;
import org.fxmisc.flowless.Cell;
import org.fxmisc.flowless.CellListManager;
import org.fxmisc.flowless.CellPositioner;
import org.fxmisc.flowless.EndOffEnd;
import org.fxmisc.flowless.MinDistanceTo;
import org.fxmisc.flowless.Navigator;
import org.fxmisc.flowless.OrientationHelper;
import org.fxmisc.flowless.SizeTracker;
import org.fxmisc.flowless.StartOffStart;
import org.fxmisc.flowless.VirtualFlow;
import org.fxmisc.flowless.VirtualFlowHit;
import org.reactfx.collection.MemoizationList;
import org.reactfx.util.Lists;
import org.reactfx.value.Val;
import org.reactfx.value.Var;

class VirtualFlowContent<T, C extends Cell<T, ?>>
extends Region {
    private final ObservableList<T> items;
    private final OrientationHelper orientation;
    private final CellListManager<T, C> cellListManager;
    private final SizeTracker sizeTracker;
    private final CellPositioner<T, C> cellPositioner;
    private final Navigator<T, C> navigator;
    private final ReadOnlyDoubleWrapper breadthOffset = new ReadOnlyDoubleWrapper(0.0);
    private final Val<Double> breadthPositionEstimate;
    private final Val<Double> lengthOffsetEstimate;
    private final Val<Double> lengthPositionEstimate;

    public ReadOnlyDoubleProperty breadthOffsetProperty() {
        return this.breadthOffset.getReadOnlyProperty();
    }

    public Val<Double> totalBreadthEstimateProperty() {
        return this.sizeTracker.maxCellBreadthProperty();
    }

    public Var<Double> breadthPositionEstimateProperty() {
        return this.breadthPositionEstimate.asVar(this::setBreadthPosition);
    }

    public Var<Double> lengthPositionEstimateProperty() {
        return this.lengthPositionEstimate.asVar(this::setLengthPosition);
    }

    VirtualFlowContent(ObservableList<T> items, Function<? super T, ? extends C> cellFactory, OrientationHelper orientation, VirtualFlow.Gravity gravity) {
        this.getStyleClass().add((Object)"virtual-flow-content");
        this.items = items;
        this.orientation = orientation;
        this.cellListManager = new CellListManager<T, C>(items, cellFactory);
        MemoizationList<C> cells = this.cellListManager.getLazyCellList();
        this.sizeTracker = new SizeTracker(orientation, (ObservableObjectValue<Bounds>)this.layoutBoundsProperty(), cells);
        this.cellPositioner = new CellPositioner<T, C>(this.cellListManager, orientation, this.sizeTracker);
        this.navigator = new Navigator<T, C>(this.cellListManager, this.cellPositioner, orientation, gravity, this.sizeTracker);
        this.getChildren().add(this.navigator);
        this.clipProperty().bind(Val.map(this.layoutBoundsProperty(), b -> new Rectangle(b.getWidth(), b.getHeight())));
        this.breadthPositionEstimate = Val.combine(this.breadthOffset, this.sizeTracker.viewportBreadthProperty(), this.sizeTracker.maxCellBreadthProperty(), (off, vpBr, totalBr) -> VirtualFlowContent.offsetToScrollbarPosition(off.doubleValue(), vpBr, totalBr));
        this.lengthOffsetEstimate = this.sizeTracker.lengthOffsetEstimateProperty();
        this.lengthPositionEstimate = Val.combine(this.lengthOffsetEstimate, this.sizeTracker.viewportLengthProperty(), this.sizeTracker.totalLengthEstimateProperty(), (off, vpLen, totalLen) -> VirtualFlowContent.offsetToScrollbarPosition(off, vpLen, totalLen)).orElseConst(0.0);
    }

    public void dispose() {
        this.navigator.dispose();
        this.sizeTracker.dispose();
        this.cellListManager.dispose();
    }

    public C getCellFor(int itemIndex) {
        Lists.checkIndex(itemIndex, this.items.size());
        return this.cellPositioner.getSizedCell(itemIndex);
    }

    public Optional<C> getCellIfVisible(int itemIndex) {
        return this.cellPositioner.getCellIfVisible(itemIndex);
    }

    public ObservableList<C> visibleCells() {
        return this.cellListManager.getLazyCellList().memoizedItems();
    }

    public Val<Double> totalLengthEstimateProperty() {
        return this.sizeTracker.totalLengthEstimateProperty();
    }

    protected void layoutChildren() {
        double oldLayoutBreadth;
        do {
            oldLayoutBreadth = this.sizeTracker.getCellLayoutBreadth();
            this.orientation.resize((Node)this.navigator, oldLayoutBreadth, this.sizeTracker.getViewportLength());
            this.navigator.layout();
        } while (oldLayoutBreadth != this.sizeTracker.getCellLayoutBreadth());
        this.orientation.relocate((Node)this.navigator, -this.breadthOffset.get(), 0.0);
    }

    protected final double computePrefWidth(double height) {
        switch (this.getContentBias()) {
            case HORIZONTAL: {
                return this.computePrefBreadth();
            }
            case VERTICAL: {
                return this.computePrefLength(height);
            }
        }
        throw new AssertionError((Object)"Unreachable code");
    }

    protected final double computePrefHeight(double width) {
        switch (this.getContentBias()) {
            case HORIZONTAL: {
                return this.computePrefLength(width);
            }
            case VERTICAL: {
                return this.computePrefBreadth();
            }
        }
        throw new AssertionError((Object)"Unreachable code");
    }

    private double computePrefBreadth() {
        return 100.0;
    }

    private double computePrefLength(double breadth) {
        return 100.0;
    }

    public final Orientation getContentBias() {
        return this.orientation.getContentBias();
    }

    void scrollLength(double deltaLength) {
        this.setLengthOffset((Double)this.lengthOffsetEstimate.getValue() + deltaLength);
    }

    void scrollBreadth(double deltaBreadth) {
        this.setBreadthOffset(this.breadthOffset.get() + deltaBreadth);
    }

    void scrollX(double deltaX) {
        this.orientation.scrollHorizontally(this, deltaX);
    }

    void scrollY(double deltaY) {
        this.orientation.scrollVertically(this, deltaY);
    }

    VirtualFlowHit<C> hit(double x, double y) {
        double bOff = this.orientation.getX(x, y);
        double lOff = this.orientation.getY(x, y);
        bOff += this.breadthOffset.get();
        if (this.items.isEmpty()) {
            return this.orientation.hitAfterCells(bOff, lOff);
        }
        this.layout();
        int firstVisible = this.cellPositioner.getFirstVisibleIndex().getAsInt();
        firstVisible = this.navigator.fillBackwardFrom0(firstVisible, lOff);
        C firstCell = this.cellPositioner.getVisibleCell(firstVisible);
        int lastVisible = this.cellPositioner.getLastVisibleIndex().getAsInt();
        lastVisible = this.navigator.fillForwardFrom0(lastVisible, lOff);
        C lastCell = this.cellPositioner.getVisibleCell(lastVisible);
        if (lOff < this.orientation.minY((Cell<?, ?>)firstCell)) {
            return this.orientation.hitBeforeCells(bOff, lOff - this.orientation.minY((Cell<?, ?>)firstCell));
        }
        if (lOff >= this.orientation.maxY((Cell<?, ?>)lastCell)) {
            return this.orientation.hitAfterCells(bOff, lOff - this.orientation.maxY((Cell<?, ?>)lastCell));
        }
        for (int i = firstVisible; i <= lastVisible; ++i) {
            C cell = this.cellPositioner.getVisibleCell(i);
            if (!(lOff < this.orientation.maxY((Cell<?, ?>)cell))) continue;
            return this.orientation.cellHit(i, cell, bOff, lOff - this.orientation.minY((Cell<?, ?>)cell));
        }
        throw new AssertionError((Object)"unreachable code");
    }

    void show(double viewportOffset) {
        if (viewportOffset < 0.0) {
            this.navigator.scrollTargetPositionBy(viewportOffset);
        } else if (viewportOffset > this.sizeTracker.getViewportLength()) {
            this.navigator.scrollTargetPositionBy(viewportOffset - this.sizeTracker.getViewportLength());
        }
    }

    void show(int itemIdx) {
        this.navigator.setTargetPosition(new MinDistanceTo(itemIdx));
    }

    void showAsFirst(int itemIdx) {
        this.navigator.setTargetPosition(new StartOffStart(itemIdx, 0.0));
    }

    void showAsLast(int itemIdx) {
        this.navigator.setTargetPosition(new EndOffEnd(itemIdx, 0.0));
    }

    void showAtOffset(int itemIdx, double offset) {
        this.navigator.setTargetPosition(new StartOffStart(itemIdx, offset));
    }

    void showRegion(int itemIndex, Bounds region) {
        this.navigator.showLengthRegion(itemIndex, this.orientation.minY(region), this.orientation.maxY(region));
        this.showBreadthRegion(this.orientation.minX(region), this.orientation.maxX(region));
    }

    private void showBreadthRegion(double fromX, double toX) {
        double bOff = this.breadthOffset.get();
        double spaceBefore = fromX - bOff;
        double spaceAfter = this.sizeTracker.getViewportBreadth() - toX + bOff;
        if (spaceBefore < 0.0 && spaceAfter > 0.0) {
            double shift = Math.min(-spaceBefore, spaceAfter);
            this.setBreadthOffset(bOff - shift);
        } else if (spaceAfter < 0.0 && spaceBefore > 0.0) {
            double shift = Math.max(spaceAfter, -spaceBefore);
            this.setBreadthOffset(bOff - shift);
        }
    }

    private void setLengthPosition(double pos) {
        this.setLengthOffset(this.lengthPositionToPixels(pos));
    }

    private void setBreadthPosition(double pos) {
        this.setBreadthOffset(this.breadthPositionToPixels(pos));
    }

    private void setLengthOffset(double pixels) {
        double diff;
        double total = this.totalLengthEstimateProperty().getOrElse(0.0);
        double length = this.sizeTracker.getViewportLength();
        double max = Math.max(total - length, 0.0);
        double current = (Double)this.lengthOffsetEstimate.getValue();
        if (pixels > max) {
            pixels = max;
        }
        if (pixels < 0.0) {
            pixels = 0.0;
        }
        if ((diff = pixels - current) != 0.0) {
            if (Math.abs(diff) < length) {
                this.navigator.scrollTargetPositionBy(diff);
            } else {
                this.jumpToAbsolutePosition(pixels);
            }
        }
    }

    private void setBreadthOffset(double pixels) {
        double total = (Double)this.totalBreadthEstimateProperty().getValue();
        double breadth = this.sizeTracker.getViewportBreadth();
        double max = Math.max(total - breadth, 0.0);
        double current = this.breadthOffset.get();
        if (pixels > max) {
            pixels = max;
        }
        if (pixels < 0.0) {
            pixels = 0.0;
        }
        if (pixels != current) {
            this.breadthOffset.set(pixels);
            this.requestLayout();
        }
    }

    private void jumpToAbsolutePosition(double pixels) {
        if (this.items.isEmpty()) {
            return;
        }
        double avgLen = this.sizeTracker.getAverageLengthEstimate().orElse(0.0);
        if (avgLen == 0.0) {
            return;
        }
        int first = (int)Math.floor(pixels / avgLen);
        double firstOffset = -(pixels % avgLen);
        if (first < this.items.size()) {
            this.navigator.setTargetPosition(new StartOffStart(first, firstOffset));
        } else {
            this.navigator.setTargetPosition(new EndOffEnd(this.items.size() - 1, 0.0));
        }
    }

    private double lengthPositionToPixels(double pos) {
        double total = this.totalLengthEstimateProperty().getOrElse(0.0);
        double length = this.sizeTracker.getViewportLength();
        return VirtualFlowContent.scrollbarPositionToOffset(pos, length, total);
    }

    private double breadthPositionToPixels(double pos) {
        double total = (Double)this.totalBreadthEstimateProperty().getValue();
        double breadth = this.sizeTracker.getViewportBreadth();
        return VirtualFlowContent.scrollbarPositionToOffset(pos, breadth, total);
    }

    private static double offsetToScrollbarPosition(double contentOffset, double viewportSize, double contentSize) {
        return contentSize > viewportSize ? contentOffset / (contentSize - viewportSize) * contentSize : 0.0;
    }

    private static double scrollbarPositionToOffset(double scrollbarPos, double viewportSize, double contentSize) {
        return contentSize > viewportSize ? scrollbarPos / contentSize * (contentSize - viewportSize) : 0.0;
    }
}

