/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.usb;

import org.eclipse.kura.usb.UsbDevice;

public abstract class AbstractUsbDevice
implements UsbDevice {
    private String m_vendorId;
    private String m_productId;
    private String m_manufacturerName;
    private String m_productName;
    private String m_usbBusNumber;
    private String m_usbDevicePath;

    public AbstractUsbDevice(String vendorId, String productId, String manufacturerName, String productName, String usbBusNumber, String usbDevicePath) {
        this.m_vendorId = vendorId;
        this.m_productId = productId;
        this.m_manufacturerName = manufacturerName;
        this.m_productName = productName;
        this.m_usbBusNumber = usbBusNumber;
        this.m_usbDevicePath = usbDevicePath;
    }

    public AbstractUsbDevice(AbstractUsbDevice usbDevice) {
        this.m_vendorId = usbDevice.getVendorId();
        this.m_productId = usbDevice.getProductId();
        this.m_manufacturerName = usbDevice.getManufacturerName();
        this.m_productName = usbDevice.getProductName();
        this.m_usbBusNumber = usbDevice.getUsbBusNumber();
        this.m_usbDevicePath = usbDevice.getUsbDevicePath();
    }

    @Override
    public String getVendorId() {
        return this.m_vendorId;
    }

    @Override
    public String getProductId() {
        return this.m_productId;
    }

    @Override
    public String getManufacturerName() {
        return this.m_manufacturerName;
    }

    @Override
    public String getProductName() {
        return this.m_productName;
    }

    @Override
    public String getUsbBusNumber() {
        return this.m_usbBusNumber;
    }

    @Override
    public String getUsbDevicePath() {
        return this.m_usbDevicePath;
    }

    @Override
    public String getUsbPort() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.m_usbBusNumber).append("-").append(this.m_usbDevicePath);
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.m_manufacturerName == null ? 0 : this.m_manufacturerName.hashCode());
        result = 31 * result + (this.m_productId == null ? 0 : this.m_productId.hashCode());
        result = 31 * result + (this.m_productName == null ? 0 : this.m_productName.hashCode());
        result = 31 * result + (this.m_usbBusNumber == null ? 0 : this.m_usbBusNumber.hashCode());
        result = 31 * result + (this.m_usbDevicePath == null ? 0 : this.m_usbDevicePath.hashCode());
        result = 31 * result + (this.m_vendorId == null ? 0 : this.m_vendorId.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AbstractUsbDevice other = (AbstractUsbDevice)obj;
        if (this.m_manufacturerName == null ? other.m_manufacturerName != null : !this.m_manufacturerName.equals(other.m_manufacturerName)) {
            return false;
        }
        if (this.m_productId == null ? other.m_productId != null : !this.m_productId.equals(other.m_productId)) {
            return false;
        }
        if (this.m_productName == null ? other.m_productName != null : !this.m_productName.equals(other.m_productName)) {
            return false;
        }
        if (this.m_usbBusNumber == null ? other.m_usbBusNumber != null : !this.m_usbBusNumber.equals(other.m_usbBusNumber)) {
            return false;
        }
        if (this.m_usbDevicePath == null ? other.m_usbDevicePath != null : !this.m_usbDevicePath.equals(other.m_usbDevicePath)) {
            return false;
        }
        return !(this.m_vendorId == null ? other.m_vendorId != null : !this.m_vendorId.equals(other.m_vendorId));
    }
}

