/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.net.route;

import org.eclipse.kura.net.IP4Address;
import org.eclipse.kura.net.IPAddress;
import org.eclipse.kura.net.route.RouteConfig;
import org.eclipse.kura.net.route.RouteConfig4;
import org.eclipse.kura.net.route.RouteConfigIP;

public class RouteConfigIP4
extends RouteConfigIP<IP4Address>
implements RouteConfig4 {
    public RouteConfigIP4(IP4Address destination, IP4Address gateway, IP4Address netmask, String interfaceName, int metric) {
        super(destination, gateway, netmask, interfaceName, metric);
    }

    @Override
    public boolean equals(RouteConfig route) {
        if (!this.compareHostAddress((IPAddress)this.getDestination(), route.getDestination())) {
            return false;
        }
        if (!this.compareHostAddress((IPAddress)this.getGateway(), route.getGateway())) {
            return false;
        }
        if (!this.compareHostAddress((IPAddress)this.getNetmask(), route.getNetmask())) {
            return false;
        }
        if (!this.getInterfaceName().equals(route.getInterfaceName())) {
            return false;
        }
        return this.getMetric() == route.getMetric();
    }

    private boolean compareHostAddress(IPAddress adr1, IPAddress adr2) {
        String host1 = adr1 == null || adr1.getHostAddress() == null ? "" : adr1.getHostAddress();
        String host2 = adr2 == null || adr2.getHostAddress() == null ? "" : adr2.getHostAddress();
        return host1.equals(host2);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("destination: ").append(this.getDestination() != null ? ((IP4Address)this.getDestination()).getHostAddress() : "null").append(", gateway: ").append(this.getGateway() != null ? ((IP4Address)this.getGateway()).getHostAddress() : "null").append(", netmask: ").append(this.getNetmask() != null ? ((IP4Address)this.getNetmask()).getHostAddress() : "null").append(", interfaceName: ").append(this.getInterfaceName()).append(", metric: ").append(this.getMetric());
        return sb.toString();
    }
}

