/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.net.route;

import org.eclipse.kura.net.IPAddress;
import org.eclipse.kura.net.route.RouteConfig;

public abstract class RouteConfigIP<T extends IPAddress>
implements RouteConfig {
    private T m_destination;
    private T m_gateway;
    private T m_netmask;
    private String m_interfaceName;
    private int m_metric;

    public RouteConfigIP(T destination, T gateway, T netmask, String interfaceName, int metric) {
        this.m_destination = destination;
        this.m_gateway = gateway;
        this.m_netmask = netmask;
        this.m_interfaceName = interfaceName;
        this.m_metric = metric;
    }

    @Override
    public String getDescription() {
        StringBuffer desc = new StringBuffer();
        String gw = this.m_gateway == null ? "default" : ((IPAddress)this.m_gateway).getHostAddress();
        desc.append("Destination: " + ((IPAddress)this.m_destination).getHostAddress() + ", " + "Gateway: " + gw + ", " + "Netmask: " + ((IPAddress)this.m_netmask).getHostAddress() + ", " + "Interface: " + this.m_interfaceName + ", " + "Metric: " + this.m_metric);
        return desc.toString();
    }

    public T getDestination() {
        return this.m_destination;
    }

    public void setDestination(T destination) {
        this.m_destination = destination;
    }

    public T getGateway() {
        return this.m_gateway;
    }

    public void setGateway(T gateway) {
        this.m_gateway = gateway;
    }

    public T getNetmask() {
        return this.m_netmask;
    }

    public void setNetmask(T netmask) {
        this.m_netmask = netmask;
    }

    @Override
    public String getInterfaceName() {
        return this.m_interfaceName;
    }

    public void setInterfaceName(String interfaceName) {
        this.m_interfaceName = interfaceName;
    }

    @Override
    public int getMetric() {
        return this.m_metric;
    }

    public void setMetric(int metric) {
        this.m_metric = metric;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.m_destination == null ? 0 : ((IPAddress)this.m_destination).hashCode());
        result = 31 * result + (this.m_gateway == null ? 0 : ((IPAddress)this.m_gateway).hashCode());
        result = 31 * result + (this.m_interfaceName == null ? 0 : this.m_interfaceName.hashCode());
        result = 31 * result + this.m_metric;
        result = 31 * result + (this.m_netmask == null ? 0 : ((IPAddress)this.m_netmask).hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RouteConfigIP other = (RouteConfigIP)obj;
        if (this.m_destination == null ? other.m_destination != null : !((IPAddress)this.m_destination).equals(other.m_destination)) {
            return false;
        }
        if (this.m_gateway == null ? other.m_gateway != null : !((IPAddress)this.m_gateway).equals(other.m_gateway)) {
            return false;
        }
        if (this.m_interfaceName == null ? other.m_interfaceName != null : !this.m_interfaceName.equals(other.m_interfaceName)) {
            return false;
        }
        if (this.m_metric != other.m_metric) {
            return false;
        }
        return !(this.m_netmask == null ? other.m_netmask != null : !((IPAddress)this.m_netmask).equals(other.m_netmask));
    }

    @Override
    public boolean isValid() {
        return this.m_destination != null && this.m_gateway != null && this.m_netmask != null && this.m_interfaceName != null;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("RouteConfigIP [m_destination=");
        builder.append(this.m_destination);
        builder.append(", m_gateway=");
        builder.append(this.m_gateway);
        builder.append(", m_netmask=");
        builder.append(this.m_netmask);
        builder.append(", m_interfaceName=");
        builder.append(this.m_interfaceName);
        builder.append(", m_metric=");
        builder.append(this.m_metric);
        builder.append("]");
        return builder.toString();
    }
}

