/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.net.modem;

import org.eclipse.kura.net.IPAddress;
import org.eclipse.kura.net.NetConfig;

public class ModemConfig
implements NetConfig {
    private boolean m_enabled = false;
    private String m_dialString = "";
    private int m_pppNumber = 0;
    private int m_profileID = 0;
    private PdpType m_pdpType = PdpType.IP;
    private AuthType m_authType = AuthType.NONE;
    private String m_apn = "";
    private String m_username = "";
    private String m_password = "";
    private boolean m_persist = false;
    private int m_maxFail = 0;
    private int m_idle = 0;
    private String m_activeFilter = "";
    private int m_lcpEchoInterval = 0;
    private int m_lcpEchoFailure = 0;
    private IPAddress m_ipAddress = null;
    private int m_dataCompression = 0;
    private int m_headerCompression = 0;
    private boolean m_gpsEnabled = false;
    private int m_resetTimeout = 0;

    public ModemConfig() {
    }

    public ModemConfig(int profileID, PdpType pdpType, String apn, IPAddress ipAddress, int dataCompression, int headerCompresion) {
        this.m_profileID = profileID;
        this.m_pdpType = pdpType;
        this.m_apn = apn;
        this.m_ipAddress = ipAddress;
        this.m_dataCompression = dataCompression;
        this.m_headerCompression = headerCompresion;
    }

    public boolean isEnabled() {
        return this.m_enabled;
    }

    public void setEnabled(boolean enabled) {
        this.m_enabled = enabled;
    }

    public String getDialString() {
        return this.m_dialString;
    }

    public void setDialString(String dialString) {
        this.m_dialString = dialString;
    }

    public AuthType getAuthType() {
        return this.m_authType;
    }

    public void setAuthType(AuthType authType) {
        this.m_authType = authType;
    }

    public String getUsername() {
        return this.m_username;
    }

    public void setUsername(String username) {
        this.m_username = username;
    }

    public String getPassword() {
        return this.m_password;
    }

    public void setPassword(String password) {
        this.m_password = password;
    }

    public boolean isPersist() {
        return this.m_persist;
    }

    public void setPersist(boolean persist) {
        this.m_persist = persist;
    }

    public int getMaxFail() {
        return this.m_maxFail;
    }

    public void setMaxFail(int maxFail) {
        this.m_maxFail = maxFail;
    }

    public int getIdle() {
        return this.m_idle;
    }

    public void setIdle(int idle) {
        this.m_idle = idle;
    }

    public String getActiveFilter() {
        return this.m_activeFilter;
    }

    public void setActiveFilter(String activeFilter) {
        this.m_activeFilter = activeFilter;
    }

    public int getLcpEchoInterval() {
        return this.m_lcpEchoInterval;
    }

    public void setLcpEchoInterval(int lcpEchoInterval) {
        this.m_lcpEchoInterval = lcpEchoInterval;
    }

    public int getLcpEchoFailure() {
        return this.m_lcpEchoFailure;
    }

    public void setLcpEchoFailure(int lcpEchoFailure) {
        this.m_lcpEchoFailure = lcpEchoFailure;
    }

    public int getPppNumber() {
        return this.m_pppNumber;
    }

    public void setPppNumber(int pppNumber) {
        this.m_pppNumber = pppNumber;
    }

    public int getProfileID() {
        return this.m_profileID;
    }

    public void setProfileID(int id) {
        this.m_profileID = id;
    }

    public PdpType getPdpType() {
        return this.m_pdpType;
    }

    public void setPdpType(PdpType pdpType) {
        this.m_pdpType = pdpType;
    }

    public String getApn() {
        return this.m_apn;
    }

    public void setApn(String apn) {
        this.m_apn = apn;
    }

    public IPAddress getIpAddress() {
        return this.m_ipAddress;
    }

    public void setIpAddress(IPAddress address) {
        this.m_ipAddress = address;
    }

    public int getDataCompression() {
        return this.m_dataCompression;
    }

    public void setDataCompression(int dataCompression) {
        this.m_dataCompression = dataCompression;
    }

    public int getHeaderCompression() {
        return this.m_headerCompression;
    }

    public void setHeaderCompression(int headerCompression) {
        this.m_headerCompression = headerCompression;
    }

    public boolean isDataCompression() {
        return this.m_dataCompression != 0;
    }

    public boolean isHeaderCompression() {
        return this.m_headerCompression != 0;
    }

    public boolean isGpsEnabled() {
        return this.m_gpsEnabled;
    }

    public int getResetTimeout() {
        return this.m_resetTimeout;
    }

    public void setResetTimeout(int tout) {
        this.m_resetTimeout = tout;
    }

    public void setGpsEnabled(boolean gpsEnabled) {
        this.m_gpsEnabled = gpsEnabled;
    }

    public int hashCode() {
        int result = super.hashCode();
        result = 59 * result + this.m_profileID;
        result = 59 * result + (this.m_pdpType == null ? 0 : this.m_pdpType.hashCode());
        result = 59 * result + (this.m_authType == null ? 0 : this.m_authType.hashCode());
        result = 59 * result + (this.m_apn == null ? 0 : this.m_apn.hashCode());
        result = 59 * result + (this.m_username == null ? 0 : this.m_username.hashCode());
        result = 59 * result + (this.m_password == null ? 0 : this.m_password.hashCode());
        result = 59 * result + (this.m_ipAddress == null ? 0 : this.m_ipAddress.hashCode());
        result = 59 * result + this.m_pppNumber;
        result = 59 * result + this.m_maxFail;
        result = 59 * result + this.m_resetTimeout;
        result = 59 * result + this.m_idle;
        result = 59 * result + (this.m_activeFilter == null ? 0 : this.m_activeFilter.hashCode());
        result = 59 * result + this.m_lcpEchoFailure;
        result = 59 * result + this.m_lcpEchoInterval;
        result = 59 * result + this.m_dataCompression;
        result = 59 * result + this.m_headerCompression;
        result = 59 * result + (this.m_persist ? 1 : 0);
        result = 59 * result + (this.m_gpsEnabled ? 1 : 0);
        return result;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ModemConfig)) {
            return false;
        }
        ModemConfig otherConfig = (ModemConfig)obj;
        if (this.m_enabled != otherConfig.isEnabled()) {
            return false;
        }
        if (this.m_pppNumber != otherConfig.getPppNumber()) {
            return false;
        }
        if (this.m_persist != otherConfig.isPersist()) {
            return false;
        }
        if (this.m_maxFail != otherConfig.getMaxFail()) {
            return false;
        }
        if (this.m_resetTimeout != otherConfig.getResetTimeout()) {
            return false;
        }
        if (this.m_idle != otherConfig.getIdle()) {
            return false;
        }
        if (this.m_lcpEchoInterval != otherConfig.getLcpEchoInterval()) {
            return false;
        }
        if (this.m_lcpEchoFailure != otherConfig.getLcpEchoFailure()) {
            return false;
        }
        if (this.m_profileID != otherConfig.getProfileID()) {
            return false;
        }
        if (this.m_pdpType != otherConfig.getPdpType()) {
            return false;
        }
        if (this.m_authType != otherConfig.getAuthType()) {
            return false;
        }
        if (this.m_dataCompression != otherConfig.getDataCompression()) {
            return false;
        }
        if (this.m_headerCompression != otherConfig.getHeaderCompression()) {
            return false;
        }
        if (this.m_gpsEnabled != otherConfig.isGpsEnabled()) {
            return false;
        }
        if (this.m_dialString != null ? !this.m_dialString.equals(otherConfig.getDialString()) : otherConfig.getDialString() != null) {
            return false;
        }
        if (this.m_apn != null ? !this.m_apn.equals(otherConfig.getApn()) : otherConfig.getApn() != null) {
            return false;
        }
        if (this.m_username != null && this.m_username.length() > 0 ? !this.m_username.equals(otherConfig.getUsername()) : otherConfig.getUsername() != null && otherConfig.getUsername().length() > 0) {
            return false;
        }
        if (this.m_password != null && this.m_password.length() > 0 ? !this.m_password.equals(otherConfig.getPassword()) : otherConfig.getPassword() != null && otherConfig.getPassword().length() > 0) {
            return false;
        }
        if (this.m_activeFilter != null && this.m_activeFilter.length() > 0 ? !this.m_activeFilter.equals(otherConfig.getActiveFilter()) : otherConfig.getActiveFilter() != null && otherConfig.getActiveFilter().length() > 0) {
            return false;
        }
        return !(this.m_ipAddress != null ? !this.m_ipAddress.equals(otherConfig) : otherConfig.getIpAddress() != null);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(super.toString());
        sb.append("ModemConfig - ");
        sb.append("Enabled: ").append(this.m_enabled);
        sb.append(" - PPP Number: ").append(this.m_pppNumber);
        sb.append(" - Dial String: ").append(this.m_dialString);
        sb.append(" - Profile ID: ").append(this.m_profileID);
        sb.append(" - PDP Type: ").append((Object)this.m_pdpType);
        sb.append(" - Auth Type: ").append((Object)this.m_authType);
        sb.append(" - APN: ").append(this.m_apn);
        sb.append(" - Username: ").append(this.m_username);
        sb.append(" - Password: ").append(this.m_password);
        sb.append(" - IP Address: ").append(this.m_ipAddress == null ? "null" : this.m_ipAddress.getHostAddress());
        sb.append(" - Data Compression: ").append(this.m_dataCompression);
        sb.append(" - Header Compression: ").append(this.m_headerCompression);
        return sb.toString();
    }

    @Override
    public boolean isValid() {
        return this.m_pppNumber >= 0;
    }

    public static enum AuthType {
        NONE,
        AUTO,
        PAP,
        CHAP;

    }

    public static enum PdpType {
        IP,
        PPP,
        IPv6,
        UNKNOWN;

    }
}

