/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.net.dhcp;

import java.util.List;
import org.eclipse.kura.net.IPAddress;
import org.eclipse.kura.net.dhcp.DhcpServerConfig;

public abstract class DhcpServerConfigIP<T extends IPAddress>
implements DhcpServerConfig {
    private String m_interfaceName;
    private boolean m_enabled;
    private T m_subnet;
    private T m_routerAddress;
    private T m_subnetMask;
    private int m_defaultLeaseTime;
    private int m_maximumLeaseTime;
    private short m_prefix;
    private T m_rangeStart;
    private T m_rangeEnd;
    private boolean m_passDns;
    private List<T> m_dnsServers;

    public DhcpServerConfigIP(String interfaceName, boolean enabled, T subnet, T routerAddress, T subnetMask, int defaultLeaseTime, int maximumLeaseTime, short prefix, T rangeStart, T rangeEnd, boolean passDns, List<T> dnsServers) {
        this.m_interfaceName = interfaceName;
        this.m_enabled = enabled;
        this.m_subnet = subnet;
        this.m_routerAddress = routerAddress;
        this.m_subnetMask = subnetMask;
        this.m_defaultLeaseTime = defaultLeaseTime;
        this.m_maximumLeaseTime = maximumLeaseTime;
        this.m_prefix = prefix;
        this.m_rangeStart = rangeStart;
        this.m_rangeEnd = rangeEnd;
        this.m_passDns = passDns;
        this.m_dnsServers = dnsServers;
    }

    @Override
    public String getInterfaceName() {
        return this.m_interfaceName;
    }

    public void setInterfaceName(String interfaceName) {
        this.m_interfaceName = interfaceName;
    }

    @Override
    public boolean isEnabled() {
        return this.m_enabled;
    }

    public void setEnabledRouterMode(boolean enabled) {
        this.m_enabled = enabled;
    }

    public T getSubnet() {
        return this.m_subnet;
    }

    public void setSubnet(T subnet) {
        this.m_subnet = subnet;
    }

    public T getRouterAddress() {
        return this.m_routerAddress;
    }

    public void setRouterAddress(T routerAddress) {
        this.m_routerAddress = routerAddress;
    }

    public T getSubnetMask() {
        return this.m_subnetMask;
    }

    public void setSubnetMask(T subnetMask) {
        this.m_subnetMask = subnetMask;
    }

    @Override
    public int getDefaultLeaseTime() {
        return this.m_defaultLeaseTime;
    }

    public void setDefaultLeaseTime(int defaultLeaseTime) {
        this.m_defaultLeaseTime = defaultLeaseTime;
    }

    @Override
    public int getMaximumLeaseTime() {
        return this.m_maximumLeaseTime;
    }

    public void setMaximumLeaseTime(int maximumLeaseTime) {
        this.m_maximumLeaseTime = maximumLeaseTime;
    }

    @Override
    public short getPrefix() {
        return this.m_prefix;
    }

    public void setPrefix(short prefix) {
        this.m_prefix = prefix;
    }

    public T getRangeStart() {
        return this.m_rangeStart;
    }

    public void setRangeStart(T m_rangeStart) {
        this.m_rangeStart = m_rangeStart;
    }

    public T getRangeEnd() {
        return this.m_rangeEnd;
    }

    public void setRangeEnd(T rangeEnd) {
        this.m_rangeEnd = rangeEnd;
    }

    @Override
    public boolean isPassDns() {
        return this.m_passDns;
    }

    public void setPassDns(boolean passDns) {
        this.m_passDns = passDns;
    }

    public List<T> getDnsServers() {
        return this.m_dnsServers;
    }

    public void setDnsServers(List<T> m_dnsServers) {
        this.m_dnsServers = m_dnsServers;
    }

    @Override
    public boolean isValid() {
        return true;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("# enabled? ").append(this.m_enabled).append("\n");
        sb.append("# prefix: ").append(this.m_prefix).append("\n");
        sb.append("# pass DNS? ").append(this.m_passDns).append("\n\n");
        sb.append("subnet " + ((IPAddress)this.m_subnet).getHostAddress() + " netmask " + ((IPAddress)this.m_subnetMask).getHostAddress() + " {\n");
        if (this.m_passDns && this.m_dnsServers != null && this.m_dnsServers.size() > 0) {
            sb.append("    option domain-name-servers ");
            int i = 0;
            while (i < this.m_dnsServers.size()) {
                if (this.m_dnsServers.get(i) != null) {
                    sb.append(((IPAddress)this.m_dnsServers.get(i)).getHostAddress());
                }
                if (i + 1 == this.m_dnsServers.size()) {
                    sb.append(";\n\n");
                } else {
                    sb.append(",");
                }
                ++i;
            }
        }
        if (this.m_interfaceName != null) {
            sb.append("    interface " + this.m_interfaceName + ";\n");
        }
        if (this.m_routerAddress != null) {
            sb.append("    option routers " + ((IPAddress)this.m_routerAddress).getHostAddress() + ";\n");
        }
        if (!this.m_passDns) {
            sb.append("    ddns-update-style none;\n");
            sb.append("    ddns-updates off;\n");
        }
        sb.append("    default-lease-time " + this.m_defaultLeaseTime + ";\n");
        if (this.m_maximumLeaseTime > -1) {
            sb.append("    max-lease-time " + this.m_maximumLeaseTime + ";\n");
        }
        sb.append("    pool {\n");
        sb.append("        range " + ((IPAddress)this.m_rangeStart).getHostAddress() + " " + ((IPAddress)this.m_rangeEnd).getHostAddress() + ";\n");
        sb.append("    }\n");
        sb.append("}\n");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DhcpServerConfigIP other = (DhcpServerConfigIP)obj;
        if (this.m_enabled != other.m_enabled) {
            return false;
        }
        if (this.m_interfaceName == null ? other.m_interfaceName != null : !this.m_interfaceName.equals(other.m_interfaceName)) {
            return false;
        }
        if (this.m_subnet == null ? other.m_subnet != null : !((IPAddress)this.m_subnet).equals(other.m_subnet)) {
            return false;
        }
        if (this.m_routerAddress == null ? other.m_routerAddress != null : !((IPAddress)this.m_routerAddress).equals(other.m_routerAddress)) {
            return false;
        }
        if (this.m_subnetMask == null ? other.m_subnetMask != null : !((IPAddress)this.m_subnetMask).equals(other.m_subnetMask)) {
            return false;
        }
        if (this.m_defaultLeaseTime != other.m_defaultLeaseTime) {
            return false;
        }
        if (this.m_maximumLeaseTime != other.m_maximumLeaseTime) {
            return false;
        }
        if (this.m_prefix != other.m_prefix) {
            return false;
        }
        if (this.m_rangeStart == null ? other.m_rangeStart != null : !((IPAddress)this.m_rangeStart).equals(other.m_rangeStart)) {
            return false;
        }
        if (this.m_rangeEnd == null ? other.m_rangeEnd != null : !((IPAddress)this.m_rangeEnd).equals(other.m_rangeEnd)) {
            return false;
        }
        if (this.m_passDns != other.m_passDns) {
            return false;
        }
        return !(this.m_dnsServers == null ? other.m_dnsServers != null : !this.m_dnsServers.equals(other.m_dnsServers));
    }
}

