/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.message;

public class KuraTopic {
    private String m_fullTopic;
    private String[] m_topicParts;
    private String m_prefix;
    private String m_accountName;
    private String m_deviceId;
    private String m_applicationId;
    private String m_applicationTopic;

    public KuraTopic(String fullTopic) {
        this.m_fullTopic = fullTopic;
        if (fullTopic.compareTo("#") == 0) {
            return;
        }
        this.m_topicParts = fullTopic.split("/");
        if (this.m_topicParts.length == 0) {
            return;
        }
        int index = 0;
        int offset = 0;
        if (this.m_topicParts[0].startsWith("$")) {
            this.m_prefix = this.m_topicParts[index];
            offset += this.m_prefix.length() + 1;
            ++index;
        }
        if (index < this.m_topicParts.length) {
            this.m_accountName = this.m_topicParts[index];
            offset += this.m_accountName.length() + 1;
            ++index;
        }
        if (index < this.m_topicParts.length) {
            this.m_deviceId = this.m_topicParts[index];
            offset += this.m_deviceId.length() + 1;
            ++index;
        }
        if (index < this.m_topicParts.length) {
            this.m_applicationId = this.m_topicParts[index];
            offset += this.m_applicationId.length() + 1;
            ++index;
        }
        if (offset < this.m_fullTopic.length()) {
            this.m_applicationTopic = this.m_fullTopic.substring(offset);
        }
    }

    public String getFullTopic() {
        return this.m_fullTopic;
    }

    public String[] getTopicParts() {
        return this.m_topicParts;
    }

    public String getPrefix() {
        return this.m_prefix;
    }

    public String getAccountName() {
        return this.m_accountName;
    }

    public String getDeviceId() {
        return this.m_deviceId;
    }

    public String getApplicationId() {
        return this.m_applicationId;
    }

    public String getApplicationTopic() {
        return this.m_applicationTopic;
    }
}

