/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.core.ssl;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.SecureRandom;
import java.security.UnrecoverableEntryException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import org.eclipse.kura.KuraException;
import org.eclipse.kura.configuration.ConfigurableComponent;
import org.eclipse.kura.configuration.ConfigurationService;
import org.eclipse.kura.configuration.Password;
import org.eclipse.kura.core.ssl.SSLSocketFactoryWrapper;
import org.eclipse.kura.core.ssl.SslManagerServiceOptions;
import org.eclipse.kura.core.ssl.SslServiceListeners;
import org.eclipse.kura.crypto.CryptoService;
import org.eclipse.kura.ssl.SslManagerService;
import org.eclipse.kura.ssl.SslServiceListener;
import org.eclipse.kura.system.SystemService;
import org.osgi.service.component.ComponentContext;
import org.osgi.util.tracker.ServiceTracker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SslManagerServiceImpl
implements SslManagerService,
ConfigurableComponent {
    private static final Logger s_logger = LoggerFactory.getLogger(SslManagerServiceImpl.class);
    private SslServiceListeners m_sslServiceListeners;
    private ComponentContext m_ctx;
    private Map<String, Object> m_properties;
    private SslManagerServiceOptions m_options;
    private CryptoService m_cryptoService;
    private ConfigurationService m_configurationService;
    private Timer m_timer;
    private boolean m_configurationDirty;
    private SSLSocketFactory m_sslSocketFactory;
    private SystemService m_systemService;

    public void setCryptoService(CryptoService cryptoService) {
        this.m_cryptoService = cryptoService;
    }

    public void unsetCryptoService(CryptoService cryptoService) {
        this.m_cryptoService = null;
    }

    public void setConfigurationService(ConfigurationService configurationService) {
        this.m_configurationService = configurationService;
    }

    public void unsetConfigurationService(ConfigurationService configurationService) {
        this.m_configurationService = null;
    }

    public void setSystemService(SystemService systemService) {
        this.m_systemService = systemService;
    }

    public void unsetSystemService(SystemService systemService) {
        this.m_systemService = null;
    }

    protected void activate(ComponentContext componentContext, Map<String, Object> properties) {
        s_logger.info("activate...");
        this.m_ctx = componentContext;
        this.m_properties = properties;
        this.m_options = new SslManagerServiceOptions(properties);
        ServiceTracker listenersTracker = new ServiceTracker(componentContext.getBundleContext(), SslServiceListener.class, null);
        this.m_sslServiceListeners = new SslServiceListeners((ServiceTracker<SslServiceListener, SslServiceListener>)listenersTracker);
        if (!this.changeDefaultKeystorePassword()) {
            this.changeKeystorePassword();
        }
    }

    public void updated(Map<String, Object> properties) {
        s_logger.info("updated...");
        this.m_properties = properties;
        this.m_options = new SslManagerServiceOptions(properties);
        this.changeKeystorePassword();
        this.m_configurationDirty = true;
        this.m_sslServiceListeners.onConfigurationUpdated();
    }

    protected void deactivate(ComponentContext componentContext) {
        s_logger.info("deactivate...");
        this.m_timer.cancel();
        this.m_sslServiceListeners.close();
    }

    @Override
    public SSLSocketFactory getSSLSocketFactory() throws GeneralSecurityException, IOException {
        return this.getSSLSocketFactory(null);
    }

    @Override
    public SSLSocketFactory getSSLSocketFactory(String keyAlias) throws GeneralSecurityException, IOException {
        String protocol = this.m_options.getSslProtocol();
        String ciphers = this.m_options.getSslCiphers();
        String trustStore = this.m_options.getSslKeyStore();
        char[] keyStorePassword = this.getKeyStorePassword();
        boolean hostnameVerifcation = this.m_options.isSslHostnameVerification();
        return this.getSSLSocketFactory(protocol, ciphers, trustStore, trustStore, keyStorePassword, keyAlias, hostnameVerifcation);
    }

    @Override
    public SSLSocketFactory getSSLSocketFactory(String protocol, String ciphers, String trustStore, String keyStore, char[] keyStorePassword, String keyAlias) throws GeneralSecurityException, IOException {
        return this.getSSLSocketFactory(protocol, ciphers, trustStore, keyStore, keyStorePassword, keyAlias, true);
    }

    @Override
    public SSLSocketFactory getSSLSocketFactory(String protocol, String ciphers, String trustStore, String keyStore, char[] keyStorePassword, String keyAlias, boolean hostnameVerification) throws GeneralSecurityException, IOException {
        if (this.m_sslSocketFactory == null || this.m_configurationDirty) {
            s_logger.info("Creating a new SSLSocketFactory instance");
            TrustManager[] tms = SslManagerServiceImpl.getTrustManagers(trustStore);
            if (tms == null) {
                throw new GeneralSecurityException("SSL keystore tampered!");
            }
            KeyManager[] kms = this.getKeyManagers(keyStore, keyStorePassword, keyAlias);
            this.m_sslSocketFactory = SslManagerServiceImpl.createSSLSocketFactory(protocol, ciphers, kms, tms, hostnameVerification);
            this.m_configurationDirty = false;
        }
        return this.m_sslSocketFactory;
    }

    @Override
    public X509Certificate[] getTrustCertificates() throws GeneralSecurityException, IOException {
        TrustManager[] tms;
        X509Certificate[] cacerts = null;
        String trustStore = this.m_options.getSslKeyStore();
        TrustManager[] trustManagerArray = tms = SslManagerServiceImpl.getTrustManagers(trustStore);
        int n = tms.length;
        int n2 = 0;
        while (n2 < n) {
            TrustManager tm = trustManagerArray[n2];
            if (tm instanceof X509TrustManager) {
                X509TrustManager x509tm = (X509TrustManager)tm;
                cacerts = x509tm.getAcceptedIssuers();
                break;
            }
            ++n2;
        }
        return cacerts;
    }

    @Override
    public void installTrustCertificate(String alias, X509Certificate x509crt) throws GeneralSecurityException, IOException {
        FileInputStream tsReadStream = null;
        FileOutputStream tsOutStream = null;
        try {
            String trustStore = this.m_options.getSslKeyStore();
            KeyStore ts = KeyStore.getInstance(KeyStore.getDefaultType());
            File fTrustStore = new File(trustStore);
            char[] trustStorePassword = this.getKeyStorePassword();
            if (fTrustStore.exists()) {
                tsReadStream = new FileInputStream(trustStore);
                ts.load(tsReadStream, trustStorePassword);
            } else {
                ts.load(null, null);
            }
            ts.setCertificateEntry(alias, x509crt);
            tsOutStream = new FileOutputStream(trustStore);
            ts.store(tsOutStream, trustStorePassword);
            this.m_configurationDirty = true;
        }
        catch (Throwable throwable) {
            SslManagerServiceImpl.close(tsReadStream);
            SslManagerServiceImpl.close(tsOutStream);
            throw throwable;
        }
        SslManagerServiceImpl.close(tsReadStream);
        SslManagerServiceImpl.close(tsOutStream);
    }

    @Override
    public void deleteTrustCertificate(String alias) throws GeneralSecurityException, IOException {
        FileInputStream tsReadStream = null;
        try {
            String trustStore = this.m_options.getSslKeyStore();
            KeyStore ts = KeyStore.getInstance(KeyStore.getDefaultType());
            tsReadStream = new FileInputStream(trustStore);
            char[] trustStorePassword = this.getKeyStorePassword();
            ts.load(tsReadStream, trustStorePassword);
            ts.deleteEntry(alias);
            ts.store(new KeyStore.LoadStoreParameter(){

                @Override
                public KeyStore.ProtectionParameter getProtectionParameter() {
                    KeyStore.PasswordProtection passwordProtection = null;
                    char[] trustStorePassword = SslManagerServiceImpl.this.getKeyStorePassword();
                    if (trustStorePassword != null) {
                        passwordProtection = new KeyStore.PasswordProtection(trustStorePassword);
                    }
                    return passwordProtection;
                }
            });
            this.m_configurationDirty = true;
        }
        catch (Throwable throwable) {
            SslManagerServiceImpl.close(tsReadStream);
            throw throwable;
        }
        SslManagerServiceImpl.close(tsReadStream);
    }

    @Override
    public void installPrivateKey(String alias, PrivateKey privateKey, char[] password, Certificate[] publicCerts) throws GeneralSecurityException, IOException {
        FileInputStream tsReadStream = null;
        FileOutputStream tsOutStream = null;
        try {
            String keyStore = this.m_options.getSslKeyStore();
            KeyStore ks = KeyStore.getInstance(KeyStore.getDefaultType());
            File fKeyStore = new File(keyStore);
            char[] keyStorePassword = this.getKeyStorePassword();
            if (fKeyStore.exists()) {
                tsReadStream = new FileInputStream(keyStore);
                ks.load(tsReadStream, keyStorePassword);
            } else {
                ks.load(null, null);
            }
            char[] trustStorePwd = this.getKeyStorePassword();
            ks.setKeyEntry(alias, privateKey, trustStorePwd, publicCerts);
            tsOutStream = new FileOutputStream(keyStore);
            ks.store(tsOutStream, keyStorePassword);
            this.m_configurationDirty = true;
        }
        catch (Throwable throwable) {
            SslManagerServiceImpl.close(tsReadStream);
            SslManagerServiceImpl.close(tsOutStream);
            throw throwable;
        }
        SslManagerServiceImpl.close(tsReadStream);
        SslManagerServiceImpl.close(tsOutStream);
    }

    private static SSLSocketFactory createSSLSocketFactory(String protocol, String ciphers, KeyManager[] kms, TrustManager[] tms, boolean hostnameVerification) throws NoSuchAlgorithmException, KeyManagementException {
        SSLContext sslCtx = null;
        if (protocol == null) {
            sslCtx = SSLContext.getDefault();
        } else {
            sslCtx = SSLContext.getInstance(protocol);
            sslCtx.init(kms, tms, null);
        }
        SSLSocketFactory sslSocketFactory = sslCtx.getSocketFactory();
        SSLSocketFactoryWrapper sfw = new SSLSocketFactoryWrapper(sslSocketFactory, ciphers, hostnameVerification);
        return sfw;
    }

    private static TrustManager[] getTrustManagers(String trustStore) throws KeyStoreException, NoSuchAlgorithmException, CertificateException, IOException {
        TrustManagerFactory tmf = null;
        if (trustStore != null) {
            File fTrustStore = new File(trustStore);
            if (fTrustStore.exists()) {
                KeyStore ts = KeyStore.getInstance(KeyStore.getDefaultType());
                FileInputStream tsReadStream = new FileInputStream(trustStore);
                ts.load(tsReadStream, null);
                tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
                tmf.init(ts);
                ((InputStream)tsReadStream).close();
            } else {
                s_logger.info("Could not find trust store at {}. Using Java default.", (Object)trustStore);
            }
        }
        if (tmf == null) {
            tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            tmf.init((KeyStore)null);
        }
        return tmf.getTrustManagers();
    }

    private KeyManager[] getKeyManagers(String keyStore, char[] keyStorePassword, String keyAlias) throws KeyStoreException, NoSuchAlgorithmException, CertificateException, IOException, UnrecoverableEntryException {
        KeyStore ks = this.getKeyStore(keyStore, keyStorePassword, keyAlias);
        KeyManager[] kms = null;
        if (ks != null) {
            KeyManagerFactory kmf = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
            kmf.init(ks, keyStorePassword);
            kms = kmf.getKeyManagers();
        }
        return kms;
    }

    private KeyStore getKeyStore(String keyStore, char[] keyStorePassword, String keyAlias) throws KeyStoreException, FileNotFoundException, IOException, NoSuchAlgorithmException, CertificateException, UnrecoverableEntryException {
        KeyStore ks = null;
        if (keyStore != null) {
            File fKeyStore = new File(keyStore);
            if (fKeyStore.exists()) {
                ks = KeyStore.getInstance(KeyStore.getDefaultType());
                FileInputStream ksReadStream = new FileInputStream(keyStore);
                ks.load(ksReadStream, keyStorePassword);
                if (keyAlias != null) {
                    if (ks.containsAlias(keyAlias) && ks.isKeyEntry(keyAlias)) {
                        if (ks.size() > 1) {
                            KeyStore.PasswordProtection pp = new KeyStore.PasswordProtection(keyStorePassword);
                            KeyStore.Entry entry = ks.getEntry(keyAlias, pp);
                            ks = KeyStore.getInstance(KeyStore.getDefaultType());
                            ks.load(null, null);
                            ks.setEntry(keyAlias, entry, pp);
                        }
                    } else {
                        s_logger.info("Could not find alias {} in key store at {}. Using Java default.", (Object)keyAlias, (Object)keyStore);
                        ks = null;
                    }
                }
                ((InputStream)ksReadStream).close();
            } else {
                s_logger.info("Could not find key store at {}. Using Java default.", (Object)keyStore);
            }
        }
        if (this.m_cryptoService.isFrameworkSecure()) {
            if (keyStore == null) {
                s_logger.warn("The environment is secured but the provided keystore is null");
                throw new KeyStoreException("The environment is secured but the provided keystore is null");
            }
            if (!SslManagerServiceImpl.isKeyStoreAccessible(keyStore, keyStorePassword)) {
                s_logger.warn("The environment is secured but the provided keystore is not accessible");
                throw new KeyStoreException("The environment is secured but the provided keystore is not accessible");
            }
        }
        return ks;
    }

    private char[] getKeyStorePassword() {
        return this.m_cryptoService.getKeyStorePassword(this.m_options.getSslKeyStore());
    }

    private static boolean isKeyStoreAccessible(String location, char[] password) {
        try {
            SslManagerServiceImpl.loadKeyStore(location, password);
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    private static KeyStore loadKeyStore(String location, char[] password) throws IOException, NoSuchAlgorithmException, CertificateException, KeyStoreException {
        KeyStore keyStore;
        FileInputStream is = null;
        try {
            is = new FileInputStream(location);
            KeyStore keystore = KeyStore.getInstance(KeyStore.getDefaultType());
            keystore.load(is, password);
            keyStore = keystore;
        }
        catch (Throwable throwable) {
            SslManagerServiceImpl.close(is);
            throw throwable;
        }
        SslManagerServiceImpl.close(is);
        return keyStore;
    }

    private static void saveKeyStore(KeyStore keystore, String location, char[] password) throws IOException, KeyStoreException, NoSuchAlgorithmException, CertificateException {
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(location);
            keystore.store(fos, password);
        }
        catch (Throwable throwable) {
            SslManagerServiceImpl.close(fos);
            throw throwable;
        }
        SslManagerServiceImpl.close(fos);
    }

    private void changeKeyStorePassword(String location, char[] oldPassword, char[] newPassword) throws IOException, NoSuchAlgorithmException, CertificateException, KeyStoreException {
        KeyStore keystore = null;
        keystore = this.isDefaultPassword(oldPassword) && !this.m_cryptoService.isFrameworkSecure() ? SslManagerServiceImpl.loadKeyStore(location, newPassword) : SslManagerServiceImpl.loadKeyStore(location, oldPassword);
        SslManagerServiceImpl.saveKeyStore(keystore, location, newPassword);
    }

    private static void close(Closeable c) {
        if (c != null) {
            try {
                c.close();
            }
            catch (IOException e) {
                s_logger.warn("Failed to close Closeable", e);
            }
        }
    }

    private boolean isDefaultPassword(char[] password) {
        try {
            char[] keystorePassword = this.m_systemService.getJavaKeyStorePassword();
            boolean isDefaultFromInstaller = Arrays.equals(password, "changeit".toCharArray());
            boolean isDefaultFromUser = Arrays.equals(password, keystorePassword);
            return isDefaultFromInstaller || isDefaultFromUser;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    private boolean changeDefaultKeystorePassword() {
        boolean result = false;
        this.m_timer = new Timer(true);
        char[] snapshotPassword = null;
        boolean needsPasswordChange = true;
        try {
            snapshotPassword = this.m_cryptoService.decryptAes(this.m_options.getSslKeystorePassword().toCharArray());
            needsPasswordChange = this.isDefaultPassword(snapshotPassword);
        }
        catch (KuraException kuraException) {}
        char[] oldPassword = this.m_cryptoService.getKeyStorePassword(this.m_options.getSslKeyStore());
        if (needsPasswordChange && snapshotPassword != null && SslManagerServiceImpl.isKeyStoreAccessible(this.m_options.getSslKeyStore(), snapshotPassword)) {
            oldPassword = snapshotPassword;
        }
        if (this.m_cryptoService.isFrameworkSecure() && needsPasswordChange && oldPassword != null && SslManagerServiceImpl.isKeyStoreAccessible(this.m_options.getSslKeyStore(), oldPassword)) {
            try {
                char[] newPassword = new BigInteger(160, new SecureRandom()).toString(32).toCharArray();
                this.changeKeyStorePassword(this.m_options.getSslKeyStore(), oldPassword, newPassword);
                this.m_cryptoService.setKeyStorePassword(this.m_options.getSslKeyStore(), newPassword);
                final String pid = (String)this.m_properties.get("service.pid");
                HashMap<String, Object> props = new HashMap<String, Object>(this.m_properties);
                props.put("ssl.keystore.password", new Password(newPassword));
                final HashMap<String, Object> theProperties = props;
                this.m_timer.scheduleAtFixedRate(new TimerTask(){

                    @Override
                    public void run() {
                        try {
                            if (SslManagerServiceImpl.this.m_ctx.getServiceReference() != null && SslManagerServiceImpl.this.m_configurationService.getComponentConfiguration(pid) != null) {
                                SslManagerServiceImpl.this.m_configurationService.updateConfiguration(pid, theProperties);
                                SslManagerServiceImpl.this.m_timer.cancel();
                            } else {
                                s_logger.info("No service or configuration available yet. Sleeping...");
                            }
                        }
                        catch (KuraException e) {
                            s_logger.warn("Cannot get/update configuration for pid: {}", (Object)pid, (Object)e);
                        }
                    }
                }, 1000L, 1000L);
                result = true;
            }
            catch (Exception exception) {
                s_logger.warn("Keystore password change failed");
            }
        }
        return result;
    }

    private boolean changeKeystorePassword() {
        char[] oldPassword;
        boolean result = false;
        String password = this.m_options.getSslKeystorePassword();
        char[] newPassword = oldPassword = this.m_cryptoService.getKeyStorePassword(this.m_options.getSslKeyStore());
        if (password != null) {
            try {
                newPassword = this.m_cryptoService.decryptAes(password.toCharArray());
            }
            catch (KuraException kuraException) {
                s_logger.warn("Failed to decrypt keystore password");
            }
        }
        if (oldPassword == null) {
            s_logger.warn("null old password");
        } else if (!Arrays.equals(oldPassword, newPassword)) {
            try {
                this.changeKeyStorePassword(this.m_options.getSslKeyStore(), oldPassword, newPassword);
                this.m_cryptoService.setKeyStorePassword(this.m_options.getSslKeyStore(), newPassword);
                result = true;
            }
            catch (Exception exception) {
                s_logger.warn("Failed to change keystore password");
            }
        }
        return result;
    }
}

