/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.core.data.transport.mqtt;

import org.eclipse.kura.data.DataTransportListener;
import org.eclipse.kura.data.DataTransportToken;
import org.osgi.util.tracker.ServiceTracker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class DataTransportListeners
implements DataTransportListener {
    private static final Logger s_logger = LoggerFactory.getLogger(DataTransportListeners.class);
    private ServiceTracker<DataTransportListener, DataTransportListener> m_listenersTracker;

    public DataTransportListeners(ServiceTracker<DataTransportListener, DataTransportListener> listenersTracker) {
        this.m_listenersTracker = listenersTracker;
    }

    public synchronized void close() {
        if (this.m_listenersTracker.getTrackingCount() != -1) {
            this.m_listenersTracker.close();
        }
    }

    @Override
    public void onConnectionEstablished(boolean newSession) {
        this.openOnce();
        Object[] listeners = this.m_listenersTracker.getServices();
        if (listeners != null && listeners.length != 0) {
            Object[] objectArray = listeners;
            int n = listeners.length;
            int n2 = 0;
            while (n2 < n) {
                Object listener = objectArray[n2];
                try {
                    ((DataTransportListener)listener).onConnectionEstablished(newSession);
                }
                catch (Throwable t) {
                    s_logger.error("Unexpected Throwable", t);
                }
                ++n2;
            }
        } else {
            s_logger.warn("No registered services. Missing onConnectionEstablished()");
        }
    }

    @Override
    public void onDisconnecting() {
        this.openOnce();
        Object[] listeners = this.m_listenersTracker.getServices();
        if (listeners != null && listeners.length != 0) {
            Object[] objectArray = listeners;
            int n = listeners.length;
            int n2 = 0;
            while (n2 < n) {
                Object listener = objectArray[n2];
                try {
                    ((DataTransportListener)listener).onDisconnecting();
                }
                catch (Throwable t) {
                    s_logger.error("Unexpected Throwable", t);
                }
                ++n2;
            }
        } else {
            s_logger.warn("No registered services. Missing onDisconnecting()");
        }
    }

    @Override
    public void onDisconnected() {
        this.openOnce();
        Object[] listeners = this.m_listenersTracker.getServices();
        if (listeners != null && listeners.length != 0) {
            Object[] objectArray = listeners;
            int n = listeners.length;
            int n2 = 0;
            while (n2 < n) {
                Object listener = objectArray[n2];
                try {
                    ((DataTransportListener)listener).onDisconnected();
                }
                catch (Throwable t) {
                    s_logger.error("Unexpected Throwable", t);
                }
                ++n2;
            }
        } else {
            s_logger.warn("No registered services. Missing onDisconnected()");
        }
    }

    @Override
    public void onConfigurationUpdating(boolean wasConnected) {
        this.openOnce();
        Object[] listeners = this.m_listenersTracker.getServices();
        if (listeners != null && listeners.length != 0) {
            Object[] objectArray = listeners;
            int n = listeners.length;
            int n2 = 0;
            while (n2 < n) {
                Object listener = objectArray[n2];
                try {
                    ((DataTransportListener)listener).onConfigurationUpdating(wasConnected);
                }
                catch (Throwable t) {
                    s_logger.error("Unexpected Throwable", t);
                }
                ++n2;
            }
        } else {
            s_logger.warn("No registered services. Missing onConfigurationUpdating()");
        }
    }

    @Override
    public void onConfigurationUpdated(boolean wasConnected) {
        this.openOnce();
        Object[] listeners = this.m_listenersTracker.getServices();
        if (listeners != null && listeners.length != 0) {
            Object[] objectArray = listeners;
            int n = listeners.length;
            int n2 = 0;
            while (n2 < n) {
                Object listener = objectArray[n2];
                try {
                    ((DataTransportListener)listener).onConfigurationUpdated(wasConnected);
                }
                catch (Throwable t) {
                    s_logger.error("Unexpected Throwable", t);
                }
                ++n2;
            }
        } else {
            s_logger.warn("No registered services. Missing onConfigurationUpdated()");
        }
    }

    @Override
    public void onConnectionLost(Throwable cause) {
        this.openOnce();
        Object[] listeners = this.m_listenersTracker.getServices();
        if (listeners != null && listeners.length != 0) {
            Object[] objectArray = listeners;
            int n = listeners.length;
            int n2 = 0;
            while (n2 < n) {
                Object listener = objectArray[n2];
                try {
                    ((DataTransportListener)listener).onConnectionLost(cause);
                }
                catch (Throwable t) {
                    s_logger.error("Unexpected Throwable", t);
                }
                ++n2;
            }
        } else {
            s_logger.warn("No registered services. Missing onConnectionLost()");
        }
    }

    @Override
    public void onMessageArrived(String topic, byte[] payload, int qos, boolean retained) {
        this.openOnce();
        Object[] listeners = this.m_listenersTracker.getServices();
        if (listeners != null && listeners.length != 0) {
            Object[] objectArray = listeners;
            int n = listeners.length;
            int n2 = 0;
            while (n2 < n) {
                Object listener = objectArray[n2];
                try {
                    ((DataTransportListener)listener).onMessageArrived(topic, payload, qos, retained);
                }
                catch (Throwable t) {
                    s_logger.error("Unexpected Throwable", t);
                }
                ++n2;
            }
        } else {
            s_logger.warn("No registered services. Missing onMessageArrived()");
        }
    }

    @Override
    public void onMessageConfirmed(DataTransportToken token) {
        this.openOnce();
        Object[] listeners = this.m_listenersTracker.getServices();
        if (listeners != null && listeners.length != 0) {
            Object[] objectArray = listeners;
            int n = listeners.length;
            int n2 = 0;
            while (n2 < n) {
                Object listener = objectArray[n2];
                try {
                    ((DataTransportListener)listener).onMessageConfirmed(token);
                }
                catch (Throwable t) {
                    s_logger.error("Unexpected Throwable", t);
                }
                ++n2;
            }
        } else {
            s_logger.warn("No registered services. Missing onMessageConfirmed()");
        }
    }

    private synchronized void openOnce() {
        if (this.m_listenersTracker.getTrackingCount() == -1) {
            this.m_listenersTracker.open();
        }
    }
}

