/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.core.data;

import org.eclipse.kura.data.DataServiceListener;
import org.osgi.util.tracker.ServiceTracker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class DataServiceListeners
implements DataServiceListener {
    private static final Logger s_logger = LoggerFactory.getLogger(DataServiceListeners.class);
    private ServiceTracker<DataServiceListener, DataServiceListener> m_listenersTracker;

    public DataServiceListeners(ServiceTracker<DataServiceListener, DataServiceListener> listenersTracker) {
        this.m_listenersTracker = listenersTracker;
    }

    public synchronized void close() {
        if (this.m_listenersTracker.getTrackingCount() != -1) {
            this.m_listenersTracker.close();
        }
    }

    @Override
    public void onConnectionEstablished() {
        this.openOnce();
        Object[] listeners = this.m_listenersTracker.getServices();
        if (listeners != null && listeners.length != 0) {
            Object[] objectArray = listeners;
            int n = listeners.length;
            int n2 = 0;
            while (n2 < n) {
                Object listener = objectArray[n2];
                try {
                    ((DataServiceListener)listener).onConnectionEstablished();
                }
                catch (Throwable t) {
                    s_logger.error("Unexpected Throwable", t);
                }
                ++n2;
            }
        } else {
            s_logger.warn("No registered services. Missing onConnectionEstablished()");
        }
    }

    @Override
    public void onDisconnecting() {
        this.openOnce();
        Object[] listeners = this.m_listenersTracker.getServices();
        if (listeners != null && listeners.length != 0) {
            Object[] objectArray = listeners;
            int n = listeners.length;
            int n2 = 0;
            while (n2 < n) {
                Object listener = objectArray[n2];
                try {
                    ((DataServiceListener)listener).onDisconnecting();
                }
                catch (Throwable t) {
                    s_logger.error("Unexpected Throwable", t);
                }
                ++n2;
            }
        } else {
            s_logger.warn("No registered services. Missing onDisconnecting()");
        }
    }

    @Override
    public void onDisconnected() {
        this.openOnce();
        Object[] listeners = this.m_listenersTracker.getServices();
        if (listeners != null && listeners.length != 0) {
            Object[] objectArray = listeners;
            int n = listeners.length;
            int n2 = 0;
            while (n2 < n) {
                Object listener = objectArray[n2];
                try {
                    ((DataServiceListener)listener).onDisconnected();
                }
                catch (Throwable t) {
                    s_logger.error("Unexpected Throwable", t);
                }
                ++n2;
            }
        } else {
            s_logger.warn("No registered services. Missing onDisconnected()");
        }
    }

    @Override
    public void onConnectionLost(Throwable cause) {
        this.openOnce();
        Object[] listeners = this.m_listenersTracker.getServices();
        if (listeners != null && listeners.length != 0) {
            Object[] objectArray = listeners;
            int n = listeners.length;
            int n2 = 0;
            while (n2 < n) {
                Object listener = objectArray[n2];
                try {
                    ((DataServiceListener)listener).onConnectionLost(cause);
                }
                catch (Throwable t) {
                    s_logger.error("Unexpected Throwable", t);
                }
                ++n2;
            }
        } else {
            s_logger.warn("No registered services. Missing onConnectionLost()");
        }
    }

    @Override
    public void onMessageArrived(String topic, byte[] payload, int qos, boolean retained) {
        this.openOnce();
        Object[] listeners = this.m_listenersTracker.getServices();
        if (listeners != null && listeners.length != 0) {
            Object[] objectArray = listeners;
            int n = listeners.length;
            int n2 = 0;
            while (n2 < n) {
                Object listener = objectArray[n2];
                try {
                    ((DataServiceListener)listener).onMessageArrived(topic, payload, qos, retained);
                }
                catch (Throwable t) {
                    s_logger.error("Unexpected Throwable", t);
                }
                ++n2;
            }
        } else {
            s_logger.warn("No registered services. Missing onMessageArrived()");
        }
    }

    @Override
    public void onMessagePublished(int messageId, String topic) {
        this.openOnce();
        Object[] listeners = this.m_listenersTracker.getServices();
        if (listeners != null && listeners.length != 0) {
            Object[] objectArray = listeners;
            int n = listeners.length;
            int n2 = 0;
            while (n2 < n) {
                Object listener = objectArray[n2];
                try {
                    ((DataServiceListener)listener).onMessagePublished(messageId, topic);
                }
                catch (Throwable t) {
                    s_logger.error("Unexpected Throwable", t);
                }
                ++n2;
            }
        } else {
            s_logger.warn("No registered services. Missing onMessagePublished()");
        }
    }

    @Override
    public void onMessageConfirmed(int messageId, String topic) {
        this.openOnce();
        Object[] listeners = this.m_listenersTracker.getServices();
        if (listeners != null && listeners.length != 0) {
            Object[] objectArray = listeners;
            int n = listeners.length;
            int n2 = 0;
            while (n2 < n) {
                Object listener = objectArray[n2];
                try {
                    ((DataServiceListener)listener).onMessageConfirmed(messageId, topic);
                }
                catch (Throwable t) {
                    s_logger.error("Unexpected Throwable", t);
                }
                ++n2;
            }
        } else {
            s_logger.warn("No registered services. Missing onMessageConfirmed()");
        }
    }

    private synchronized void openOnce() {
        if (this.m_listenersTracker.getTrackingCount() == -1) {
            this.m_listenersTracker.open();
        }
    }
}

