/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.core.cloud;

import com.google.protobuf.ByteString;
import java.io.IOException;
import org.eclipse.kura.KuraInvalidMetricTypeException;
import org.eclipse.kura.core.cloud.CloudPayloadEncoder;
import org.eclipse.kura.core.message.protobuf.KuraPayloadProto;
import org.eclipse.kura.message.KuraPayload;
import org.eclipse.kura.message.KuraPosition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CloudPayloadProtoBufEncoderImpl
implements CloudPayloadEncoder {
    private static final Logger s_logger = LoggerFactory.getLogger(CloudPayloadProtoBufEncoderImpl.class);
    private KuraPayload m_kuraPayload;

    public CloudPayloadProtoBufEncoderImpl(KuraPayload KuraPayload2) {
        this.m_kuraPayload = KuraPayload2;
    }

    @Override
    public byte[] getBytes() throws IOException {
        KuraPayloadProto.KuraPayload.Builder protoMsg = KuraPayloadProto.KuraPayload.newBuilder();
        if (this.m_kuraPayload.getTimestamp() != null) {
            protoMsg.setTimestamp(this.m_kuraPayload.getTimestamp().getTime());
        }
        if (this.m_kuraPayload.getPosition() != null) {
            protoMsg.setPosition(this.buildPositionProtoBuf());
        }
        for (String name : this.m_kuraPayload.metricNames()) {
            Object value = this.m_kuraPayload.getMetric(name);
            try {
                KuraPayloadProto.KuraPayload.KuraMetric.Builder metricB = KuraPayloadProto.KuraPayload.KuraMetric.newBuilder();
                metricB.setName(name);
                CloudPayloadProtoBufEncoderImpl.setProtoKuraMetricValue(metricB, value);
                metricB.build();
                protoMsg.addMetric(metricB);
            }
            catch (KuraInvalidMetricTypeException eihte) {
                try {
                    s_logger.error("During serialization, ignoring metric named: {}. Unrecognized value type: {}.", (Object)name, (Object)value.getClass().getName());
                }
                catch (NullPointerException nullPointerException) {
                    s_logger.error("During serialization, ignoring metric named: {}. The value is null.", (Object)name);
                }
                throw new RuntimeException(eihte);
            }
        }
        if (this.m_kuraPayload.getBody() != null) {
            protoMsg.setBody(ByteString.copyFrom(this.m_kuraPayload.getBody()));
        }
        return protoMsg.build().toByteArray();
    }

    private KuraPayloadProto.KuraPayload.KuraPosition buildPositionProtoBuf() {
        KuraPayloadProto.KuraPayload.KuraPosition.Builder protoPos = null;
        protoPos = KuraPayloadProto.KuraPayload.KuraPosition.newBuilder();
        KuraPosition position = this.m_kuraPayload.getPosition();
        if (position.getLatitude() != null) {
            protoPos.setLatitude(position.getLatitude());
        }
        if (position.getLongitude() != null) {
            protoPos.setLongitude(position.getLongitude());
        }
        if (position.getAltitude() != null) {
            protoPos.setAltitude(position.getAltitude());
        }
        if (position.getPrecision() != null) {
            protoPos.setPrecision(position.getPrecision());
        }
        if (position.getHeading() != null) {
            protoPos.setHeading(position.getHeading());
        }
        if (position.getSpeed() != null) {
            protoPos.setSpeed(position.getSpeed());
        }
        if (position.getTimestamp() != null) {
            protoPos.setTimestamp(position.getTimestamp().getTime());
        }
        if (position.getSatellites() != null) {
            protoPos.setSatellites(position.getSatellites());
        }
        if (position.getStatus() != null) {
            protoPos.setStatus(position.getStatus());
        }
        return protoPos.build();
    }

    private static void setProtoKuraMetricValue(KuraPayloadProto.KuraPayload.KuraMetric.Builder metric, Object o) throws KuraInvalidMetricTypeException {
        if (o instanceof String) {
            metric.setType(KuraPayloadProto.KuraPayload.KuraMetric.ValueType.STRING);
            metric.setStringValue((String)o);
        } else if (o instanceof Double) {
            metric.setType(KuraPayloadProto.KuraPayload.KuraMetric.ValueType.DOUBLE);
            metric.setDoubleValue((Double)o);
        } else if (o instanceof Integer) {
            metric.setType(KuraPayloadProto.KuraPayload.KuraMetric.ValueType.INT32);
            metric.setIntValue((Integer)o);
        } else if (o instanceof Float) {
            metric.setType(KuraPayloadProto.KuraPayload.KuraMetric.ValueType.FLOAT);
            metric.setFloatValue(((Float)o).floatValue());
        } else if (o instanceof Long) {
            metric.setType(KuraPayloadProto.KuraPayload.KuraMetric.ValueType.INT64);
            metric.setLongValue((Long)o);
        } else if (o instanceof Boolean) {
            metric.setType(KuraPayloadProto.KuraPayload.KuraMetric.ValueType.BOOL);
            metric.setBoolValue((Boolean)o);
        } else if (o instanceof byte[]) {
            metric.setType(KuraPayloadProto.KuraPayload.KuraMetric.ValueType.BYTES);
            metric.setBytesValue(ByteString.copyFrom((byte[])o));
        } else {
            if (o == null) {
                throw new KuraInvalidMetricTypeException((Object)"null value");
            }
            throw new KuraInvalidMetricTypeException((Object)o.getClass().getName());
        }
    }
}

