/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.core.cloud;

import org.eclipse.kura.cloud.CloudClientListener;
import org.eclipse.kura.message.KuraPayload;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CloudClientListenerAdapter
implements CloudClientListener {
    private static final Logger s_logger = LoggerFactory.getLogger(CloudClientListenerAdapter.class);
    private CloudClientListener m_listener;

    CloudClientListenerAdapter(CloudClientListener listener) {
        this.m_listener = listener;
    }

    public CloudClientListener getCloudClientListenerAdapted() {
        return this.m_listener;
    }

    @Override
    public void onControlMessageArrived(String deviceId, String appTopic, KuraPayload msg, int qos, boolean retain) {
        try {
            this.m_listener.onControlMessageArrived(deviceId, appTopic, msg, qos, retain);
        }
        catch (Exception e) {
            s_logger.error("IGNORED - Error notifying " + this.m_listener + " for onControlMessageArrived", e);
        }
    }

    @Override
    public void onMessageArrived(String deviceId, String appTopic, KuraPayload msg, int qos, boolean retain) {
        try {
            this.m_listener.onMessageArrived(deviceId, appTopic, msg, qos, retain);
        }
        catch (Exception e) {
            s_logger.error("IGNORED - Error notifying " + this.m_listener + " for onMessageArrived", e);
        }
    }

    @Override
    public void onConnectionLost() {
        try {
            this.m_listener.onConnectionLost();
        }
        catch (Exception e) {
            s_logger.error("IGNORED - Error notifying " + this.m_listener + " for onConnectionLost", e);
        }
    }

    @Override
    public void onConnectionEstablished() {
        try {
            this.m_listener.onConnectionEstablished();
        }
        catch (Exception e) {
            s_logger.error("IGNORED - Error notifying " + this.m_listener + " for onConnectionEstablished", e);
        }
    }

    @Override
    public void onMessageConfirmed(int messageId, String appTopic) {
        try {
            this.m_listener.onMessageConfirmed(messageId, appTopic);
        }
        catch (Exception e) {
            s_logger.error("IGNORED - Error notifying " + this.m_listener + " for onMessageConfirmed", e);
        }
    }

    @Override
    public void onMessagePublished(int messageId, String appTopic) {
        try {
            this.m_listener.onMessagePublished(messageId, appTopic);
        }
        catch (Exception e) {
            s_logger.error("IGNORED - Error notifying " + this.m_listener + " for onMessagePublished", e);
        }
    }
}

