/*
 * Decompiled with CFR 0.152.
 */
package io.moquette.spi.impl;

import io.moquette.proto.messages.AbstractMessage;
import io.moquette.proto.messages.ConnAckMessage;
import io.moquette.proto.messages.ConnectMessage;
import io.moquette.proto.messages.PubAckMessage;
import io.moquette.proto.messages.PubCompMessage;
import io.moquette.proto.messages.PubRecMessage;
import io.moquette.proto.messages.PubRelMessage;
import io.moquette.proto.messages.PublishMessage;
import io.moquette.proto.messages.SubAckMessage;
import io.moquette.proto.messages.SubscribeMessage;
import io.moquette.proto.messages.UnsubAckMessage;
import io.moquette.proto.messages.UnsubscribeMessage;
import io.moquette.server.ConnectionDescriptor;
import io.moquette.server.ServerChannel;
import io.moquette.server.netty.NettyChannel;
import io.moquette.spi.ClientSession;
import io.moquette.spi.IMatchingCondition;
import io.moquette.spi.IMessagesStore;
import io.moquette.spi.ISessionsStore;
import io.moquette.spi.impl.BrokerInterceptor;
import io.moquette.spi.impl.DebugUtils;
import io.moquette.spi.impl.subscriptions.Subscription;
import io.moquette.spi.impl.subscriptions.SubscriptionsStore;
import io.moquette.spi.security.IAuthenticator;
import io.moquette.spi.security.IAuthorizator;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProtocolProcessor {
    private static final Logger LOG = LoggerFactory.getLogger(ProtocolProcessor.class);
    protected ConcurrentMap<String, ConnectionDescriptor> m_clientIDs;
    private SubscriptionsStore subscriptions;
    private boolean allowAnonymous;
    private IAuthorizator m_authorizator;
    private IMessagesStore m_messagesStore;
    private ISessionsStore m_sessionsStore;
    private IAuthenticator m_authenticator;
    private BrokerInterceptor m_interceptor;
    private ConcurrentMap<String, WillMessage> m_willStore = new ConcurrentHashMap<String, WillMessage>();

    ProtocolProcessor() {
    }

    void init(SubscriptionsStore subscriptions, IMessagesStore storageService, ISessionsStore sessionsStore, IAuthenticator authenticator, boolean allowAnonymous, IAuthorizator authorizator, BrokerInterceptor interceptor) {
        this.m_clientIDs = new ConcurrentHashMap<String, ConnectionDescriptor>();
        this.m_interceptor = interceptor;
        this.subscriptions = subscriptions;
        this.allowAnonymous = allowAnonymous;
        this.m_authorizator = authorizator;
        LOG.trace("subscription tree on init {}", (Object)subscriptions.dumpTree());
        this.m_authenticator = authenticator;
        this.m_messagesStore = storageService;
        this.m_sessionsStore = sessionsStore;
    }

    public void processConnect(ServerChannel session, ConnectMessage msg) {
        boolean isSessionAlreadyStored;
        LOG.debug("CONNECT for client <{}>", (Object)msg.getClientID());
        if (msg.getProtocolVersion() != 3 && msg.getProtocolVersion() != 4) {
            ConnAckMessage badProto = new ConnAckMessage();
            badProto.setReturnCode((byte)1);
            LOG.warn("processConnect sent bad proto ConnAck");
            session.write(badProto);
            session.close(false);
            return;
        }
        if (msg.getClientID() == null || msg.getClientID().length() == 0) {
            ConnAckMessage okResp = new ConnAckMessage();
            okResp.setReturnCode((byte)2);
            session.write(okResp);
            this.m_interceptor.notifyClientConnected(msg);
            return;
        }
        if (msg.isUserFlag()) {
            byte[] pwd = null;
            if (msg.isPasswordFlag()) {
                pwd = msg.getPassword();
            } else if (!this.allowAnonymous) {
                this.failedCredentials(session);
                return;
            }
            if (!this.m_authenticator.checkValid(msg.getUsername(), pwd)) {
                this.failedCredentials(session);
                return;
            }
            session.setAttribute(NettyChannel.ATTR_KEY_USERNAME, msg.getUsername());
        } else if (!this.allowAnonymous) {
            this.failedCredentials(session);
            return;
        }
        if (this.m_clientIDs.containsKey(msg.getClientID())) {
            LOG.info("Found an existing connection with same client ID <{}>, forcing to close", (Object)msg.getClientID());
            ServerChannel oldSession = ((ConnectionDescriptor)this.m_clientIDs.get((Object)msg.getClientID())).session;
            ClientSession oldClientSession = this.m_sessionsStore.sessionForClient(msg.getClientID());
            oldClientSession.disconnect();
            oldSession.setAttribute(NettyChannel.ATTR_KEY_SESSION_STOLEN, true);
            oldSession.close(false);
            LOG.debug("Existing connection with same client ID <{}>, forced to close", (Object)msg.getClientID());
        }
        ConnectionDescriptor connDescr = new ConnectionDescriptor(msg.getClientID(), session, msg.isCleanSession());
        this.m_clientIDs.put(msg.getClientID(), connDescr);
        int keepAlive = msg.getKeepAlive();
        LOG.debug("Connect with keepAlive {} s", (Object)keepAlive);
        session.setAttribute(NettyChannel.ATTR_KEY_KEEPALIVE, keepAlive);
        session.setAttribute(NettyChannel.ATTR_KEY_CLEANSESSION, msg.isCleanSession());
        session.setAttribute(NettyChannel.ATTR_KEY_CLIENTID, msg.getClientID());
        LOG.debug("Connect create session <{}>", (Object)session);
        session.setIdleTime(Math.round((float)keepAlive * 1.5f));
        if (msg.isWillFlag()) {
            AbstractMessage.QOSType willQos = AbstractMessage.QOSType.valueOf(msg.getWillQos());
            byte[] willPayload = msg.getWillMessage();
            ByteBuffer bb = (ByteBuffer)ByteBuffer.allocate(willPayload.length).put(willPayload).flip();
            WillMessage will = new WillMessage(msg.getWillTopic(), bb, msg.isWillRetain(), willQos);
            this.m_willStore.put(msg.getClientID(), will);
        }
        ConnAckMessage okResp = new ConnAckMessage();
        okResp.setReturnCode((byte)0);
        ClientSession clientSession = this.m_sessionsStore.sessionForClient(msg.getClientID());
        boolean bl = isSessionAlreadyStored = clientSession != null;
        if (!msg.isCleanSession() && isSessionAlreadyStored) {
            okResp.setSessionPresent(true);
        }
        session.write(okResp);
        this.m_interceptor.notifyClientConnected(msg);
        if (!isSessionAlreadyStored) {
            LOG.info("Create persistent session for clientID <{}>", (Object)msg.getClientID());
            clientSession = this.m_sessionsStore.createNewSession(msg.getClientID(), msg.isCleanSession());
        }
        clientSession.activate();
        if (msg.isCleanSession()) {
            clientSession.cleanSession();
        }
        LOG.info("Connected client ID <{}> with clean session {}", (Object)msg.getClientID(), (Object)msg.isCleanSession());
        if (!msg.isCleanSession()) {
            this.republishStoredInSession(clientSession);
        }
        LOG.info("CONNECT processed");
    }

    private void failedCredentials(ServerChannel session) {
        ConnAckMessage okResp = new ConnAckMessage();
        okResp.setReturnCode((byte)4);
        session.write(okResp);
        session.close(false);
    }

    private void republishStoredInSession(ClientSession clientSession) {
        LOG.trace("republishStoredInSession for client <{}>", (Object)clientSession);
        List<IMessagesStore.StoredMessage> publishedEvents = clientSession.storedMessages();
        if (publishedEvents.isEmpty()) {
            LOG.info("No stored messages for client <{}>", (Object)clientSession.clientID);
            return;
        }
        LOG.info("republishing stored messages to client <{}>", (Object)clientSession.clientID);
        for (IMessagesStore.StoredMessage pubEvt : publishedEvents) {
            this.directSend(clientSession, pubEvt.getTopic(), pubEvt.getQos(), pubEvt.getMessage(), false, pubEvt.getMessageID());
            clientSession.removeEnqueued(pubEvt.getGuid());
        }
    }

    public void processPubAck(ServerChannel session, PubAckMessage msg) {
        String clientID = (String)session.getAttribute(NettyChannel.ATTR_KEY_CLIENTID);
        int messageID = msg.getMessageID();
        ClientSession targetSession = this.m_sessionsStore.sessionForClient(clientID);
        this.verifyToActivate(clientID, targetSession);
        targetSession.inFlightAcknowledged(messageID);
    }

    private void verifyToActivate(String clientID, ClientSession targetSession) {
        if (this.m_clientIDs.containsKey(clientID)) {
            targetSession.activate();
        }
    }

    private static IMessagesStore.StoredMessage asStoredMessage(PublishMessage msg) {
        IMessagesStore.StoredMessage stored = new IMessagesStore.StoredMessage(msg.getPayload().array(), msg.getQos(), msg.getTopicName());
        stored.setRetained(msg.isRetainFlag());
        stored.setMessageID(msg.getMessageID());
        return stored;
    }

    private static IMessagesStore.StoredMessage asStoredMessage(WillMessage will) {
        IMessagesStore.StoredMessage pub = new IMessagesStore.StoredMessage(will.getPayload().array(), will.getQos(), will.getTopic());
        pub.setRetained(will.isRetained());
        return pub;
    }

    public void processPublish(ServerChannel session, PublishMessage msg) {
        LOG.trace("PUB --PUBLISH--> SRV executePublish invoked with {}", (Object)msg);
        String clientID = (String)session.getAttribute(NettyChannel.ATTR_KEY_CLIENTID);
        String topic = msg.getTopicName();
        String user = (String)session.getAttribute(NettyChannel.ATTR_KEY_USERNAME);
        if (!this.m_authorizator.canWrite(topic, user, clientID)) {
            LOG.debug("topic {} doesn't have write credentials", (Object)topic);
            return;
        }
        AbstractMessage.QOSType qos = msg.getQos();
        Integer messageID = msg.getMessageID();
        LOG.info("PUBLISH from clientID <{}> on topic <{}> with QoS {}", new Object[]{clientID, topic, qos});
        String guid = null;
        IMessagesStore.StoredMessage toStoreMsg = ProtocolProcessor.asStoredMessage(msg);
        toStoreMsg.setClientID(clientID);
        if (qos == AbstractMessage.QOSType.MOST_ONE) {
            this.route2Subscribers(toStoreMsg);
        } else if (qos == AbstractMessage.QOSType.LEAST_ONE) {
            this.route2Subscribers(toStoreMsg);
            this.sendPubAck(clientID, messageID);
            LOG.debug("replying with PubAck to MSG ID {}", (Object)messageID);
        } else if (qos == AbstractMessage.QOSType.EXACTLY_ONCE) {
            guid = this.m_messagesStore.storePublishForFuture(toStoreMsg);
            this.sendPubRec(clientID, messageID);
        }
        if (msg.isRetainFlag()) {
            if (qos == AbstractMessage.QOSType.MOST_ONE) {
                this.m_messagesStore.cleanRetained(topic);
            } else if (!msg.getPayload().hasRemaining()) {
                this.m_messagesStore.cleanRetained(topic);
            } else {
                if (guid == null) {
                    guid = this.m_messagesStore.storePublishForFuture(toStoreMsg);
                }
                this.m_messagesStore.storeRetained(topic, guid);
            }
        }
        this.m_interceptor.notifyTopicPublished(msg, clientID);
    }

    public void internalPublish(PublishMessage msg) {
        AbstractMessage.QOSType qos = msg.getQos();
        String topic = msg.getTopicName();
        LOG.info("embedded PUBLISH on topic <{}> with QoS {}", (Object)topic, (Object)qos);
        String guid = null;
        IMessagesStore.StoredMessage toStoreMsg = ProtocolProcessor.asStoredMessage(msg);
        toStoreMsg.setClientID("BROKER_SELF");
        toStoreMsg.setMessageID(1);
        if (qos == AbstractMessage.QOSType.EXACTLY_ONCE) {
            guid = this.m_messagesStore.storePublishForFuture(toStoreMsg);
        }
        this.route2Subscribers(toStoreMsg);
        if (!msg.isRetainFlag()) {
            return;
        }
        if (qos == AbstractMessage.QOSType.MOST_ONE || !msg.getPayload().hasRemaining()) {
            this.m_messagesStore.cleanRetained(topic);
            return;
        }
        if (guid == null) {
            guid = this.m_messagesStore.storePublishForFuture(toStoreMsg);
        }
        this.m_messagesStore.storeRetained(topic, guid);
    }

    private void forwardPublishWill(WillMessage will, String clientID) {
        Integer messageId = null;
        if (will.getQos() != AbstractMessage.QOSType.MOST_ONE) {
            messageId = this.m_sessionsStore.nextPacketID(clientID);
        }
        IMessagesStore.StoredMessage tobeStored = ProtocolProcessor.asStoredMessage(will);
        tobeStored.setClientID(clientID);
        tobeStored.setMessageID(messageId);
        this.route2Subscribers(tobeStored);
    }

    void route2Subscribers(IMessagesStore.StoredMessage pubMsg) {
        String topic = pubMsg.getTopic();
        AbstractMessage.QOSType publishingQos = pubMsg.getQos();
        ByteBuffer origMessage = pubMsg.getMessage();
        LOG.debug("route2Subscribers republishing to existing subscribers that matches the topic {}", (Object)topic);
        if (LOG.isTraceEnabled()) {
            LOG.trace("content <{}>", (Object)DebugUtils.payload2Str(origMessage));
            LOG.trace("subscription tree {}", (Object)this.subscriptions.dumpTree());
        }
        String guid = null;
        if (publishingQos == AbstractMessage.QOSType.EXACTLY_ONCE || publishingQos == AbstractMessage.QOSType.LEAST_ONE) {
            guid = this.m_messagesStore.storePublishForFuture(pubMsg);
        }
        for (Subscription sub : this.subscriptions.matches(topic)) {
            AbstractMessage.QOSType qos = publishingQos;
            if (qos.byteValue() > sub.getRequestedQos().byteValue()) {
                qos = sub.getRequestedQos();
            }
            ClientSession targetSession = this.m_sessionsStore.sessionForClient(sub.getClientId());
            this.verifyToActivate(sub.getClientId(), targetSession);
            LOG.debug("Broker republishing to client <{}> topic <{}> qos <{}>, active {}", new Object[]{sub.getClientId(), sub.getTopicFilter(), qos, targetSession.isActive()});
            ByteBuffer message = origMessage.duplicate();
            if (qos == AbstractMessage.QOSType.MOST_ONE && targetSession.isActive()) {
                this.directSend(targetSession, topic, qos, message, false, null);
                continue;
            }
            if (!targetSession.isCleanSession() && !targetSession.isActive()) {
                targetSession.enqueueToDeliver(guid);
                continue;
            }
            if (!targetSession.isActive()) continue;
            int messageId = targetSession.nextPacketId();
            targetSession.inFlightAckWaiting(guid, messageId);
            this.directSend(targetSession, topic, qos, message, false, messageId);
        }
    }

    protected void directSend(ClientSession clientsession, String topic, AbstractMessage.QOSType qos, ByteBuffer message, boolean retained, Integer messageID) {
        String clientId = clientsession.clientID;
        LOG.debug("directSend invoked clientId <{}> on topic <{}> QoS {} retained {} messageID {}", new Object[]{clientId, topic, qos, retained, messageID});
        PublishMessage pubMessage = new PublishMessage();
        pubMessage.setRetainFlag(retained);
        pubMessage.setTopicName(topic);
        pubMessage.setQos(qos);
        pubMessage.setPayload(message);
        LOG.info("send publish message to <{}> on topic <{}>", (Object)clientId, (Object)topic);
        if (LOG.isDebugEnabled()) {
            LOG.debug("content <{}>", (Object)DebugUtils.payload2Str(message));
        }
        if (pubMessage.getQos() != AbstractMessage.QOSType.MOST_ONE) {
            pubMessage.setMessageID(messageID);
        } else if (messageID != null) {
            throw new RuntimeException("Internal bad error, trying to forwardPublish a QoS 0 message with PacketIdentifier: " + messageID);
        }
        if (this.m_clientIDs == null) {
            throw new RuntimeException("Internal bad error, found m_clientIDs to null while it should be initialized, somewhere it's overwritten!!");
        }
        LOG.debug("clientIDs are {}", (Object)this.m_clientIDs);
        if (this.m_clientIDs.get(clientId) == null) {
            throw new RuntimeException(String.format("Can't find a ConnectionDescriptor for client <%s> in cache <%s>", clientId, this.m_clientIDs));
        }
        ServerChannel session = ((ConnectionDescriptor)this.m_clientIDs.get((Object)clientId)).session;
        LOG.debug("Session for clientId {} is {}", (Object)clientId, (Object)session);
        String user = (String)session.getAttribute(NettyChannel.ATTR_KEY_USERNAME);
        if (!this.m_authorizator.canRead(topic, user, clientId)) {
            LOG.debug("topic {} doesn't have read credentials", (Object)topic);
            return;
        }
        session.write(pubMessage);
    }

    private void sendPubRec(String clientID, int messageID) {
        LOG.trace("PUB <--PUBREC-- SRV sendPubRec invoked for clientID {} with messageID {}", (Object)clientID, (Object)messageID);
        PubRecMessage pubRecMessage = new PubRecMessage();
        pubRecMessage.setMessageID(messageID);
        ((ConnectionDescriptor)this.m_clientIDs.get((Object)clientID)).session.write(pubRecMessage);
    }

    private void sendPubAck(String clientId, int messageID) {
        LOG.trace("sendPubAck invoked");
        PubAckMessage pubAckMessage = new PubAckMessage();
        pubAckMessage.setMessageID(messageID);
        try {
            if (this.m_clientIDs == null) {
                throw new RuntimeException("Internal bad error, found m_clientIDs to null while it should be initialized, somewhere it's overwritten!!");
            }
            LOG.debug("clientIDs are {}", (Object)this.m_clientIDs);
            if (this.m_clientIDs.get(clientId) == null) {
                throw new RuntimeException(String.format("Can't find a ConnectionDescriptor for client %s in cache %s", clientId, this.m_clientIDs));
            }
            ((ConnectionDescriptor)this.m_clientIDs.get((Object)clientId)).session.write(pubAckMessage);
        }
        catch (Throwable t) {
            LOG.error(null, t);
        }
    }

    public void processPubRel(ServerChannel session, PubRelMessage msg) {
        String clientID = (String)session.getAttribute(NettyChannel.ATTR_KEY_CLIENTID);
        int messageID = msg.getMessageID();
        LOG.debug("PUB --PUBREL--> SRV processPubRel invoked for clientID {} ad messageID {}", (Object)clientID, (Object)messageID);
        ClientSession targetSession = this.m_sessionsStore.sessionForClient(clientID);
        this.verifyToActivate(clientID, targetSession);
        IMessagesStore.StoredMessage evt = targetSession.storedMessage(messageID);
        this.route2Subscribers(evt);
        if (evt.isRetained()) {
            String topic = evt.getTopic();
            if (!evt.getMessage().hasRemaining()) {
                this.m_messagesStore.cleanRetained(topic);
            } else {
                this.m_messagesStore.storeRetained(topic, evt.getGuid());
            }
        }
        this.sendPubComp(clientID, messageID);
    }

    private void sendPubComp(String clientID, int messageID) {
        LOG.debug("PUB <--PUBCOMP-- SRV sendPubComp invoked for clientID {} ad messageID {}", (Object)clientID, (Object)messageID);
        PubCompMessage pubCompMessage = new PubCompMessage();
        pubCompMessage.setMessageID(messageID);
        ((ConnectionDescriptor)this.m_clientIDs.get((Object)clientID)).session.write(pubCompMessage);
    }

    public void processPubRec(ServerChannel session, PubRecMessage msg) {
        String clientID = (String)session.getAttribute(NettyChannel.ATTR_KEY_CLIENTID);
        int messageID = msg.getMessageID();
        ClientSession targetSession = this.m_sessionsStore.sessionForClient(clientID);
        this.verifyToActivate(clientID, targetSession);
        targetSession.inFlightAcknowledged(messageID);
        targetSession.secondPhaseAckWaiting(messageID);
        LOG.debug("\t\tSRV <--PUBREC-- SUB processPubRec invoked for clientID {} ad messageID {}", (Object)clientID, (Object)messageID);
        PubRelMessage pubRelMessage = new PubRelMessage();
        pubRelMessage.setMessageID(messageID);
        pubRelMessage.setQos(AbstractMessage.QOSType.LEAST_ONE);
        session.write(pubRelMessage);
    }

    public void processPubComp(ServerChannel session, PubCompMessage msg) {
        String clientID = (String)session.getAttribute(NettyChannel.ATTR_KEY_CLIENTID);
        int messageID = msg.getMessageID();
        LOG.debug("\t\tSRV <--PUBCOMP-- SUB processPubComp invoked for clientID {} ad messageID {}", (Object)clientID, (Object)messageID);
        ClientSession targetSession = this.m_sessionsStore.sessionForClient(clientID);
        this.verifyToActivate(clientID, targetSession);
        targetSession.secondPhaseAcknowledged(messageID);
    }

    public void processDisconnect(ServerChannel session) throws InterruptedException {
        String clientID = (String)session.getAttribute(NettyChannel.ATTR_KEY_CLIENTID);
        boolean cleanSession = (Boolean)session.getAttribute(NettyChannel.ATTR_KEY_CLEANSESSION);
        LOG.info("DISCONNECT client <{}> with clean session {}", (Object)clientID, (Object)cleanSession);
        ClientSession clientSession = this.m_sessionsStore.sessionForClient(clientID);
        clientSession.disconnect();
        this.m_clientIDs.remove(clientID);
        session.close(true);
        this.m_willStore.remove(clientID);
        this.m_interceptor.notifyClientDisconnected(clientID);
        LOG.info("DISCONNECT client <{}> finished", (Object)clientID, (Object)cleanSession);
    }

    public void processConnectionLost(String clientID, boolean sessionStolen, NettyChannel channel) {
        ConnectionDescriptor oldConnDescr = new ConnectionDescriptor(clientID, channel, true);
        this.m_clientIDs.remove(clientID, oldConnDescr);
        if (sessionStolen) {
            ClientSession clientSession = this.m_sessionsStore.sessionForClient(clientID);
            clientSession.deactivate();
            LOG.info("Lost connection with client <{}>", (Object)clientID);
        }
        if (!sessionStolen && this.m_willStore.containsKey(clientID)) {
            WillMessage will = (WillMessage)this.m_willStore.get(clientID);
            this.forwardPublishWill(will, clientID);
            this.m_willStore.remove(clientID);
        }
    }

    public void processUnsubscribe(ServerChannel session, UnsubscribeMessage msg) {
        List<String> topics = msg.topicFilters();
        int messageID = msg.getMessageID();
        String clientID = (String)session.getAttribute(NettyChannel.ATTR_KEY_CLIENTID);
        LOG.debug("UNSUBSCRIBE subscription on topics {} for clientID <{}>", (Object)topics, (Object)clientID);
        ClientSession clientSession = this.m_sessionsStore.sessionForClient(clientID);
        this.verifyToActivate(clientID, clientSession);
        for (String topic : topics) {
            boolean validTopic = SubscriptionsStore.validate(topic);
            if (!validTopic) {
                session.close(true);
                LOG.warn("UNSUBSCRIBE found an invalid topic filter <{}> for clientID <{}>", (Object)topic, (Object)clientID);
                return;
            }
            this.subscriptions.removeSubscription(topic, clientID);
            clientSession.unsubscribeFrom(topic);
            this.m_interceptor.notifyTopicUnsubscribed(topic, clientID);
        }
        UnsubAckMessage ackMessage = new UnsubAckMessage();
        ackMessage.setMessageID(messageID);
        LOG.info("replying with UnsubAck to MSG ID {}", (Object)messageID);
        session.write(ackMessage);
    }

    public void processSubscribe(ServerChannel session, SubscribeMessage msg) {
        String clientID = (String)session.getAttribute(NettyChannel.ATTR_KEY_CLIENTID);
        LOG.debug("SUBSCRIBE client <{}> packetID {}", (Object)clientID, (Object)msg.getMessageID());
        ClientSession clientSession = this.m_sessionsStore.sessionForClient(clientID);
        this.verifyToActivate(clientID, clientSession);
        SubAckMessage ackMessage = new SubAckMessage();
        ackMessage.setMessageID(msg.getMessageID());
        ArrayList<Subscription> newSubscriptions = new ArrayList<Subscription>();
        for (SubscribeMessage.Couple req : msg.subscriptions()) {
            AbstractMessage.QOSType qos = AbstractMessage.QOSType.valueOf(req.getQos());
            Subscription newSubscription = new Subscription(clientID, req.getTopicFilter(), qos);
            boolean valid = clientSession.subscribe(req.getTopicFilter(), newSubscription);
            ackMessage.addType(valid ? qos : AbstractMessage.QOSType.FAILURE);
            if (!valid) continue;
            newSubscriptions.add(newSubscription);
        }
        LOG.debug("SUBACK for packetID {}", (Object)msg.getMessageID());
        if (LOG.isTraceEnabled()) {
            LOG.trace("subscription tree {}", (Object)this.subscriptions.dumpTree());
        }
        session.write(ackMessage);
        for (Subscription subscription : newSubscriptions) {
            this.subscribeSingleTopic(subscription);
        }
    }

    private boolean subscribeSingleTopic(final Subscription newSubscription) {
        this.subscriptions.add(newSubscription.asClientTopicCouple());
        Collection<IMessagesStore.StoredMessage> messages = this.m_messagesStore.searchMatching(new IMatchingCondition(){

            @Override
            public boolean match(String key) {
                return SubscriptionsStore.matchTopics(key, newSubscription.getTopicFilter());
            }
        });
        ClientSession targetSession = this.m_sessionsStore.sessionForClient(newSubscription.getClientId());
        this.verifyToActivate(newSubscription.getClientId(), targetSession);
        for (IMessagesStore.StoredMessage storedMsg : messages) {
            LOG.debug("send publish message for topic {}", (Object)newSubscription.getTopicFilter());
            Integer packetID = storedMsg.getQos() == AbstractMessage.QOSType.MOST_ONE ? null : Integer.valueOf(targetSession.nextPacketId());
            this.directSend(targetSession, storedMsg.getTopic(), storedMsg.getQos(), storedMsg.getPayload(), true, packetID);
        }
        this.m_interceptor.notifyTopicSubscribed(newSubscription);
        return true;
    }

    static final class WillMessage {
        private final String topic;
        private final ByteBuffer payload;
        private final boolean retained;
        private final AbstractMessage.QOSType qos;

        public WillMessage(String topic, ByteBuffer payload, boolean retained, AbstractMessage.QOSType qos) {
            this.topic = topic;
            this.payload = payload;
            this.retained = retained;
            this.qos = qos;
        }

        public String getTopic() {
            return this.topic;
        }

        public ByteBuffer getPayload() {
            return this.payload;
        }

        public boolean isRetained() {
            return this.retained;
        }

        public AbstractMessage.QOSType getQos() {
            return this.qos;
        }
    }
}

