/*
 * Decompiled with CFR 0.152.
 */
package io.moquette.spi;

import io.moquette.proto.messages.AbstractMessage;
import io.moquette.spi.IMessagesStore;
import io.moquette.spi.ISessionsStore;
import io.moquette.spi.impl.subscriptions.Subscription;
import io.moquette.spi.impl.subscriptions.SubscriptionsStore;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClientSession {
    private static final Logger LOG = LoggerFactory.getLogger(ClientSession.class);
    public final String clientID;
    private final IMessagesStore messagesStore;
    private final ISessionsStore m_sessionsStore;
    private Set<Subscription> subscriptions = new HashSet<Subscription>();
    public final boolean cleanSession;
    private boolean active = false;

    public ClientSession(String clientID, IMessagesStore messagesStore, ISessionsStore sessionsStore, boolean cleanSession) {
        this.clientID = clientID;
        this.messagesStore = messagesStore;
        this.m_sessionsStore = sessionsStore;
        this.cleanSession = cleanSession;
    }

    public List<IMessagesStore.StoredMessage> storedMessages() {
        Collection<String> guids = this.m_sessionsStore.enqueued(this.clientID);
        return this.messagesStore.listMessagesInSession(guids);
    }

    public void removeEnqueued(String guid) {
        this.m_sessionsStore.removeEnqueued(this.clientID, guid);
    }

    public String toString() {
        return "ClientSession{clientID='" + this.clientID + '\'' + "}";
    }

    public boolean subscribe(String topicFilter, Subscription newSubscription) {
        LOG.info("<{}> subscribed to topicFilter <{}> with QoS {}", newSubscription.getClientId(), topicFilter, AbstractMessage.QOSType.formatQoS(newSubscription.getRequestedQos()));
        boolean validTopic = SubscriptionsStore.validate(newSubscription.getTopicFilter());
        if (!validTopic) {
            return false;
        }
        ISessionsStore.ClientTopicCouple matchingCouple = new ISessionsStore.ClientTopicCouple(this.clientID, newSubscription.getTopicFilter());
        Subscription existingSub = this.m_sessionsStore.getSubscription(matchingCouple);
        if (existingSub == null || existingSub.getRequestedQos().byteValue() < newSubscription.getRequestedQos().byteValue()) {
            if (existingSub != null) {
                this.subscriptions.remove(newSubscription);
            }
            this.subscriptions.add(newSubscription);
            this.m_sessionsStore.addNewSubscription(newSubscription);
        }
        return true;
    }

    public void unsubscribeFrom(String topicFilter) {
        this.m_sessionsStore.removeSubscription(topicFilter, this.clientID);
        HashSet<Subscription> subscriptionsToRemove = new HashSet<Subscription>();
        for (Subscription sub : this.subscriptions) {
            if (!sub.getTopicFilter().equals(topicFilter)) continue;
            subscriptionsToRemove.add(sub);
        }
        this.subscriptions.removeAll(subscriptionsToRemove);
    }

    public void disconnect() {
        if (this.cleanSession) {
            this.cleanSession();
        }
        this.deactivate();
    }

    public void cleanSession() {
        LOG.info("cleaning old saved subscriptions for client <{}>", (Object)this.clientID);
        this.m_sessionsStore.wipeSubscriptions(this.clientID);
        this.messagesStore.dropMessagesInSession(this.clientID);
    }

    public boolean isCleanSession() {
        return this.cleanSession;
    }

    public void activate() {
        this.active = true;
    }

    public void deactivate() {
        this.active = false;
    }

    public boolean isActive() {
        return this.active;
    }

    public int nextPacketId() {
        return this.m_sessionsStore.nextPacketID(this.clientID);
    }

    public void inFlightAcknowledged(int messageID) {
        this.m_sessionsStore.inFlightAck(this.clientID, messageID);
    }

    public void inFlightAckWaiting(String guid, int messageID) {
        this.m_sessionsStore.inFlight(this.clientID, messageID, guid);
    }

    public void secondPhaseAcknowledged(int messageID) {
        this.m_sessionsStore.secondPhaseAcknowledged(this.clientID, messageID);
    }

    public void secondPhaseAckWaiting(int messageID) {
        this.m_sessionsStore.secondPhaseAckWaiting(this.clientID, messageID);
    }

    public void enqueueToDeliver(String guid) {
        this.m_sessionsStore.bindToDeliver(guid, this.clientID);
    }

    public IMessagesStore.StoredMessage storedMessage(int messageID) {
        String guid = this.m_sessionsStore.mapToGuid(this.clientID, messageID);
        return this.messagesStore.getMessageByGuid(guid);
    }
}

