/*
 * Decompiled with CFR 0.152.
 */
package io.moquette.server.netty;

import io.moquette.server.ServerChannel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.timeout.IdleStateHandler;
import io.netty.util.Attribute;
import io.netty.util.AttributeKey;

public class NettyChannel
implements ServerChannel {
    private ChannelHandlerContext m_channel;
    public static final String ATTR_USERNAME = "username";
    public static final String ATTR_SESSION_STOLEN = "sessionStolen";
    public static final AttributeKey<Object> ATTR_KEY_KEEPALIVE = AttributeKey.valueOf((String)"keepAlive");
    public static final AttributeKey<Object> ATTR_KEY_CLEANSESSION = AttributeKey.valueOf((String)"cleanSession");
    public static final AttributeKey<Object> ATTR_KEY_CLIENTID = AttributeKey.valueOf((String)"ClientID");
    public static final AttributeKey<Object> ATTR_KEY_USERNAME = AttributeKey.valueOf((String)"username");
    public static final AttributeKey<Object> ATTR_KEY_SESSION_STOLEN = AttributeKey.valueOf((String)"sessionStolen");

    NettyChannel(ChannelHandlerContext ctx) {
        this.m_channel = ctx;
    }

    @Override
    public Object getAttribute(AttributeKey<Object> key) {
        Attribute attr = this.m_channel.attr(key);
        return attr.get();
    }

    @Override
    public void setAttribute(AttributeKey<Object> key, Object value) {
        Attribute attr = this.m_channel.attr(key);
        attr.set(value);
    }

    @Override
    public void setIdleTime(int idleTime) {
        if (this.m_channel.pipeline().names().contains("idleStateHandler")) {
            this.m_channel.pipeline().remove("idleStateHandler");
        }
        this.m_channel.pipeline().addFirst("idleStateHandler", (ChannelHandler)new IdleStateHandler(0, 0, idleTime));
    }

    @Override
    public void close(boolean immediately) {
        this.m_channel.close();
    }

    @Override
    public void write(Object value) {
        this.m_channel.writeAndFlush(value);
    }

    public String toString() {
        String clientID = (String)this.getAttribute(ATTR_KEY_CLIENTID);
        return "session [clientID: " + clientID + "]";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NettyChannel that = (NettyChannel)o;
        return !(this.m_channel == null ? that.m_channel != null : !this.m_channel.channel().equals(that.m_channel.channel()));
    }

    public int hashCode() {
        return this.m_channel != null ? this.m_channel.channel().hashCode() : 0;
    }
}

